/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MarkEntriesAction;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.AddToGroupAction;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.RemoveFromGroupAction;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Quality;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.Relevance;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.specialfields.SpecialFieldValue;

public class RightClickMenu
extends JPopupMenu
implements PopupMenuListener {
    BasePanel panel;
    MetaData metaData;
    JMenu groupAddMenu = new JMenu(Globals.lang("Add to group"));
    JMenu groupRemoveMenu = new JMenu(Globals.lang("Remove from group"));
    JMenu groupMoveMenu = new JMenu(Globals.lang("Assign exclusively to group"));
    JMenu rankingMenu = new JMenu();
    JMenu priorityMenu = new JMenu();
    JMenu typeMenu = new JMenu(Globals.lang("Change entry type"));
    JCheckBoxMenuItem floatMarked = new JCheckBoxMenuItem(Globals.lang("Float marked entries"), Globals.prefs.getBoolean("floatMarkedEntries"));

    public RightClickMenu(BasePanel panel_, MetaData metaData_) {
        this.panel = panel_;
        this.metaData = metaData_;
        boolean multiple = this.panel.mainTable.getSelectedRowCount() > 1;
        BibtexEntry be = null;
        if (this.panel.mainTable.getSelectedRowCount() == 1) {
            be = (BibtexEntry)this.panel.mainTable.getSelected().get(0);
        }
        this.addPopupMenuListener(this);
        this.add(new AbstractAction(Globals.lang("Copy"), GUIGlobals.getImage("copy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("copy");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Paste"), GUIGlobals.getImage("paste")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("paste");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Cut"), GUIGlobals.getImage("cut")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("cut");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Delete"), GUIGlobals.getImage("delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("delete");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.addSeparator();
        this.add(new AbstractAction(Globals.lang("Export to clipboard")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("exportToClipboard");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Send as email")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("sendAsEmail");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.addSeparator();
        JMenu markSpecific = JabRefFrame.subMenu("Mark specific color");
        JabRefFrame frame = this.panel.frame;
        for (int i = 0; i < Util.MAX_MARKING_LEVEL; ++i) {
            markSpecific.add(new MarkEntriesAction(frame, i).getMenuItem());
        }
        if (multiple) {
            this.add(new AbstractAction(Globals.lang("Mark entries"), GUIGlobals.getImage("markEntries")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        RightClickMenu.this.panel.runCommand("markEntries");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.add(markSpecific);
            this.add(new AbstractAction(Globals.lang("Unmark entries"), GUIGlobals.getImage("unmarkEntries")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        RightClickMenu.this.panel.runCommand("unmarkEntries");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.addSeparator();
        } else if (be != null) {
            if (be.getField("__markedentry") == null) {
                this.add(new AbstractAction(Globals.lang("Mark entry"), GUIGlobals.getImage("markEntries")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            RightClickMenu.this.panel.runCommand("markEntries");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                this.add(markSpecific);
            } else {
                this.add(markSpecific);
                this.add(new AbstractAction(Globals.lang("Unmark entry"), GUIGlobals.getImage("unmarkEntries")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            RightClickMenu.this.panel.runCommand("unmarkEntries");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            this.addSeparator();
        }
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                RightClickMenu.populateSpecialFieldMenu(this.rankingMenu, Rank.getInstance(), this.panel.frame);
                this.add(this.rankingMenu);
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                this.add(Relevance.getInstance().getValues().get(0).getMenuAction(this.panel.frame));
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                this.add(Quality.getInstance().getValues().get(0).getMenuAction(this.panel.frame));
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                RightClickMenu.populateSpecialFieldMenu(this.priorityMenu, Priority.getInstance(), this.panel.frame);
                this.add(this.priorityMenu);
            }
            this.addSeparator();
        }
        this.add(new AbstractAction(Globals.lang("Open file"), GUIGlobals.getImage("openExternalFile")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("openExternalFile");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Attach file"), GUIGlobals.getImage("open")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("addFileLink");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Open URL or DOI"), GUIGlobals.getImage("www")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("openUrl");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Copy BibTeX key")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("copyKey");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Copy") + " \\cite{" + Globals.lang("BibTeX key") + "}"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("copyCiteKey");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.addSeparator();
        this.populateTypeMenu();
        this.add(this.typeMenu);
        this.add(new AbstractAction(Globals.lang("Plain text import")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("importPlainText");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(JabRef.jrf.massSetField);
        this.add(JabRef.jrf.manageKeywords);
        this.addSeparator();
        this.floatMarked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Globals.prefs.putBoolean("floatMarkedEntries", RightClickMenu.this.floatMarked.isSelected());
                RightClickMenu.this.panel.mainTable.refreshSorting();
            }
        });
    }

    public void populateTypeMenu() {
        this.typeMenu.removeAll();
        for (String key : BibtexEntryType.ALL_TYPES.keySet()) {
            this.typeMenu.add(new ChangeTypeAction(BibtexEntryType.getType(key), this.panel));
        }
    }

    public static void populateSpecialFieldMenu(JMenu menu, SpecialField field, JabRefFrame frame) {
        menu.setText(field.getMenuString());
        menu.setIcon(field.getRepresentingIcon());
        for (SpecialFieldValue val : field.getValues()) {
            menu.add(val.getMenuAction(frame));
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        BibtexEntry[] bes = this.panel.getSelectedEntries();
        this.panel.storeCurrentEdit();
        GroupTreeNode groups = this.metaData.getGroups();
        if (groups == null) {
            this.groupAddMenu.setEnabled(false);
            this.groupMoveMenu.setEnabled(false);
            this.groupRemoveMenu.setEnabled(false);
            return;
        }
        this.groupAddMenu.setEnabled(true);
        this.groupMoveMenu.setEnabled(true);
        this.groupRemoveMenu.setEnabled(true);
        this.groupAddMenu.removeAll();
        this.groupMoveMenu.removeAll();
        this.groupRemoveMenu.removeAll();
        if (bes == null) {
            return;
        }
        this.add(this.groupAddMenu);
        this.add(this.groupMoveMenu);
        this.add(this.groupRemoveMenu);
        this.groupAddMenu.setEnabled(false);
        this.groupMoveMenu.setEnabled(false);
        this.groupRemoveMenu.setEnabled(false);
        this.insertNodes(this.groupAddMenu, this.metaData.getGroups(), bes, true, false);
        this.insertNodes(this.groupMoveMenu, this.metaData.getGroups(), bes, true, true);
        this.insertNodes(this.groupRemoveMenu, this.metaData.getGroups(), bes, false, false);
        this.addSeparator();
        this.floatMarked.setSelected(Globals.prefs.getBoolean("floatMarkedEntries"));
        this.add(this.floatMarked);
    }

    public void insertNodes(JMenu menu, GroupTreeNode node, BibtexEntry[] selection, boolean add, boolean move) {
        AbstractAction action = this.getAction(node, selection, add, move);
        if (node.getChildCount() == 0) {
            JMenuItem menuItem = new JMenuItem(action);
            this.setGroupFontAndIcon(menuItem, node.getGroup());
            menu.add(menuItem);
            if (action.isEnabled()) {
                menu.setEnabled(true);
            }
            return;
        }
        JMenu submenu = null;
        if (node.getGroup() instanceof AllEntriesGroup) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.insertNodes(menu, (GroupTreeNode)node.getChildAt(i), selection, add, move);
            }
        } else {
            submenu = new JMenu("[" + node.getGroup().getName() + "]");
            this.setGroupFontAndIcon(submenu, node.getGroup());
            submenu.setEnabled(action.isEnabled());
            JMenuItem menuItem = new JMenuItem(action);
            this.setGroupFontAndIcon(menuItem, node.getGroup());
            submenu.add(menuItem);
            submenu.add(new JPopupMenu.Separator());
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.insertNodes(submenu, (GroupTreeNode)node.getChildAt(i), selection, add, move);
            }
            menu.add(submenu);
            if (submenu.isEnabled()) {
                menu.setEnabled(true);
            }
        }
    }

    private void setGroupFontAndIcon(JMenuItem menuItem, AbstractGroup group) {
        if (Globals.prefs.getBoolean("groupShowDynamic")) {
            menuItem.setFont(menuItem.getFont().deriveFont(group.isDynamic() ? 2 : 0));
        }
        if (Globals.prefs.getBoolean("groupShowIcons")) {
            switch (group.getHierarchicalContext()) {
                case 2: {
                    menuItem.setIcon(GUIGlobals.getImage("groupIncluding"));
                    break;
                }
                case 1: {
                    menuItem.setIcon(GUIGlobals.getImage("groupRefining"));
                    break;
                }
                default: {
                    menuItem.setIcon(GUIGlobals.getImage("groupRegular"));
                }
            }
        }
    }

    private AbstractAction getAction(GroupTreeNode node, BibtexEntry[] selection, boolean add, boolean move) {
        AbstractAction action = add ? new AddToGroupAction(node, move, this.panel) : new RemoveFromGroupAction(node, this.panel);
        AbstractGroup group = node.getGroup();
        if (!move) {
            action.setEnabled(add ? group.supportsAdd() && !group.containsAll(selection) : group.supportsRemove() && group.containsAny(selection));
        } else {
            action.setEnabled(group.supportsAdd());
        }
        return action;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.remove(this.groupAddMenu);
        this.remove(this.groupMoveMenu);
        this.remove(this.groupRemoveMenu);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    class ChangeTypeAction
    extends AbstractAction {
        BibtexEntryType type;
        BasePanel panel;

        public ChangeTypeAction(BibtexEntryType type, BasePanel bp) {
            super(type.getName());
            this.type = type;
            this.panel = bp;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.panel.changeType(this.type);
        }
    }
}

