/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsDialog3;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.external.ExternalFileTypeEditor;
import net.sf.jabref.external.PushToApplication;
import net.sf.jabref.external.PushToApplicationButton;
import net.sf.jabref.external.PushToEmacs;
import net.sf.jabref.external.PushToLatexEditor;
import net.sf.jabref.external.PushToLyx;
import net.sf.jabref.external.PushToTeXstudio;
import net.sf.jabref.external.PushToVim;
import net.sf.jabref.external.PushToWinEdt;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.help.HelpDialog;

public class ExternalTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    JTextField pdfDir;
    JTextField regExpTextField;
    JTextField fileDir;
    JTextField psDir;
    JTextField emailSubject;
    JCheckBox bibLocationAsFileDir;
    JCheckBox bibLocAsPrimaryDir;
    JCheckBox runAutoFileSearch;
    JCheckBox allowFileAutoOpenBrowse;
    JCheckBox openFoldersOfAttachedFiles;
    JButton editFileTypes;
    ItemListener regExpListener;
    JRadioButton useRegExpComboBox;
    JRadioButton matchExactKeyOnly = new JRadioButton(Globals.lang("Autolink only files that match the BibTeX key"));
    JRadioButton matchStartsWithKey = new JRadioButton(Globals.lang("Autolink files with names starting with the BibTeX key"));

    public ExternalTab(JabRefFrame frame, PrefsDialog3 prefsDiag, JabRefPreferences prefs, HelpDialog helpDialog) {
        this._prefs = prefs;
        this._frame = frame;
        this.setLayout(new BorderLayout());
        this.psDir = new JTextField(25);
        this.pdfDir = new JTextField(25);
        this.fileDir = new JTextField(25);
        this.bibLocationAsFileDir = new JCheckBox(Globals.lang("Allow file links relative to each bib file's location"));
        this.bibLocAsPrimaryDir = new JCheckBox(Globals.lang("Use the bib file location as primary file directory"));
        this.bibLocAsPrimaryDir.setToolTipText(Globals.lang("When downloading files, or moving linked files to the file directory, prefer the bib file location rather than the file directory set above"));
        this.bibLocationAsFileDir.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ExternalTab.this.bibLocAsPrimaryDir.setEnabled(ExternalTab.this.bibLocationAsFileDir.isSelected());
            }
        });
        this.editFileTypes = new JButton(Globals.lang("Manage external file types"));
        this.runAutoFileSearch = new JCheckBox(Globals.lang("When opening file link, search for matching file if no link is defined"));
        this.allowFileAutoOpenBrowse = new JCheckBox(Globals.lang("Automatically open browse dialog when creating new file link"));
        this.regExpTextField = new JTextField(25);
        this.useRegExpComboBox = new JRadioButton(Globals.lang("Use Regular Expression Search"));
        this.regExpListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExternalTab.this.regExpTextField.setEditable(ExternalTab.this.useRegExpComboBox.isSelected());
            }
        };
        this.useRegExpComboBox.addItemListener(this.regExpListener);
        this.editFileTypes.addActionListener(ExternalFileTypeEditor.getAction(prefsDiag));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.matchExactKeyOnly);
        bg.add(this.matchStartsWithKey);
        bg.add(this.useRegExpComboBox);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Globals.lang("External file links"));
        JPanel pan = new JPanel();
        builder.append(pan);
        JLabel lab = new JLabel(Globals.lang("Main file directory") + ":");
        builder.append(lab);
        builder.append(this.fileDir);
        BrowseAction browse = new BrowseAction(this._frame, this.fileDir, true);
        builder.append(new JButton(browse));
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.bibLocationAsFileDir, 3);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.bibLocAsPrimaryDir, 3);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.matchStartsWithKey, 3);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.matchExactKeyOnly, 3);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(this.useRegExpComboBox);
        builder.append(this.regExpTextField);
        HelpAction helpAction = new HelpAction(helpDialog, "ExternalFiles.html#RegularExpressionSearch", Globals.lang("Help on Regular Expression Search"), GUIGlobals.getIconUrl("helpSmall"));
        builder.append(helpAction.getIconButton());
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.runAutoFileSearch, 3);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(this.allowFileAutoOpenBrowse);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Sending of emails"));
        builder.append(new JPanel());
        lab = new JLabel(Globals.lang("Subject for sending an email with references").concat(":"));
        builder.append(lab);
        this.emailSubject = new JTextField(25);
        builder.append(this.emailSubject);
        builder.nextLine();
        builder.append(new JPanel());
        this.openFoldersOfAttachedFiles = new JCheckBox(Globals.lang("Automatically open folders of attached files"));
        builder.append(this.openFoldersOfAttachedFiles);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Legacy file fields"));
        pan = new JPanel();
        builder.append(pan);
        builder.append((Component)new JLabel("<html>" + Globals.lang("Note that these settings are used for the legacy <b>pdf</b> and <b>ps</b> fields only.<br>For most users, setting the <b>Main file directory</b> above should be sufficient.") + "</html>"), 5);
        builder.nextLine();
        pan = new JPanel();
        builder.append(pan);
        lab = new JLabel(Globals.lang("Main PDF directory") + ":");
        builder.append(lab);
        builder.append(this.pdfDir);
        browse = new BrowseAction(this._frame, this.pdfDir, true);
        builder.append(new JButton(browse));
        builder.nextLine();
        pan = new JPanel();
        builder.append(pan);
        lab = new JLabel(Globals.lang("Main PS directory") + ":");
        builder.append(lab);
        builder.append(this.psDir);
        browse = new BrowseAction(this._frame, this.psDir, true);
        builder.append(new JButton(browse));
        builder.nextLine();
        builder.appendSeparator(Globals.lang("External programs"));
        builder.nextLine();
        JPanel butpan = new JPanel();
        butpan.setLayout(new GridLayout(2, 3));
        this.addSettingsButton(new PushToLyx(), butpan);
        this.addSettingsButton(new PushToEmacs(), butpan);
        this.addSettingsButton(new PushToWinEdt(), butpan);
        this.addSettingsButton(new PushToVim(), butpan);
        this.addSettingsButton(new PushToLatexEditor(), butpan);
        this.addSettingsButton(new PushToTeXstudio(), butpan);
        builder.append(new JPanel());
        builder.append((Component)butpan, 3);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.editFileTypes);
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    private void addSettingsButton(final PushToApplication pt, JPanel p) {
        JButton button = new JButton(Globals.lang("Settings for %0", pt.getApplicationName()), pt.getIcon());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PushToApplicationButton.showSettingsDialog(ExternalTab.this._frame, pt, pt.getSettingsPanel());
            }
        });
        p.add(button);
    }

    @Override
    public void setValues() {
        this.pdfDir.setText(this._prefs.get("pdfDirectory"));
        this.psDir.setText(this._prefs.get("psDirectory"));
        this.fileDir.setText(this._prefs.get("fileDirectory"));
        this.bibLocationAsFileDir.setSelected(this._prefs.getBoolean("bibLocationAsFileDir"));
        this.bibLocAsPrimaryDir.setSelected(this._prefs.getBoolean("bibLocAsPrimaryDir"));
        this.bibLocAsPrimaryDir.setEnabled(this.bibLocationAsFileDir.isSelected());
        this.runAutoFileSearch.setSelected(this._prefs.getBoolean("runAutomaticFileSearch"));
        this.regExpTextField.setText(this._prefs.get("regExpSearchExpression"));
        this.allowFileAutoOpenBrowse.setSelected(this._prefs.getBoolean("allowFileAutoOpenBrowse"));
        this.emailSubject.setText(this._prefs.get("emailSubject"));
        this.openFoldersOfAttachedFiles.setSelected(this._prefs.getBoolean("openFoldersOfAttachedFiles"));
        if (this._prefs.getBoolean("useRegExpSearch")) {
            this.useRegExpComboBox.setSelected(true);
        } else if (this._prefs.getBoolean("autolinkExactKeyOnly")) {
            this.matchExactKeyOnly.setSelected(true);
        } else {
            this.matchStartsWithKey.setSelected(true);
        }
    }

    @Override
    public void storeSettings() {
        this._prefs.putBoolean("useRegExpSearch", this.useRegExpComboBox.isSelected());
        if (this.useRegExpComboBox.isSelected()) {
            this._prefs.put("regExpSearchExpression", this.regExpTextField.getText());
        }
        this._prefs.put("pdfDirectory", this.pdfDir.getText());
        this._prefs.put("psDirectory", this.psDir.getText());
        this._prefs.put("fileDirectory", this.fileDir.getText());
        this._prefs.putBoolean("bibLocationAsFileDir", this.bibLocationAsFileDir.isSelected());
        this._prefs.putBoolean("bibLocAsPrimaryDir", this.bibLocAsPrimaryDir.isSelected());
        this._prefs.putBoolean("autolinkExactKeyOnly", this.matchExactKeyOnly.isSelected());
        this._prefs.putBoolean("runAutomaticFileSearch", this.runAutoFileSearch.isSelected());
        this._prefs.putBoolean("allowFileAutoOpenBrowse", this.allowFileAutoOpenBrowse.isSelected());
        this._prefs.put("emailSubject", this.emailSubject.getText());
        this._prefs.putBoolean("openFoldersOfAttachedFiles", this.openFoldersOfAttachedFiles.isSelected());
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("External programs");
    }
}

