/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;

public class EntryTypeDialog
extends JDialog
implements ActionListener {
    BibtexEntryType type = null;
    CancelAction cancelAction = new CancelAction();
    private final int COLNUM = 3;

    public EntryTypeDialog(JabRefFrame baseFrame_) {
        super((Frame)baseFrame_, true);
        this.setTitle(Globals.lang("Select entry type"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EntryTypeDialog.this.cancelAction.actionPerformed(null);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel pan = new JPanel();
        this.getContentPane().add((Component)pan, "Center");
        JPanel buttons = new JPanel();
        JButton cancel = new JButton(Globals.lang("Cancel"));
        cancel.addActionListener(this);
        cancel.getInputMap(2).put(baseFrame_.prefs.getKey("Close dialog"), "close");
        cancel.getActionMap().put("close", this.cancelAction);
        ButtonBarBuilder bb = new ButtonBarBuilder(buttons);
        bb.addGlue();
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        this.getContentPane().add((Component)buttons, "South");
        GridBagLayout gbl = new GridBagLayout();
        pan.setLayout(gbl);
        GridBagConstraints con = new GridBagConstraints();
        con.anchor = 17;
        con.fill = 2;
        con.insets = new Insets(4, 4, 4, 4);
        int col = 0;
        for (BibtexEntryType tp : BibtexEntryType.ALL_TYPES.values()) {
            if (!tp.isVisibleAtNewEntryDialog()) continue;
            TypeButton b = new TypeButton(Util.nCase(tp.getName()), tp);
            b.addActionListener(this);
            if (++col == 3) {
                col = 0;
                con.gridwidth = 0;
            } else {
                con.gridwidth = 1;
            }
            gbl.setConstraints(b, con);
            pan.add(b);
        }
        pan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Entry types")));
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof TypeButton) {
            this.type = ((TypeButton)e.getSource()).type;
        }
        this.dispose();
    }

    public BibtexEntryType getChoice() {
        return this.type;
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryTypeDialog.this.dispose();
        }
    }

    class TypeButton
    extends JButton
    implements Comparable<TypeButton> {
        BibtexEntryType type;

        public TypeButton(String label, BibtexEntryType type_) {
            super(label);
            this.type = type_;
        }

        @Override
        public int compareTo(TypeButton o) {
            return this.type.getName().compareTo(o.type.getName());
        }
    }
}

