/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import net.sf.profiler4j.agent.Log;
import net.sf.profiler4j.agent.ThreadProfiler;
import net.sf.profiler4j.console.client.Snapshot;

public final class SnapshotUtil {
    public static final Comparator<Snapshot.Method> byNetTimeComparator = new Comparator<Snapshot.Method>(){

        @Override
        public int compare(Snapshot.Method g1, Snapshot.Method g2) {
            return Double.compare(g1.getNetTime(), g2.getNetTime());
        }

        public String toString() {
            return "BY_TOTAL_TIME";
        }
    };
    public static final Comparator<Snapshot.Method> bySelfTimeComparator = new Comparator<Snapshot.Method>(){

        @Override
        public int compare(Snapshot.Method g1, Snapshot.Method g2) {
            return (int)(-Math.signum(g1.getSelfTime() - g2.getSelfTime()));
        }

        public String toString() {
            return "BY_TOTAL_LOCAL_TIME";
        }
    };
    public static final Comparator<Snapshot.Method> byHitsComparator = new Comparator<Snapshot.Method>(){

        @Override
        public int compare(Snapshot.Method g1, Snapshot.Method g2) {
            return -SnapshotUtil.compareLong(g1.getHits(), g2.getHits());
        }

        public String toString() {
            return "BY_HITS";
        }
    };

    public static void saveSnapshot() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd_HHmmss");
        File file = new File("snapshot_" + fmt.format(new Date()) + ".p4j");
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ThreadProfiler.createSnapshot(fos);
            fos.close();
            Log.print(0, "Written snapshot to " + file.getAbsolutePath());
        }
        catch (Exception e) {
            Log.print(0, "Could not write snapshot", e);
        }
    }

    private static int compareLong(long l1, long l2) {
        return l1 > l2 ? 1 : (l1 < l2 ? -1 : 0);
    }
}

