/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Host;
import org.apache.catalina.core.StandardServer;
import org.glassfish.logging.annotation.LogMessageInfo;

public class ExpandWar {
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="Application base directory {0} does not exist", level="WARNING")
    public static final String APP_NOT_EXIST_EXCEPTION = "AS-WEB-CORE-00444";
    @LogMessageInfo(message="Unable to create the directory [{0}]", level="WARNING")
    public static final String UNABLE_CREATE_DIRECTORY_EXCEPTION = "AS-WEB-CORE-00445";
    @LogMessageInfo(message="The archive [{0}] is malformed and will be ignored: an entry contains an illegal path [{1}]", level="WARNING")
    public static final String ARCHIVE_IS_MALFORMED_EXCEPTION = "AS-WEB-CORE-00446";
    @LogMessageInfo(message="Failed to set last-modified time of the file {0}", level="WARNING")
    public static final String FAILED_SET_LAST_MODIFIED_TIME_EXCEPTION = "AS-WEB-CORE-00447";
    @LogMessageInfo(message="Error copying {0} to {1}", level="SEVERE", cause="Could not copy file", action="Verify if channel is not available for file transfer")
    public static final String ERROR_COPYING_EXCEPTION = "AS-WEB-CORE-00448";
    @LogMessageInfo(message="[{0}] could not be completely deleted. The presence of the remaining files may cause problems", level="SEVERE", cause="Could not completely delete specified directory", action="Verify the access permission to specified directory")
    public static final String DELETE_DIR_EXCEPTION = "AS-WEB-CORE-00449";

    public static String expand(Host host, URL war) throws IOException {
        int slash;
        int period;
        String pathname = war.toString().replace('\\', '/');
        if (pathname.endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        return ExpandWar.expand(host, war, pathname);
    }

    public static String expand(Host host, URL war, String pathname) throws IOException {
        File appBase = new File(host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        if (!appBase.exists() || !appBase.isDirectory()) {
            String msg = MessageFormat.format(rb.getString(APP_NOT_EXIST_EXCEPTION), appBase.getAbsolutePath());
            throw new IOException(msg);
        }
        File docBase = new File(appBase, pathname);
        if (docBase.exists()) {
            return docBase.getAbsolutePath();
        }
        if (!docBase.mkdir()) {
            String msg = MessageFormat.format(rb.getString(UNABLE_CREATE_DIRECTORY_EXCEPTION), docBase);
            throw new IOException(msg);
        }
        String canonicalDocBasePrefix = docBase.getCanonicalPath();
        if (!canonicalDocBasePrefix.endsWith(File.separator)) {
            canonicalDocBasePrefix = canonicalDocBasePrefix + File.separator;
        }
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        InputStream input = null;
        boolean success = false;
        try {
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                File parent;
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File expandedFile = new File(docBase, name);
                if (!expandedFile.getCanonicalPath().startsWith(canonicalDocBasePrefix)) {
                    String msg = MessageFormat.format(rb.getString(ARCHIVE_IS_MALFORMED_EXCEPTION), war, name);
                    throw new IllegalArgumentException(msg);
                }
                int last = name.lastIndexOf(47);
                if (last >= 0 && !(parent = new File(docBase, name.substring(0, last))).mkdirs() && !parent.isDirectory()) {
                    String msg = MessageFormat.format(rb.getString(UNABLE_CREATE_DIRECTORY_EXCEPTION), parent);
                    throw new IOException(msg);
                }
                if (name.endsWith("/")) continue;
                input = jarFile.getInputStream(jarEntry);
                ExpandWar.expand(input, expandedFile);
                long lastModified = jarEntry.getTime();
                if (lastModified != -1L && lastModified != 0L && !expandedFile.setLastModified(lastModified) && log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, FAILED_SET_LAST_MODIFIED_TIME_EXCEPTION, expandedFile.getAbsolutePath());
                }
                input.close();
                input = null;
            }
            success = true;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (!success) {
                ExpandWar.deleteDir(docBase);
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable t) {}
                input = null;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
                jarFile = null;
            }
        }
        return docBase.getAbsolutePath();
    }

    public static void validate(Host host, URL war, String pathname) throws IOException {
        File docBase;
        String canonicalDocBasePrefix;
        File appBase = new File(host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        if (!(canonicalDocBasePrefix = (docBase = new File(appBase, pathname)).getCanonicalPath()).endsWith(File.separator)) {
            canonicalDocBasePrefix = canonicalDocBasePrefix + File.separator;
        }
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        try {
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File expandedFile = new File(docBase, name);
                if (expandedFile.getCanonicalPath().startsWith(canonicalDocBasePrefix)) continue;
                String msg = MessageFormat.format(rb.getString(ARCHIVE_IS_MALFORMED_EXCEPTION), war, name);
                throw new IllegalArgumentException(msg);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
                jarFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = ExpandWar.copy(fileSrc, fileDest);
                continue;
            }
            FileChannel ic = null;
            AbstractInterruptibleChannel oc = null;
            try {
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                continue;
            }
            catch (IOException e) {
                String msg = MessageFormat.format(rb.getString(ERROR_COPYING_EXCEPTION), fileSrc, fileDest);
                log.log(Level.SEVERE, msg, e);
                result = false;
                continue;
            }
            finally {
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (IOException e) {}
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        return ExpandWar.delete(dir, true);
    }

    public static boolean delete(File dir, boolean logFailure) {
        boolean result = dir.isDirectory() ? ExpandWar.deleteDir(dir, logFailure) : (dir.exists() ? dir.delete() : true);
        if (logFailure && !result) {
            log.log(Level.SEVERE, DELETE_DIR_EXCEPTION, dir.getAbsolutePath());
        }
        return result;
    }

    public static boolean deleteDir(File dir) {
        return ExpandWar.deleteDir(dir, true);
    }

    public static boolean deleteDir(File dir, boolean logFailure) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                ExpandWar.deleteDir(file, logFailure);
                continue;
            }
            if (file.delete() || !logFailure) continue;
            log.log(Level.SEVERE, DELETE_DIR_EXCEPTION, file.getAbsolutePath());
        }
        boolean result = dir.exists() ? dir.delete() : true;
        if (logFailure && !result) {
            log.log(Level.SEVERE, DELETE_DIR_EXCEPTION, dir.getAbsolutePath());
        }
        return result;
    }

    protected static void expand(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        ExpandWar.expand(input, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(InputStream input, File file) throws IOException {
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

