/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.utils.version.VersionTable;

public class PropertyImpl
implements Property {
    private final String name;
    private final String type;
    private final String value;

    public PropertyImpl(String name, String type, String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public Object getConvertedValue() {
        return PropertyImpl.convert(this.value, this.type);
    }

    private static Object convert(String value, String type) {
        try {
            if (value != null && type != null) {
                if ("version".equalsIgnoreCase(type)) {
                    return VersionTable.getVersion(value);
                }
                if ("uri".equalsIgnoreCase(type)) {
                    return new URI(value);
                }
                if ("url".equalsIgnoreCase(type)) {
                    return new URL(value);
                }
                if ("long".equalsIgnoreCase(type)) {
                    return new Long(value);
                }
                if ("double".equalsIgnoreCase(type)) {
                    return new Double(value);
                }
                if ("set".equalsIgnoreCase(type)) {
                    StringTokenizer st = new StringTokenizer(value, ",");
                    HashSet<String> s = new HashSet<String>();
                    while (st.hasMoreTokens()) {
                        s.add(st.nextToken().trim());
                    }
                    return s;
                }
            }
            return value;
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }
}

