/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.undo.CopyOperation;
import org.rssowl.ui.internal.undo.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveOperation
extends CopyOperation {
    private final Map<INews.State, List<NewsReference>> fOriginalNews;
    private final boolean fIsArchive;

    public MoveOperation(List<INews> originalnews, List<INews> copiednews, boolean isArchive) {
        super(copiednews);
        this.fIsArchive = isArchive;
        Assert.isTrue((originalnews.size() == copiednews.size() ? 1 : 0) != 0);
        this.fOriginalNews = CoreUtils.toStateMap(originalnews);
    }

    @Override
    public String getName() {
        return this.fIsArchive ? NLS.bind((String)Messages.MoveOperation_ARCHIVE_N, (Object)this.fNewsCount) : NLS.bind((String)Messages.MoveOperation_MOVE_N, (Object)this.fNewsCount);
    }

    @Override
    public void undo() {
        super.undo();
        Set<Map.Entry<INews.State, List<NewsReference>>> entries = this.fOriginalNews.entrySet();
        for (Map.Entry<INews.State, List<NewsReference>> entry : entries) {
            INews.State oldState = entry.getKey();
            List<NewsReference> newsRefs = entry.getValue();
            ArrayList<INews> resolvedNews = new ArrayList<INews>(newsRefs.size());
            for (NewsReference newsRef : newsRefs) {
                INews news = newsRef.resolve();
                if (news == null) continue;
                resolvedNews.add(news);
            }
            Controller.getDefault().getSavedSearchService().forceQuickUpdate();
            this.fNewsDao.setState(resolvedNews, oldState, false, false);
        }
    }

    @Override
    public void redo() {
        super.redo();
        Controller.getDefault().getSavedSearchService().forceQuickUpdate();
        ((INewsDAO)DynamicDAO.getDAO(INewsDAO.class)).setState((Collection)CoreUtils.resolveAll(this.fOriginalNews), INews.State.HIDDEN, false, false);
    }
}

