/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.preferences;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.NewsFiltersListDialog;
import org.rssowl.ui.internal.dialogs.preferences.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.views.explorer.BookMarkLabelProvider;
import org.rssowl.ui.internal.views.explorer.BookMarkSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifierPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.rssowl.ui.NotifierPreferences";
    private IPreferenceScope fGlobalScope = Owl.getPreferenceService().getGlobalScope();
    private Button fNotificationOnlyFromTray;
    private Button fShowNotificationPopup;
    private Button fLimitNotificationCheck;
    private Spinner fLimitNotificationSpinner;
    private CheckboxTreeViewer fViewer;
    private Button fDeselectAll;
    private Button fSelectAll;
    private Button fLimitNotifierToSelectionCheck;
    private Spinner fAutoCloseNotifierSpinner;
    private Button fAutoCloseNotifierCheck;
    private Button fShowExcerptCheck;
    private Button fCloseNotifierOnOpen;
    private Button fFadeNotifierCheck;
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());

    public NotifierPreferencesPage() {
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/notification.gif"));
    }

    public NotifierPreferencesPage(String title) {
        super(title);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateApplyEnablement(false);
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite container = this.createComposite(parent);
        this.createNotificationOptions(container);
        Composite infoContainer = new Composite(container, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        Label infoImg = new Label(infoContainer, 0);
        infoImg.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/info.gif"));
        infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Link infoText = new Link(infoContainer, 64);
        infoText.setText(Messages.NotifierPreferencesPage_NOTIFIER_TIP);
        infoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        infoText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFiltersListDialog dialog = NewsFiltersListDialog.getVisibleInstance();
                if (dialog == null) {
                    dialog = new NewsFiltersListDialog(NotifierPreferencesPage.this.getShell());
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                } else {
                    dialog.getShell().forceActive();
                    if (dialog.getShell().getMinimized()) {
                        dialog.getShell().setMinimized(false);
                    }
                }
            }
        });
        this.applyDialogFont(container);
        OwlUI.runOnSelection(new Runnable(){

            public void run() {
                NotifierPreferencesPage.this.updateApplyEnablement(true);
            }
        }, new Control[]{container});
        return container;
    }

    private void createNotifierViewer(Composite container) {
        this.fLimitNotifierToSelectionCheck = new Button(container, 32);
        this.fLimitNotifierToSelectionCheck.setText(Messages.NotifierPreferencesPage_SHOW_FOR_SELECTED);
        this.fLimitNotifierToSelectionCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.LIMIT_NOTIFIER_TO_SELECTION));
        this.fLimitNotifierToSelectionCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifierPreferencesPage.this.setLimitNotificationEnabled(NotifierPreferencesPage.this.fLimitNotifierToSelectionCheck.getSelection());
            }
        });
        this.fViewer = new CheckboxTreeViewer(container, 2048);
        this.fViewer.setAutoExpandLevel(2);
        this.fViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.fViewer.getTree().getLayoutData()).heightHint = 190;
        this.fViewer.getTree().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        if (Owl.getPreferenceService().getGlobalScope().getBoolean(DefaultPreferences.BE_SORT_BY_NAME)) {
            BookMarkSorter sorter = new BookMarkSorter();
            sorter.setType(BookMarkSorter.Type.SORT_BY_NAME);
            this.fViewer.setComparator((ViewerComparator)sorter);
        }
        this.fViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                Set rootFolders = CoreUtils.loadRootFolders();
                return rootFolders.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IFolder) {
                    IFolder folder = (IFolder)parentElement;
                    return folder.getChildren().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    return folder.getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    return !folder.isEmpty();
                }
                return false;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new BookMarkLabelProvider(false, true));
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof INewsBin);
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IFolder folder;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IFolder iFolder = folder = selection.getFirstElement() instanceof IFolder ? (IFolder)selection.getFirstElement() : null;
                if (folder != null && !folder.isEmpty()) {
                    boolean expandedState = !NotifierPreferencesPage.this.fViewer.getExpandedState((Object)folder);
                    NotifierPreferencesPage.this.fViewer.setExpandedState((Object)folder, expandedState);
                    if (expandedState && NotifierPreferencesPage.this.fViewer.getChecked((Object)folder)) {
                        NotifierPreferencesPage.this.setChildsChecked((IFolderChild)folder, true, true);
                    }
                }
            }
        });
        this.fViewer.setInput(new Object());
        Collection rootFolders = ((IFolderDAO)DynamicDAO.getDAO(IFolderDAO.class)).loadRoots();
        for (IFolder folder : rootFolders) {
            this.setCheckedElements((IFolderChild)folder, false);
        }
        this.fViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TreeItem item = (TreeItem)e.item;
                    NotifierPreferencesPage.this.setChildsChecked((IFolderChild)item.getData(), item.getChecked(), false);
                    if (!item.getChecked()) {
                        NotifierPreferencesPage.this.setParentsChecked((IFolderChild)item.getData(), false);
                    }
                }
            }
        });
        this.fViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                boolean isChecked = NotifierPreferencesPage.this.fViewer.getChecked(event.getElement());
                if (isChecked) {
                    NotifierPreferencesPage.this.setChildsChecked((IFolderChild)event.getElement(), isChecked, false);
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        buttonContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSelectAll = new Button(buttonContainer, 8);
        this.fSelectAll.setText(Messages.NotifierPreferencesPage_SELECT_ALL);
        Dialog.applyDialogFont((Control)this.fSelectAll);
        this.setButtonLayoutData(this.fSelectAll);
        this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OwlUI.setAllChecked(NotifierPreferencesPage.this.fViewer.getTree(), true);
            }
        });
        this.fDeselectAll = new Button(buttonContainer, 8);
        this.fDeselectAll.setText(Messages.NotifierPreferencesPage_DESELECT_ALL);
        Dialog.applyDialogFont((Control)this.fDeselectAll);
        this.setButtonLayoutData(this.fDeselectAll);
        this.fDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OwlUI.setAllChecked(NotifierPreferencesPage.this.fViewer.getTree(), false);
            }
        });
        this.setLimitNotificationEnabled(this.fLimitNotifierToSelectionCheck.getSelection());
    }

    private void setCheckedElements(IFolderChild entity, boolean parentChecked) {
        IPreferenceScope prefs = Owl.getPreferenceService().getEntityScope((IEntity)entity);
        if (prefs.getBoolean(DefaultPreferences.ENABLE_NOTIFIER)) {
            if (!parentChecked) {
                this.setParentsExpanded(entity);
                parentChecked = true;
            }
            this.fViewer.setChecked((Object)entity, true);
            this.setChildsChecked(entity, true, true);
        }
        if (entity instanceof IFolder) {
            List children = ((IFolder)entity).getChildren();
            for (IFolderChild child : children) {
                this.setCheckedElements(child, parentChecked);
            }
        }
    }

    private void setParentsExpanded(IFolderChild folderChild) {
        IFolder parent = folderChild.getParent();
        if (parent != null) {
            this.fViewer.setExpandedState((Object)parent, true);
            this.setParentsExpanded((IFolderChild)parent);
        }
    }

    private void setLimitNotificationEnabled(boolean selection) {
        this.fViewer.getTree().setEnabled(selection);
        this.fSelectAll.setEnabled(selection);
        this.fDeselectAll.setEnabled(selection);
    }

    private void setChildsChecked(IFolderChild folderChild, boolean checked, boolean onlyExpanded) {
        if (folderChild instanceof IFolder && (!onlyExpanded || this.fViewer.getExpandedState((Object)folderChild))) {
            List children = ((IFolder)folderChild).getChildren();
            for (IFolderChild child : children) {
                this.fViewer.setChecked((Object)child, checked);
                this.setChildsChecked(child, checked, onlyExpanded);
            }
        }
    }

    private void setParentsChecked(IFolderChild folderChild, boolean checked) {
        IFolder parent = folderChild.getParent();
        if (parent != null) {
            this.fViewer.setChecked((Object)parent, checked);
            this.setParentsChecked((IFolderChild)parent, checked);
        }
    }

    private void createNotificationOptions(Composite container) {
        Composite notificationGroup = new Composite(container, 0);
        notificationGroup.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        notificationGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(notificationGroup, 0);
        label.setText(Messages.NotifierPreferencesPage_GENERAL);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Composite group = new Composite(notificationGroup, 0);
        group.setLayout((Layout)LayoutUtils.createGridLayout(1, 7, 3));
        ((GridLayout)group.getLayout()).marginBottom = 5;
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite limitItemsContainer = new Composite(group, 0);
        limitItemsContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0, 0, 2, false));
        int notificationLimit = this.fGlobalScope.getInteger(DefaultPreferences.LIMIT_NOTIFICATION_SIZE);
        this.fLimitNotificationCheck = new Button(limitItemsContainer, 32);
        this.fLimitNotificationCheck.setText(Messages.NotifierPreferencesPage_SHOW_MAX_NEWS_START);
        this.fLimitNotificationCheck.setSelection(notificationLimit >= 0);
        this.fLimitNotificationCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifierPreferencesPage.this.fLimitNotificationSpinner.setEnabled(NotifierPreferencesPage.this.fLimitNotificationCheck.getSelection());
            }
        });
        this.fLimitNotificationSpinner = new Spinner(limitItemsContainer, 2048);
        this.fLimitNotificationSpinner.setMinimum(1);
        this.fLimitNotificationSpinner.setMaximum(30);
        this.fLimitNotificationSpinner.setEnabled(this.fLimitNotificationCheck.getSelection());
        if (notificationLimit > 0) {
            this.fLimitNotificationSpinner.setSelection(notificationLimit);
        } else {
            this.fLimitNotificationSpinner.setSelection(notificationLimit * -1);
        }
        label = new Label(limitItemsContainer, 0);
        label.setText(Messages.NotifierPreferencesPage_SHOW_MAX_NEWS_END);
        this.fShowExcerptCheck = new Button(group, 32);
        this.fShowExcerptCheck.setText(Messages.NotifierPreferencesPage_SHOW_EXCERPT);
        this.fShowExcerptCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.SHOW_EXCERPT_IN_NOTIFIER));
        this.fNotificationOnlyFromTray = new Button(group, 32);
        this.fNotificationOnlyFromTray.setText(Messages.NotifierPreferencesPage_SHOW_WHEN_MINIMIZED);
        this.fNotificationOnlyFromTray.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP_ONLY_WHEN_MINIMIZED));
        this.fFadeNotifierCheck = new Button(group, 32);
        this.fFadeNotifierCheck.setText(Messages.NotifierPreferencesPage_ANIMATE_NOTIFIER);
        this.fFadeNotifierCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.FADE_NOTIFIER));
        this.fCloseNotifierOnOpen = new Button(group, 32);
        this.fCloseNotifierOnOpen.setText(Messages.NotifierPreferencesPage_CLOSE_NOTIFIER_ON_OPEN);
        this.fCloseNotifierOnOpen.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLOSE_NOTIFIER_ON_OPEN));
        Composite autoCloseContainer = new Composite(group, 0);
        autoCloseContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0, 0, 2, false));
        this.fAutoCloseNotifierCheck = new Button(autoCloseContainer, 32);
        this.fAutoCloseNotifierCheck.setText(Messages.NotifierPreferencesPage_CLOSE_AUTOMATICALLY);
        this.fAutoCloseNotifierCheck.setSelection(!this.fGlobalScope.getBoolean(DefaultPreferences.STICKY_NOTIFICATION_POPUP));
        this.fAutoCloseNotifierCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifierPreferencesPage.this.fAutoCloseNotifierSpinner.setEnabled(NotifierPreferencesPage.this.fAutoCloseNotifierCheck.getSelection());
            }
        });
        int notificationAutoCloseValue = this.fGlobalScope.getInteger(DefaultPreferences.AUTOCLOSE_NOTIFICATION_VALUE);
        this.fAutoCloseNotifierSpinner = new Spinner(autoCloseContainer, 2048);
        this.fAutoCloseNotifierSpinner.setMinimum(1);
        this.fAutoCloseNotifierSpinner.setMaximum(99);
        this.fAutoCloseNotifierSpinner.setEnabled(this.fAutoCloseNotifierCheck.getSelection());
        this.fAutoCloseNotifierSpinner.setSelection(notificationAutoCloseValue);
        label = new Label(autoCloseContainer, 0);
        label.setText(Messages.NotifierPreferencesPage_SECONDS);
        label = new Label(notificationGroup, 0);
        label.setText(Messages.NotifierPreferencesPage_NOTIFICATION_FOR_INCOMING_NEWS);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        group = new Composite(notificationGroup, 0);
        group.setLayout((Layout)LayoutUtils.createGridLayout(1, 7, 3));
        ((GridLayout)group.getLayout()).marginBottom = 5;
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fShowNotificationPopup = new Button(group, 32);
        this.fShowNotificationPopup.setText(Messages.NotifierPreferencesPage_SHOW_NOTIFIER);
        this.fShowNotificationPopup.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP));
        this.fShowNotificationPopup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifierPreferencesPage.this.setLimitNotificationEnabled(NotifierPreferencesPage.this.fLimitNotifierToSelectionCheck.getSelection());
            }
        });
        this.createNotifierViewer(group);
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        return composite;
    }

    public boolean performOk() {
        this.fGlobalScope.putBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP, this.fShowNotificationPopup.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP_ONLY_WHEN_MINIMIZED, this.fNotificationOnlyFromTray.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.FADE_NOTIFIER, this.fFadeNotifierCheck.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.SHOW_EXCERPT_IN_NOTIFIER, this.fShowExcerptCheck.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.CLOSE_NOTIFIER_ON_OPEN, this.fCloseNotifierOnOpen.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.STICKY_NOTIFICATION_POPUP, !this.fAutoCloseNotifierCheck.getSelection());
        this.fGlobalScope.putInteger(DefaultPreferences.AUTOCLOSE_NOTIFICATION_VALUE, this.fAutoCloseNotifierSpinner.getSelection());
        if (this.fLimitNotificationCheck.getSelection()) {
            this.fGlobalScope.putInteger(DefaultPreferences.LIMIT_NOTIFICATION_SIZE, this.fLimitNotificationSpinner.getSelection());
        } else {
            this.fGlobalScope.putInteger(DefaultPreferences.LIMIT_NOTIFICATION_SIZE, this.fLimitNotificationSpinner.getSelection() * -1);
        }
        this.fGlobalScope.putBoolean(DefaultPreferences.LIMIT_NOTIFIER_TO_SELECTION, this.fLimitNotifierToSelectionCheck.getSelection());
        if (this.fLimitNotifierToSelectionCheck.getSelection()) {
            Collection rootFolders = ((IFolderDAO)DynamicDAO.getDAO(IFolderDAO.class)).loadRoots();
            List<Object> checkedElements = Arrays.asList(this.fViewer.getCheckedElements());
            final HashSet<IFolderChild> entitiesToSave = new HashSet<IFolderChild>();
            for (IFolder folder : rootFolders) {
                boolean checked = checkedElements.contains(folder);
                this.performOk((IFolderChild)folder, checkedElements, entitiesToSave, checked);
            }
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DynamicDAO.saveAll((Collection)entitiesToSave);
                    if (!entitiesToSave.isEmpty()) {
                        Controller.getDefault().getNotificationService().notifySettingsChanged();
                    }
                }
            });
        }
        return super.performOk();
    }

    private void performOk(IFolderChild entity, List<?> checkedElements, Set<IFolderChild> entitiesToSave, boolean parentChecked) {
        boolean checked;
        IPreferenceScope prefs = Owl.getPreferenceService().getEntityScope((IEntity)entity);
        boolean save = false;
        boolean bl = checked = checkedElements.contains(entity) || parentChecked;
        if (checked && !prefs.getBoolean(DefaultPreferences.ENABLE_NOTIFIER)) {
            prefs.putBoolean(DefaultPreferences.ENABLE_NOTIFIER, true);
            save = true;
        } else if (!checked && prefs.getBoolean(DefaultPreferences.ENABLE_NOTIFIER)) {
            prefs.delete(DefaultPreferences.ENABLE_NOTIFIER);
            save = true;
        }
        if (save) {
            entitiesToSave.add(entity);
        }
        if (entity instanceof IFolder) {
            List children = ((IFolder)entity).getChildren();
            for (IFolderChild child : children) {
                this.performOk(child, checkedElements, entitiesToSave, checked);
            }
        }
    }

    protected void performApply() {
        super.performApply();
        this.updateApplyEnablement(false);
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        this.fShowNotificationPopup.setSelection(defaultScope.getBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP));
        this.fNotificationOnlyFromTray.setSelection(defaultScope.getBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP_ONLY_WHEN_MINIMIZED));
        this.fFadeNotifierCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.FADE_NOTIFIER));
        this.fShowExcerptCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.SHOW_EXCERPT_IN_NOTIFIER));
        this.fCloseNotifierOnOpen.setSelection(defaultScope.getBoolean(DefaultPreferences.CLOSE_NOTIFIER_ON_OPEN));
        this.fAutoCloseNotifierCheck.setSelection(!defaultScope.getBoolean(DefaultPreferences.STICKY_NOTIFICATION_POPUP));
        this.fAutoCloseNotifierSpinner.setSelection(defaultScope.getInteger(DefaultPreferences.AUTOCLOSE_NOTIFICATION_VALUE));
        this.fAutoCloseNotifierSpinner.setEnabled(this.fAutoCloseNotifierCheck.getSelection());
        int limitNotificationValue = defaultScope.getInteger(DefaultPreferences.LIMIT_NOTIFICATION_SIZE);
        this.fLimitNotificationCheck.setSelection(limitNotificationValue >= 0);
        if (limitNotificationValue >= 0) {
            this.fLimitNotificationSpinner.setSelection(limitNotificationValue);
        }
        this.fLimitNotificationCheck.setEnabled(this.fShowNotificationPopup.getSelection());
        this.fLimitNotificationSpinner.setEnabled(this.fShowNotificationPopup.getSelection());
        this.fLimitNotifierToSelectionCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.LIMIT_NOTIFIER_TO_SELECTION));
        this.setLimitNotificationEnabled(this.fLimitNotifierToSelectionCheck.getSelection());
        this.updateApplyEnablement(true);
    }

    private void updateApplyEnablement(boolean enable) {
        Button applyButton = this.getApplyButton();
        if (applyButton != null && !applyButton.isDisposed() && applyButton.isEnabled() != enable) {
            applyButton.setEnabled(enable);
        }
    }
}

