/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.LabelAdapter;
import org.rssowl.core.persist.event.LabelEvent;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.NewsListener;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.IModelSearch;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.SearchHit;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationActionBarAdvisor;
import org.rssowl.ui.internal.ContextMenuCreator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.ArchiveNewsAction;
import org.rssowl.ui.internal.actions.AutomateFilterAction;
import org.rssowl.ui.internal.actions.CreateFilterAction;
import org.rssowl.ui.internal.actions.MakeNewsStickyAction;
import org.rssowl.ui.internal.actions.MoveCopyNewsToBinAction;
import org.rssowl.ui.internal.actions.OpenInExternalBrowserAction;
import org.rssowl.ui.internal.actions.OpenNewsAction;
import org.rssowl.ui.internal.actions.ToggleReadStateAction;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.dialogs.SearchMarkDialog;
import org.rssowl.ui.internal.editors.feed.NewsBrowserLabelProvider;
import org.rssowl.ui.internal.editors.feed.NewsBrowserViewer;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.editors.feed.NewsColumnViewModel;
import org.rssowl.ui.internal.editors.feed.NewsComparator;
import org.rssowl.ui.internal.editors.feed.NewsTableLabelProvider;
import org.rssowl.ui.internal.search.LocationControl;
import org.rssowl.ui.internal.search.SearchConditionList;
import org.rssowl.ui.internal.undo.NewsStateOperation;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.CTable;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.util.UIBackgroundJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchNewsDialog
extends TitleAreaDialog {
    private static final int DIALOG_MIN_WIDTH = 500;
    private static final int[] TWO_SASH_WEIGHTS;
    private static final int[] THREE_SASH_WEIGHTS;
    private static final String SETTINGS_SECTION = "org.rssowl.ui.internal.dialogs.SearchNewsDialog";
    private static final String PREF_SASH_WEIGHTS = "org.rssowl.ui.internal.dialogs.search.SashWeights";
    private static final String COLUMNS_ACTION = "org.rssowl.ui.internal.dialogs.search.ColumnsAction";
    private static final String SEARCHES_ACTION = "org.rssowl.ui.internal.dialogs.search.SearchesAction";
    private static final int NUM_PRELOADED = 20;
    private static int fgOpenDialogCount;
    private static final int BUTTON_SEARCH = 1000;
    private static final int BUTTON_CLEAR = 1001;
    private Button fMatchAllRadio;
    private Button fMatchAnyRadio;
    private LocationControl fLocationControl;
    private SearchConditionList fSearchConditionList;
    private CTable fCustomTable;
    private TableViewer fResultViewer;
    private NewsColumnViewModel fColumnModel;
    private ScoredNewsComparator fNewsSorter;
    private Link fStatusLabel;
    private NewsBrowserViewer fBrowserViewer;
    private NewsTableLabelProvider fNewsTableLabelProvider;
    private int[] fCachedWeights;
    private boolean fUseLowScoreFilter;
    private AtomicInteger fLowScoreNewsFilteredCount = new AtomicInteger(0);
    private LocalResourceManager fResources;
    private IDialogSettings fDialogSettings;
    private IModelSearch fModelSearch;
    private NewsListener fNewsListener;
    private boolean fFirstTimeOpen;
    private boolean fShowsHandCursor;
    private Cursor fHandCursor;
    private ISearchCondition fInitialScope;
    private List<ISearchCondition> fInitialConditions;
    private boolean fRunSearch;
    private boolean fMatchAllConditions;
    private INewsDAO fNewsDao;
    private IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();
    private LabelAdapter fLabelListener;
    private boolean fIsPreviewVisible;
    private SashForm fSashForm;
    private Composite fBottomSash;
    private List<ISearchCondition> fCurrentSearchConditions;
    private long fLastColumnActionInvokedMillies;
    private Menu fAttachmentsMenu;

    static {
        int[] nArray = new int[3];
        nArray[0] = 40;
        nArray[1] = 60;
        TWO_SASH_WEIGHTS = nArray;
        THREE_SASH_WEIGHTS = new int[]{33, 33, 33};
    }

    public SearchNewsDialog(Shell parentShell) {
        this(parentShell, null, true, false);
    }

    public SearchNewsDialog(Shell parentShell, List<IFolderChild> searchScope) {
        this(parentShell, SearchNewsDialog.toSearchConditions(searchScope), true, false);
    }

    private static List<ISearchCondition> toSearchConditions(List<IFolderChild> searchScope) {
        ISearchField field;
        IModelFactory factory = Owl.getModelFactory();
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(2);
        if (!searchScope.isEmpty()) {
            field = factory.createSearchField(19, INews.class.getName());
            conditions.add(factory.createSearchCondition(field, SearchSpecifier.SCOPE, (Object)ModelUtils.toPrimitive(searchScope)));
        }
        field = factory.createSearchField(-1, INews.class.getName());
        conditions.add(factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)""));
        return conditions;
    }

    public SearchNewsDialog(Shell parentShell, List<ISearchCondition> initialConditions, boolean matchAllConditions, boolean runSearch) {
        super(parentShell);
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fDialogSettings = Activator.getDefault().getDialogSettings();
        this.fFirstTimeOpen = this.fDialogSettings.getSection(SETTINGS_SECTION) == null;
        this.fIsPreviewVisible = this.fPreferences.getBoolean(DefaultPreferences.SEARCH_DIALOG_PREVIEW_VISIBLE);
        this.fCachedWeights = this.fPreferences.getIntegers(PREF_SASH_WEIGHTS);
        this.fModelSearch = Owl.getPersistenceService().getModelSearch();
        this.fHandCursor = parentShell.getDisplay().getSystemCursor(21);
        this.fMatchAllConditions = matchAllConditions;
        this.fRunSearch = runSearch;
        this.fNewsDao = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);
        if (initialConditions != null) {
            Pair conditions = CoreUtils.splitScope(initialConditions);
            this.fInitialScope = (ISearchCondition)conditions.getFirst();
            this.fInitialConditions = (List)conditions.getSecond();
        }
    }

    public void setUseLowScoreFilter(boolean useLowScoreFilter) {
        this.fUseLowScoreFilter = useLowScoreFilter;
    }

    public int open() {
        ++fgOpenDialogCount;
        return super.open();
    }

    public boolean close() {
        --fgOpenDialogCount;
        if (this.fAttachmentsMenu != null) {
            OwlUI.safeDispose(this.fAttachmentsMenu);
        }
        if (!this.fResultViewer.getTable().isDisposed()) {
            NewsColumnViewModel model = NewsColumnViewModel.initializeFrom(this.fResultViewer.getTable());
            model.setSortColumn(this.fNewsSorter.getSortBy());
            model.setAscending(this.fNewsSorter.isAscending());
            model.saveTo(this.fPreferences, true);
        }
        this.fPreferences.putBoolean(DefaultPreferences.SEARCH_DIALOG_PREVIEW_VISIBLE, this.fIsPreviewVisible);
        if (this.fCachedWeights != null) {
            this.fPreferences.putIntegers(PREF_SASH_WEIGHTS, this.fCachedWeights);
        }
        this.fResultViewer.setItemCount(0);
        boolean res = super.close();
        this.fResources.dispose();
        this.unregisterListeners();
        return res;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SearchNewsDialog_SEARCH_NEWS);
    }

    public void create() {
        super.create();
        if (this.fRunSearch) {
            JobRunner.runInUIThread(200, (Widget)this.getShell(), new Runnable(){

                public void run() {
                    SearchNewsDialog.this.onSearch();
                }
            });
        }
    }

    protected Control createDialogArea(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        this.setTitle(Messages.SearchNewsDialog_SEARCH_NEWS);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/search.gif"));
        this.restoreInfoMessage(false);
        this.fSashForm = new SashForm(parent, 66048);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite topSash = new Composite((Composite)this.fSashForm, 0);
        topSash.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        Composite topSashContent = new Composite(topSash, 0);
        topSashContent.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 0, false));
        topSashContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createConditionControls(topSashContent);
        new Label(topSashContent, 258).setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        Composite centerSash = new Composite((Composite)this.fSashForm, 0);
        centerSash.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        centerSash.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SearchNewsDialog.this.fCachedWeights = SearchNewsDialog.this.fSashForm.getWeights();
            }
        });
        Composite centerSashContent = new Composite(centerSash, 0);
        centerSashContent.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        centerSashContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createResultViewer(centerSashContent);
        this.fBottomSash = new Composite((Composite)this.fSashForm, 0);
        this.fBottomSash.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        this.fBottomSash.setVisible(this.fIsPreviewVisible);
        Composite bottomSashContent = new Composite(this.fBottomSash, 0);
        bottomSashContent.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        bottomSashContent.setLayoutData((Object)new GridData(4, 4, true, true));
        bottomSashContent.setBackground(bottomSashContent.getDisplay().getSystemColor(25));
        new Label(bottomSashContent, 258).setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        this.createBrowserViewer(bottomSashContent);
        if (this.fCachedWeights != null) {
            this.fSashForm.setWeights(this.fCachedWeights);
        } else {
            this.fSashForm.setWeights(this.fIsPreviewVisible ? THREE_SASH_WEIGHTS : TWO_SASH_WEIGHTS);
        }
        new Label(this.fBottomSash, 258).setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        SearchNewsDialog.applyDialogFont((Control)this.fSashForm);
        return this.fSashForm;
    }

    private void createBrowserViewer(Composite bottomSashContent) {
        this.fBrowserViewer = new NewsBrowserViewer(bottomSashContent, 0){

            @Override
            protected Collection<String> getHighlightedWords() {
                return CoreUtils.extractWords((List)SearchNewsDialog.this.fCurrentSearchConditions);
            }
        };
        this.fBrowserViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fBrowserViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[] && ((Object[])inputElement).length > 0) {
                    inputElement = ((Object[])inputElement)[0];
                }
                if (inputElement instanceof NewsReference) {
                    return new Object[]{((NewsReference)inputElement).resolve()};
                }
                return new Object[]{inputElement};
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        NewsBrowserLabelProvider labelProvider = new NewsBrowserLabelProvider(this.fBrowserViewer);
        labelProvider.setShowFooter(false);
        labelProvider.setForceShowFeedInformation(true);
        labelProvider.setStripMediaFromNews(!this.fPreferences.getBoolean(DefaultPreferences.ENABLE_IMAGES), !this.fPreferences.getBoolean(DefaultPreferences.ENABLE_MEDIA));
        this.fBrowserViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fResultViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && SearchNewsDialog.this.fIsPreviewVisible) {
                    SearchNewsDialog.this.fBrowserViewer.setInput(selection.getFirstElement());
                    SearchNewsDialog.this.hideBrowser(false);
                }
            }
        });
    }

    private void createConditionControls(Composite container) {
        Composite topControlsContainer = new Composite(container, 0);
        topControlsContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        topControlsContainer.setLayout((Layout)LayoutUtils.createGridLayout(5, 10, 3));
        this.fMatchAllRadio = new Button(topControlsContainer, 16);
        this.fMatchAllRadio.setText(Messages.SearchNewsDialog_MATCH_ALL);
        this.fMatchAllRadio.setSelection(this.fMatchAllConditions);
        this.fMatchAnyRadio = new Button(topControlsContainer, 16);
        this.fMatchAnyRadio.setText(Messages.SearchNewsDialog_MATCH_ANY);
        this.fMatchAnyRadio.setSelection(!this.fMatchAllConditions);
        Label sep = new Label(topControlsContainer, 514);
        sep.setLayoutData((Object)new GridData(-1, 16));
        Composite scopeContainer = new Composite(topControlsContainer, 0);
        scopeContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        scopeContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 5, false));
        ((GridLayout)scopeContainer.getLayout()).marginLeft = 2;
        Label locationLabel = new Label(scopeContainer, 0);
        locationLabel.setText(Messages.SearchNewsDialog_SEARCH_IN);
        this.fLocationControl = new LocationControl(scopeContainer, 64){

            protected String getDefaultLabel() {
                return Messages.SearchNewsDialog_ALL_NEWS;
            }
        };
        this.fLocationControl.setLayoutData(new GridData(4, 0x1000000, true, true));
        ((GridData)this.fLocationControl.getLayoutData()).widthHint = 100;
        this.fLocationControl.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        final ToolBarManager dialogToolBar = new ToolBarManager(0x820000);
        Action columnDropdown = new Action(Messages.SearchNewsDialog_VISIBLE_COLUMNS, 4){

            public void run() {
                OwlUI.positionDropDownMenu(this, dialogToolBar);
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.COLUMNS;
            }

            public String getId() {
                return SearchNewsDialog.COLUMNS_ACTION;
            }
        };
        columnDropdown.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                NewsColumn[] columns;
                Menu menu = new Menu(parent);
                MenuItem restoreDefaults = new MenuItem(menu, 0);
                restoreDefaults.setText(Messages.SearchNewsDialog_RESTORE_DEFAULT_COLUMNS);
                restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        NewsColumnViewModel defaultModel = NewsColumnViewModel.createDefault(true);
                        if (!defaultModel.equals(SearchNewsDialog.this.fColumnModel)) {
                            SearchNewsDialog.this.showColumns(defaultModel, true);
                        }
                    }
                });
                new MenuItem(menu, 2);
                NewsColumn[] newsColumnArray = columns = NewsColumn.values();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    final NewsColumn column = newsColumnArray[n2];
                    if (column.isSelectable()) {
                        MenuItem item = new MenuItem(menu, 32);
                        item.setText(column.getName());
                        if (SearchNewsDialog.this.fColumnModel.contains(column)) {
                            item.setSelection(true);
                        }
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (SearchNewsDialog.this.fColumnModel.contains(column)) {
                                    SearchNewsDialog.this.fColumnModel.removeColumn(column);
                                } else {
                                    SearchNewsDialog.this.fColumnModel.addColumn(column);
                                }
                                SearchNewsDialog.this.showColumns(SearchNewsDialog.this.fColumnModel, true);
                            }
                        });
                    }
                    ++n2;
                }
                return menu;
            }
        });
        dialogToolBar.add((IAction)columnDropdown);
        dialogToolBar.add((IContributionItem)new Separator());
        Action previewAction = new Action(Messages.SearchNewsDialog_PREVIEW_RESULTS, 2){

            public void run() {
                SearchNewsDialog.this.fIsPreviewVisible = !SearchNewsDialog.this.fIsPreviewVisible;
                SearchNewsDialog.this.fSashForm.setWeights(SearchNewsDialog.this.fIsPreviewVisible ? THREE_SASH_WEIGHTS : TWO_SASH_WEIGHTS);
                SearchNewsDialog.this.fBottomSash.setVisible(SearchNewsDialog.this.fIsPreviewVisible);
                SearchNewsDialog.this.fSashForm.layout();
                dialogToolBar.find("org.rssowl.ui.internal.dialogs.search.PreviewAction").update("toolTipText");
                if (SearchNewsDialog.this.fIsPreviewVisible && SearchNewsDialog.this.fResultViewer.getTable().getItemCount() > 0) {
                    if (SearchNewsDialog.this.fResultViewer.getSelection().isEmpty()) {
                        SearchNewsDialog.this.fResultViewer.getTable().select(0);
                    }
                    SearchNewsDialog.this.fBrowserViewer.setInput(((IStructuredSelection)SearchNewsDialog.this.fResultViewer.getSelection()).getFirstElement());
                    SearchNewsDialog.this.hideBrowser(false);
                    SearchNewsDialog.this.fResultViewer.getTable().setFocus();
                    SearchNewsDialog.this.fResultViewer.getTable().showSelection();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.getImageDescriptor("icons/etool16/browsermaximized.gif");
            }

            public String getToolTipText() {
                if (SearchNewsDialog.this.fIsPreviewVisible) {
                    return Messages.SearchNewsDialog_HIDE_PREVIEW;
                }
                return Messages.SearchNewsDialog_SHOW_PREVIEW;
            }
        };
        previewAction.setId("org.rssowl.ui.internal.dialogs.search.PreviewAction");
        previewAction.setChecked(this.fIsPreviewVisible);
        dialogToolBar.add((IAction)previewAction);
        dialogToolBar.add((IContributionItem)new Separator());
        Action savedSearches = new Action(Messages.SearchNewsDialog_SHOW_SAVED_SEARCH, 4){

            public void run() {
                OwlUI.positionDropDownMenu(this, dialogToolBar);
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.SEARCHMARK;
            }

            public String getId() {
                return SearchNewsDialog.SEARCHES_ACTION;
            }
        };
        savedSearches.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                Set searchMarks = CoreUtils.loadSortedSearchMarks();
                Menu menu = new Menu(parent);
                MenuItem newSavedSearch = new MenuItem(menu, 0);
                newSavedSearch.setText(Messages.SearchNewsDialog_NEW_SAVED_SEARCH);
                newSavedSearch.setImage(OwlUI.getImage((ResourceManager)SearchNewsDialog.this.fResources, "icons/etool16/add.gif"));
                newSavedSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SearchNewsDialog.this.onSave();
                    }
                });
                if (searchMarks.size() > 0) {
                    new MenuItem(menu, 2);
                }
                for (final ISearchMark searchMark : searchMarks) {
                    MenuItem item = new MenuItem(menu, 0);
                    item.setText(searchMark.getName());
                    item.setImage(OwlUI.getImage((ResourceManager)SearchNewsDialog.this.fResources, OwlUI.SEARCHMARK));
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SearchNewsDialog.this.show(searchMark);
                        }
                    });
                }
                return menu;
            }
        });
        dialogToolBar.add((IAction)savedSearches);
        dialogToolBar.createControl(topControlsContainer);
        dialogToolBar.getControl().setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        final Composite conditionsContainer = new Composite(container, 0);
        conditionsContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        conditionsContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 10));
        conditionsContainer.setBackground(container.getDisplay().getSystemColor(25));
        conditionsContainer.setBackgroundMode(2);
        conditionsContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle clArea = conditionsContainer.getClientArea();
                gc.setForeground(conditionsContainer.getDisplay().getSystemColor(18));
                gc.drawLine(clArea.x, clArea.y, clArea.x + clArea.width, clArea.y);
            }
        });
        this.fSearchConditionList = new SearchConditionList(conditionsContainer, 0, this.getDefaultConditions());
        this.fSearchConditionList.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.fSearchConditionList.setVisibleItemCount(3);
        if (this.fInitialScope != null && this.fInitialScope.getValue() instanceof Long[][]) {
            this.fLocationControl.select((Long[][])this.fInitialScope.getValue());
        }
        if (this.fInitialConditions != null) {
            this.fSearchConditionList.showConditions(this.fInitialConditions);
        }
        int index = 0;
        if (this.fInitialConditions != null && this.fInitialConditions.size() == 2) {
            index = 1;
        }
        this.fSearchConditionList.focusInput(index);
    }

    private void show(ISearchMark sm) {
        this.fMatchAllRadio.setSelection(sm.matchAllConditions());
        this.fMatchAnyRadio.setSelection(!sm.matchAllConditions());
        Pair conditions = CoreUtils.splitScope((List)sm.getSearchConditions());
        Long[][] scope = null;
        if (conditions.getFirst() != null && ((ISearchCondition)conditions.getFirst()).getValue() instanceof Long[][]) {
            scope = (Long[][])((ISearchCondition)conditions.getFirst()).getValue();
        }
        this.fLocationControl.select(scope);
        this.fSearchConditionList.showConditions((List)conditions.getSecond());
        this.restoreInfoMessage(true);
        this.fLocationControl.getParent().getParent().getParent().layout(true, true);
    }

    private void restoreInfoMessage(boolean clearError) {
        if (clearError) {
            this.setErrorMessage(null);
        }
        this.setMessage(Messages.SearchNewsDialog_SEARCH_HELP, 1);
    }

    protected Control createButtonBar(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 1, true, false));
        buttonBar.setLayout((Layout)layout);
        this.fStatusLabel = new Link(buttonBar, 0);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fStatusLabel.setText("");
        SearchNewsDialog.applyDialogFont((Control)this.fStatusLabel);
        this.fStatusLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchNewsDialog.this.onSave();
            }
        });
        Button searchButton = this.createButton(buttonBar, 1000, Messages.SearchNewsDialog_SEARCH, true);
        ((GridData)searchButton.getLayoutData()).horizontalAlignment = 0x1000008;
        ((GridData)searchButton.getLayoutData()).grabExcessHorizontalSpace = false;
        this.createButton(buttonBar, 1001, Messages.SearchNewsDialog_CLEAR, false);
        Button closeButton = this.createButton(buttonBar, 12, IDialogConstants.CLOSE_LABEL, false);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchNewsDialog.this.close();
            }
        });
        return buttonBar;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1000: {
                this.onSearch();
                break;
            }
            case 1001: {
                this.onClear();
            }
        }
    }

    private void onSearch() {
        if (this.fSearchConditionList.isEmpty()) {
            this.setErrorMessage(Messages.SearchNewsDialog_SEARCH_DESCRIPTION);
            this.fSearchConditionList.focusInput();
            return;
        }
        this.fCurrentSearchConditions = this.fSearchConditionList.createConditions();
        ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
        if (locationCondition != null) {
            this.fCurrentSearchConditions.add(locationCondition);
        }
        if (CoreUtils.isLocationConflict(this.fCurrentSearchConditions)) {
            this.setErrorMessage(null);
            this.setMessage(Messages.SearchNewsDialog_LOCATION_WARNING, 2);
        } else {
            this.restoreInfoMessage(true);
        }
        final boolean matchAllConditions = this.fMatchAllRadio.getSelection();
        this.getButton(1000).setEnabled(false);
        this.getShell().setCursor(this.getShell().getDisplay().getSystemCursor(3));
        JobRunner.runUIUpdater(new UIBackgroundJob((Control)this.getShell()){
            private List<ScoredNews> fResult;
            private Exception fException;
            {
                super($anonymous0);
                this.fResult = null;
                this.fException = null;
            }

            protected void runInBackground(IProgressMonitor monitor) {
                try {
                    List searchHits = SearchNewsDialog.this.fModelSearch.searchNews((Collection)SearchNewsDialog.this.fCurrentSearchConditions, matchAllConditions);
                    this.fResult = new ArrayList<ScoredNews>(searchHits.size());
                    Float maxRelevanceScore = Float.valueOf(0.0f);
                    for (SearchHit searchHit : searchHits) {
                        Float relevanceRaw = Float.valueOf(searchHit.getRelevance());
                        maxRelevanceScore = Float.valueOf(Math.max(maxRelevanceScore.floatValue(), relevanceRaw.floatValue()));
                    }
                    Float mediumRelThreshold = Float.valueOf(maxRelevanceScore.floatValue() / 3.0f * 1.0f);
                    Float highRelThreshold = Float.valueOf(maxRelevanceScore.floatValue() / 3.0f * 2.0f);
                    Set visibleStates = INews.State.getVisible();
                    for (SearchHit searchHit : searchHits) {
                        INews.State state = (INews.State)searchHit.getData((Object)14);
                        if (!visibleStates.contains(state)) continue;
                        if (!SearchNewsDialog.this.fNewsDao.exists(((NewsReference)searchHit.getResult()).getId())) {
                            CoreUtils.reportIndexIssue();
                            continue;
                        }
                        Float relevanceRaw = Float.valueOf(searchHit.getRelevance());
                        Relevance relevance = Relevance.LOW;
                        if (relevanceRaw.floatValue() > highRelThreshold.floatValue()) {
                            relevance = Relevance.HIGH;
                        } else if (relevanceRaw.floatValue() > mediumRelThreshold.floatValue()) {
                            relevance = Relevance.MEDIUM;
                        }
                        this.fResult.add(new ScoredNews((NewsReference)searchHit.getResult(), state, relevanceRaw, relevance));
                    }
                    SearchNewsDialog.this.preload(this.fResult);
                }
                catch (PersistenceException e) {
                    this.fException = e;
                }
            }

            protected void runInUI(IProgressMonitor monitor) {
                if (this.fException != null) {
                    SearchNewsDialog.this.setErrorMessage(this.fException.getMessage());
                    this.fResult = Collections.emptyList();
                }
                SearchNewsDialog.this.fResultViewer.setInput(this.fResult);
                int size = this.fResult.size() - SearchNewsDialog.this.fLowScoreNewsFilteredCount.get();
                String text = SearchNewsDialog.this.fLowScoreNewsFilteredCount.get() != 0 ? (size == 0 ? NLS.bind((String)Messages.SearchNewsDialog_SEARCH_RESULT_1_FILTERED, (Object)SearchNewsDialog.this.fLowScoreNewsFilteredCount.get()) : (size == 1 ? NLS.bind((String)Messages.SearchNewsDialog_SEARCH_RESULT_2_FILTERED, (Object)size, (Object)SearchNewsDialog.this.fLowScoreNewsFilteredCount.get()) : NLS.bind((String)Messages.SearchNewsDialog_SEARCH_RESULT_3_FILTERED, (Object)size, (Object)SearchNewsDialog.this.fLowScoreNewsFilteredCount.get()))) : (size == 0 ? Messages.SearchNewsDialog_SEARCH_RESULT_1 : (size == 1 ? NLS.bind((String)Messages.SearchNewsDialog_SEARCH_RESULT_2, (Object)this.fResult.size()) : NLS.bind((String)Messages.SearchNewsDialog_SEARCH_RESULT_3, (Object)this.fResult.size())));
                SearchNewsDialog.this.fStatusLabel.setText(text);
                SearchNewsDialog.this.getButton(1000).setEnabled(true);
                SearchNewsDialog.this.getShell().setCursor(null);
                SearchNewsDialog.this.getShell().setDefaultButton(SearchNewsDialog.this.getButton(1000));
                SearchNewsDialog.this.getButton(1000).setFocus();
                SearchNewsDialog.this.fSearchConditionList.focusInput();
                if (SearchNewsDialog.this.fIsPreviewVisible && size > 0) {
                    SearchNewsDialog.this.fResultViewer.getTable().select(0);
                    SearchNewsDialog.this.fResultViewer.getTable().showSelection();
                    Object selection = ((IStructuredSelection)SearchNewsDialog.this.fResultViewer.getSelection()).getFirstElement();
                    boolean refresh = selection.equals(SearchNewsDialog.this.fBrowserViewer.getInput());
                    SearchNewsDialog.this.fBrowserViewer.setInput(selection);
                    SearchNewsDialog.this.hideBrowser(false);
                    SearchNewsDialog.this.fResultViewer.getTable().setFocus();
                    if (refresh) {
                        SearchNewsDialog.this.fBrowserViewer.refresh();
                    }
                } else if (SearchNewsDialog.this.fIsPreviewVisible) {
                    SearchNewsDialog.this.hideBrowser(true);
                }
            }
        });
    }

    private void preload(List<ScoredNews> list) {
        int i = 0;
        while (i < list.size() && i < 20) {
            list.get(i).getNews();
            ++i;
        }
    }

    private void hideBrowser(boolean hide) {
        if (hide) {
            this.fBrowserViewer.setInput("about:blank");
            this.fBrowserViewer.getControl().setVisible(false);
        } else {
            this.fBrowserViewer.getControl().setVisible(true);
        }
    }

    private void onClear() {
        this.fSearchConditionList.reset();
        this.fMatchAllRadio.setSelection(true);
        this.fMatchAnyRadio.setSelection(false);
        this.fResultViewer.setInput(Collections.emptyList());
        this.hideBrowser(true);
        this.restoreInfoMessage(true);
        this.fStatusLabel.setText("");
    }

    private void onSave() {
        ISearchCondition locationCondition;
        List<ISearchCondition> conditions = this.fSearchConditionList.createConditions();
        if (conditions.isEmpty()) {
            conditions.addAll(this.getDefaultConditions());
        }
        if ((locationCondition = this.fLocationControl.toScopeCondition()) != null) {
            conditions.add(locationCondition);
        }
        SearchMarkDialog dialog = new SearchMarkDialog((Shell)this.getShell().getParent(), OwlUI.getBookMarkExplorerSelection(), null, conditions, this.fMatchAllRadio.getSelection());
        dialog.open();
    }

    private void createResultViewer(Composite centerSashContent) {
        Composite tableContainer = new Composite(centerSashContent, 0);
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        tableContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        int style = 0x10010002;
        this.fCustomTable = new CTable(tableContainer, style);
        this.fResultViewer = new TableViewer(this.fCustomTable.getControl()){

            public ISelection getSelection() {
                StructuredSelection selection = (StructuredSelection)super.getSelection();
                return SearchNewsDialog.this.convertToNews(selection);
            }
        };
        this.fResultViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fResultViewer.setUseHashlookup(true);
        this.fResultViewer.getControl().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        this.fResultViewer.getTable().setHeaderVisible(true);
        FeedColumnToolTipSupport.enableFor((ColumnViewer)this.fResultViewer);
        new Label(centerSashContent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        this.fResultViewer.setContentProvider((IContentProvider)this.getContentProvider());
        NewsColumnViewModel model = NewsColumnViewModel.loadFrom(this.fPreferences, true);
        this.fNewsTableLabelProvider = new ScoredNewsLabelProvider(model);
        if (!OwlUI.isHighContrast()) {
            this.fResultViewer.getControl().addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    Object element = event.item.getData();
                    SearchNewsDialog.this.fNewsTableLabelProvider.erase(event, element);
                }
            });
        }
        this.fNewsSorter = new ScoredNewsComparator();
        this.fResultViewer.setComparator((ViewerComparator)this.fNewsSorter);
        if (this.fUseLowScoreFilter) {
            this.fResultViewer.addFilter((ViewerFilter)new FirstTimeLowScoreFilter());
        }
        this.showColumns(model, false);
        this.hookContextualMenu();
        this.initDragAndDrop();
        this.registerListeners();
    }

    private void showColumns(NewsColumnViewModel model, boolean update) {
        this.fResultViewer.getTable().setRedraw(false);
        try {
            TableColumn[] columns;
            this.fCustomTable.clear();
            this.fColumnModel = model;
            List<NewsColumn> cols = model.getColumns();
            for (NewsColumn col : cols) {
                TableViewerColumn viewerColumn = new TableViewerColumn(this.fResultViewer, 16384);
                this.fCustomTable.manageColumn(viewerColumn.getColumn(), model.getLayoutData(col), col.showName() ? col.getName() : null, col.showTooltip() ? col.getName() : null, null, col.isMoveable(), col.isResizable());
                viewerColumn.getColumn().setData("org.rssowl.ui.internal.editors.feed.ColumnIdentifier", (Object)col);
                if (model.getSortColumn() != col || !col.showSortIndicator()) continue;
                this.fCustomTable.getControl().setSortColumn(viewerColumn.getColumn());
                this.fCustomTable.getControl().setSortDirection(model.isAscending() ? 128 : 1024);
            }
            TableColumn[] tableColumnArray = columns = this.fResultViewer.getTable().getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                final TableColumn column = tableColumnArray[n2];
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        NewsColumn oldSortBy = SearchNewsDialog.this.fNewsSorter.getSortBy();
                        NewsColumn newSortBy = (NewsColumn)((Object)column.getData("org.rssowl.ui.internal.editors.feed.ColumnIdentifier"));
                        boolean defaultAscending = newSortBy.prefersAscending();
                        boolean ascending = oldSortBy != newSortBy ? defaultAscending : !SearchNewsDialog.this.fNewsSorter.isAscending();
                        SearchNewsDialog.this.fNewsSorter.setSortBy(newSortBy);
                        SearchNewsDialog.this.fNewsSorter.setAscending(ascending);
                        SearchNewsDialog.this.fColumnModel.setSortColumn(newSortBy);
                        SearchNewsDialog.this.fColumnModel.setAscending(ascending);
                        if (newSortBy.showSortIndicator()) {
                            SearchNewsDialog.this.fResultViewer.getTable().setSortColumn(column);
                            SearchNewsDialog.this.fResultViewer.getTable().setSortDirection(ascending ? 128 : 1024);
                        } else {
                            SearchNewsDialog.this.fResultViewer.getTable().setSortColumn(null);
                        }
                        if (SearchNewsDialog.this.fResultViewer.getInput() != null) {
                            Collections.sort((List)SearchNewsDialog.this.fResultViewer.getInput(), SearchNewsDialog.this.fNewsSorter);
                            SearchNewsDialog.this.fResultViewer.refresh(false);
                        }
                    }
                });
                ++n2;
            }
            if (update) {
                this.fCustomTable.update();
            }
            this.fNewsSorter.setAscending(model.isAscending());
            this.fNewsSorter.setSortBy(model.getSortColumn());
            this.fNewsTableLabelProvider.init(model);
            this.fResultViewer.setLabelProvider((IBaseLabelProvider)this.fNewsTableLabelProvider);
            if (update) {
                this.fResultViewer.refresh(true);
            }
        }
        finally {
            this.fResultViewer.getTable().setRedraw(true);
        }
    }

    private void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), URLTransfer.getInstance()};
        this.fResultViewer.addDragSupport(ops, transfers, new DragSourceListener(){

            public void dragStart(final DragSourceEvent event) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        LocalSelectionTransfer.getTransfer().setSelection(SearchNewsDialog.this.fResultViewer.getSelection());
                        LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                        event.doit = true;
                    }
                });
            }

            public void dragSetData(final DragSourceEvent event) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                            event.data = LocalSelectionTransfer.getTransfer().getSelection();
                        } else if (TextTransfer.getInstance().isSupportedType(event.dataType) || URLTransfer.getInstance().isSupportedType(event.dataType)) {
                            SearchNewsDialog.this.setTextData(event);
                        }
                    }
                });
            }

            public void dragFinished(DragSourceEvent event) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        LocalSelectionTransfer.getTransfer().setSelection(null);
                        LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
                    }
                });
            }
        });
    }

    private void setTextData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        Collection<INews> news = ModelUtils.normalize(selection.toList());
        if (!news.isEmpty()) {
            StringBuilder strB = new StringBuilder();
            for (INews item : news) {
                String link = CoreUtils.getLink((INews)item);
                if (!StringUtils.isSet((String)link)) continue;
                strB.append(link);
                if (news.size() <= 1) continue;
                strB.append("\n");
            }
            if (strB.length() > 0) {
                event.data = strB.toString();
            }
        }
    }

    private ISelection convertToNews(StructuredSelection selection) {
        List selectedElements = selection.toList();
        ArrayList<INews> selectedNews = new ArrayList<INews>();
        for (Object selectedElement : selectedElements) {
            ScoredNews scoredNews = (ScoredNews)selectedElement;
            selectedNews.add(scoredNews.getNews());
        }
        return new StructuredSelection(selectedNews);
    }

    private void registerListeners() {
        this.fResultViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SearchNewsDialog.this.onMouseDoubleClick(event);
            }
        });
        this.fResultViewer.getControl().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SearchNewsDialog.this.onMouseDown(event);
            }
        });
        this.fResultViewer.getControl().addListener(5, new Listener(){

            public void handleEvent(Event event) {
                SearchNewsDialog.this.onMouseMove(event);
            }
        });
        this.fNewsListener = new NewsListener(){

            public void entitiesAdded(Set<NewsEvent> events) {
            }

            public void entitiesUpdated(Set<NewsEvent> events) {
                SearchNewsDialog.this.onNewsEvent(events);
            }

            public void entitiesDeleted(Set<NewsEvent> events) {
            }
        };
        DynamicDAO.addEntityListener(INews.class, (EntityListener)this.fNewsListener);
        this.fLabelListener = new LabelAdapter(){

            public void entitiesUpdated(Set<LabelEvent> events) {
                JobRunner.runInUIThread((Widget)SearchNewsDialog.this.fResultViewer.getTable(), new Runnable(){

                    public void run() {
                        SearchNewsDialog.this.fResultViewer.refresh(true);
                    }
                });
            }
        };
        DynamicDAO.addEntityListener(ILabel.class, (EntityListener)this.fLabelListener);
    }

    private void onNewsEvent(final Set<NewsEvent> events) {
        if (this.fResultViewer.getInput() == null) {
            return;
        }
        JobRunner.runUIUpdater(new UIBackgroundJob((Control)this.getShell()){
            private List<ScoredNews> fDeletedScoredNews;
            private List<ScoredNews> fUpdatedScoredNews;
            private Set<NewsEvent> fUpdatedNewsEvents;

            protected void runInBackground(IProgressMonitor monitor) {
                List input = (List)SearchNewsDialog.this.fResultViewer.getInput();
                for (NewsEvent event : events) {
                    for (Object object : input) {
                        ScoredNews scoredNews = (ScoredNews)object;
                        NewsReference newsRef = scoredNews.getNewsReference();
                        if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                            return;
                        }
                        if (!newsRef.references((IEntity)event.getEntity())) continue;
                        INews news = event.getEntity();
                        if (!news.isVisible()) {
                            if (this.fDeletedScoredNews == null) {
                                this.fDeletedScoredNews = new ArrayList<ScoredNews>();
                            }
                            this.fDeletedScoredNews.add(scoredNews);
                            continue;
                        }
                        if (this.fUpdatedScoredNews == null) {
                            this.fUpdatedScoredNews = new ArrayList<ScoredNews>();
                        }
                        this.fUpdatedScoredNews.add(scoredNews);
                        if (this.fUpdatedNewsEvents == null) {
                            this.fUpdatedNewsEvents = new HashSet<NewsEvent>();
                        }
                        this.fUpdatedNewsEvents.add(event);
                    }
                }
            }

            protected void runInUI(IProgressMonitor monitor) {
                Object input;
                if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                    return;
                }
                if (this.fDeletedScoredNews != null) {
                    if (Application.isWindows7()) {
                        input = SearchNewsDialog.this.fResultViewer.getInput();
                        if (input instanceof List) {
                            ((List)input).removeAll(this.fDeletedScoredNews);
                            SearchNewsDialog.this.fResultViewer.refresh();
                        }
                    } else {
                        SearchNewsDialog.this.fResultViewer.remove(this.fDeletedScoredNews.toArray());
                    }
                }
                if (this.fUpdatedScoredNews != null) {
                    SearchNewsDialog.this.fResultViewer.update(this.fUpdatedScoredNews.toArray(), null);
                }
                if (SearchNewsDialog.this.fBrowserViewer.getControl().isVisible()) {
                    input = SearchNewsDialog.this.fBrowserViewer.getInput();
                    if (this.fUpdatedNewsEvents != null) {
                        for (NewsEvent event : this.fUpdatedNewsEvents) {
                            if (!event.getEntity().equals(input)) continue;
                            SearchNewsDialog.this.fBrowserViewer.update(Collections.singleton(event));
                            break;
                        }
                    }
                    if (this.fDeletedScoredNews != null) {
                        for (ScoredNews news : this.fDeletedScoredNews) {
                            if (!news.getNews().equals(input)) continue;
                            SearchNewsDialog.this.fBrowserViewer.remove(news.getNews());
                            break;
                        }
                    }
                }
            }
        });
    }

    private void onMouseDown(Event event) {
        Object data;
        Point p = new Point(event.x, event.y);
        TableItem item = this.fResultViewer.getTable().getItem(p);
        if (item == null || item.isDisposed()) {
            return;
        }
        if (event.button == 1 && this.isInImageBounds(item, NewsColumn.TITLE, p)) {
            Object data2 = item.getData();
            if (data2 instanceof ScoredNews) {
                INews news = ((ScoredNews)data2).getNews();
                INews.State newState = news.getState() == INews.State.READ ? INews.State.UNREAD : INews.State.READ;
                this.setNewsState(new ArrayList<INews>(Arrays.asList(news)), newState);
                this.fLastColumnActionInvokedMillies = System.currentTimeMillis();
            }
        } else if (event.button == 1 && this.isInImageBounds(item, NewsColumn.STICKY, p)) {
            Object data3 = item.getData();
            if (data3 instanceof ScoredNews) {
                new MakeNewsStickyAction((IStructuredSelection)new StructuredSelection((Object)((ScoredNews)data3).getNews())).run();
                this.fLastColumnActionInvokedMillies = System.currentTimeMillis();
            }
        } else if (event.button == 1 && this.isInImageBounds(item, NewsColumn.ATTACHMENTS, p) && (data = item.getData()) instanceof ScoredNews) {
            MenuManager contextMenu = new MenuManager();
            ApplicationActionBarAdvisor.fillAttachmentsMenu((IMenuManager)contextMenu, (IStructuredSelection)new StructuredSelection((Object)((ScoredNews)data).getNews()), (IShellProvider)this, true);
            if (this.fAttachmentsMenu != null) {
                OwlUI.safeDispose(this.fAttachmentsMenu);
            }
            this.fAttachmentsMenu = contextMenu.createContextMenu(this.fResultViewer.getControl());
            Point cursorLocation = item.getDisplay().getCursorLocation();
            cursorLocation.y += 16;
            this.fAttachmentsMenu.setLocation(cursorLocation);
            this.fAttachmentsMenu.setVisible(true);
            this.fLastColumnActionInvokedMillies = System.currentTimeMillis();
        }
    }

    private void onMouseMove(Event event) {
        boolean changeToHandCursor;
        Point p = new Point(event.x, event.y);
        TableItem item = this.fResultViewer.getTable().getItem(p);
        if (item == null || item.isDisposed() || item.getData() instanceof EntityGroup) {
            if (this.fShowsHandCursor && !this.fResultViewer.getControl().isDisposed()) {
                this.fResultViewer.getControl().setCursor(null);
                this.fShowsHandCursor = false;
            }
            return;
        }
        boolean bl = changeToHandCursor = this.isInImageBounds(item, NewsColumn.TITLE, p) || this.isInImageBounds(item, NewsColumn.STICKY, p) || this.isInImageBounds(item, NewsColumn.ATTACHMENTS, p);
        if (!this.fShowsHandCursor && changeToHandCursor) {
            this.fResultViewer.getControl().setCursor(this.fHandCursor);
            this.fShowsHandCursor = true;
        } else if (this.fShowsHandCursor && !changeToHandCursor) {
            this.fResultViewer.getControl().setCursor(null);
            this.fShowsHandCursor = false;
        }
    }

    private void unregisterListeners() {
        DynamicDAO.removeEntityListener(INews.class, (EntityListener)this.fNewsListener);
        DynamicDAO.removeEntityListener(ILabel.class, (EntityListener)this.fLabelListener);
    }

    private void onMouseDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (System.currentTimeMillis() - this.fLastColumnActionInvokedMillies > 200L) {
            List selectedElements = selection.toList();
            ArrayList<INews> selectedNews = new ArrayList<INews>();
            for (Object selectedElement : selectedElements) {
                ScoredNews scoredNews = (ScoredNews)selectedElement;
                selectedNews.add(scoredNews.getNews());
            }
            new OpenNewsAction((IStructuredSelection)new StructuredSelection(selectedNews), this.getShell()).run();
        }
    }

    private void hookContextualMenu() {
        IWorkbenchPart activePart;
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)SearchNewsDialog.this.fResultViewer.getSelection();
                manager.add((IContributionItem)new Separator("internalopen"));
                if (!selection.isEmpty()) {
                    manager.appendToGroup("internalopen", (IAction)new OpenNewsAction(selection, SearchNewsDialog.this.getShell()));
                }
                manager.add((IContributionItem)new GroupMarker("open"));
                if (!selection.isEmpty() && !OwlUI.useExternalBrowser()) {
                    manager.add((IAction)new OpenInExternalBrowserAction(selection));
                }
                ApplicationActionBarAdvisor.fillAttachmentsMenu(manager, selection, (IShellProvider)new SameShellProvider((Control)SearchNewsDialog.this.getShell()), false);
                if (!selection.isEmpty()) {
                    manager.add((IContributionItem)new Separator("mark"));
                    MenuManager markMenu = new MenuManager(Messages.SearchNewsDialog_MARK, "mark");
                    manager.add((IContributionItem)markMenu);
                    Action action = new ToggleReadStateAction(selection);
                    action.setEnabled(!selection.isEmpty());
                    markMenu.add((IAction)action);
                    markMenu.add((IContributionItem)new Separator());
                    action = new MakeNewsStickyAction(selection);
                    action.setEnabled(!selection.isEmpty());
                    markMenu.add((IAction)action);
                    ApplicationActionBarAdvisor.fillLabelMenu(manager, selection, (IShellProvider)new SameShellProvider((Control)SearchNewsDialog.this.getShell()), false);
                }
                if (!selection.isEmpty()) {
                    manager.add((IContributionItem)new Separator("movecopy"));
                    ArrayList newsbins = new ArrayList(DynamicDAO.loadAll(INewsBin.class));
                    Comparator<INewsBin> comparator = new Comparator<INewsBin>(){

                        @Override
                        public int compare(INewsBin o1, INewsBin o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    };
                    Collections.sort(newsbins, comparator);
                    MenuManager moveMenu = new MenuManager(Messages.SearchNewsDialog_MOVE, "moveto");
                    manager.add((IContributionItem)moveMenu);
                    for (INewsBin bin : newsbins) {
                        moveMenu.add((IAction)new MoveCopyNewsToBinAction(selection, bin, true));
                    }
                    moveMenu.add((IAction)new MoveCopyNewsToBinAction(selection, null, true));
                    moveMenu.add((IContributionItem)new Separator());
                    moveMenu.add((IAction)new AutomateFilterAction(CreateFilterAction.PresetAction.MOVE, (ISelection)selection));
                    MenuManager copyMenu = new MenuManager(Messages.SearchNewsDialog_COPY, "copyto");
                    manager.add((IContributionItem)copyMenu);
                    for (INewsBin bin : newsbins) {
                        copyMenu.add((IAction)new MoveCopyNewsToBinAction(selection, bin, false));
                    }
                    copyMenu.add((IAction)new MoveCopyNewsToBinAction(selection, null, false));
                    copyMenu.add((IContributionItem)new Separator());
                    copyMenu.add((IAction)new AutomateFilterAction(CreateFilterAction.PresetAction.COPY, (ISelection)selection));
                    manager.add((IAction)new ArchiveNewsAction(selection));
                }
                ApplicationActionBarAdvisor.fillShareMenu(manager, selection, (IShellProvider)new SameShellProvider((Control)SearchNewsDialog.this.getShell()), false);
                manager.add((IContributionItem)new Separator("filter"));
                manager.add((IContributionItem)new Separator("copy"));
                manager.add((IContributionItem)new GroupMarker("edit"));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = manager.createContextMenu(this.fResultViewer.getControl());
        this.fResultViewer.getControl().setMenu(menu);
        IWorkbenchWindow window = OwlUI.getWindow();
        if (window != null && (activePart = window.getPartService().getActivePart()) != null && activePart.getSite() != null) {
            activePart.getSite().registerContextMenu(manager, (ISelectionProvider)this.fResultViewer);
        }
    }

    private IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return SearchNewsDialog.this.getVisibleNews((List)inputElement);
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private Object[] getVisibleNews(List<?> elements) {
        ArrayList<ScoredNews> news = new ArrayList<ScoredNews>();
        Set visibleStates = INews.State.getVisible();
        for (Object element : elements) {
            ScoredNews scoredNews;
            if (!(element instanceof ScoredNews) || !visibleStates.contains((scoredNews = (ScoredNews)element).getState())) continue;
            news.add((ScoredNews)element);
        }
        return news.toArray();
    }

    private List<ISearchCondition> getDefaultConditions() {
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
        IModelFactory factory = Owl.getModelFactory();
        ISearchField field = factory.createSearchField(-1, INews.class.getName());
        ISearchCondition condition = factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)"");
        conditions.add(condition);
        return conditions;
    }

    protected int getShellStyle() {
        int style = 0xCF0 | SearchNewsDialog.getDefaultOrientation();
        return style;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings section = this.fDialogSettings.getSection(SETTINGS_SECTION);
        if (section != null) {
            return section;
        }
        return this.fDialogSettings.addNewSection(SETTINGS_SECTION);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.fFirstTimeOpen) {
            int minWidth = this.convertHorizontalDLUsToPixels(500);
            Point bestSize = this.getShell().computeSize(-1, -1);
            this.getShell().setSize(minWidth, bestSize.y);
            LayoutUtils.positionShell(this.getShell());
        }
        if (fgOpenDialogCount > 1) {
            Point location = this.getShell().getLocation();
            location.x += 20 * (fgOpenDialogCount - 1);
            location.y += 20 * (fgOpenDialogCount - 1);
            this.getShell().setLocation(location);
        }
    }

    private void setNewsState(List<INews> news, INews.State state) {
        boolean affectEquivalentNews = state != INews.State.UNREAD && OwlUI.markReadDuplicates();
        UndoStack.getInstance().addOperation(new NewsStateOperation(news, state, affectEquivalentNews));
        Owl.getPersistenceService().getDAOService().getNewsDAO().setState(news, state, affectEquivalentNews, false);
    }

    private int indexOf(NewsColumn column) {
        Table table = this.fCustomTable.getControl();
        if (table.isDisposed()) {
            return -1;
        }
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (column == columns[i].getData("org.rssowl.ui.internal.editors.feed.ColumnIdentifier")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isInImageBounds(TableItem item, NewsColumn column, Point p) {
        int index = this.indexOf(column);
        if (index == -1) {
            return false;
        }
        return item.getImageBounds(index).contains(p);
    }

    private static class FeedColumnToolTipSupport
    extends ColumnViewerToolTipSupport {
        FeedColumnToolTipSupport(ColumnViewer viewer, int style) {
            super(viewer, style, false);
        }

        protected Object getToolTipArea(Event event) {
            int feedIndex;
            Table table = (Table)event.widget;
            Point point = new Point(event.x, event.y);
            TableItem item = table.getItem(point);
            if (item != null && (feedIndex = FeedColumnToolTipSupport.indexOf(table, NewsColumn.FEED)) >= 0 && item.getBounds(feedIndex).contains(point)) {
                return super.getToolTipArea(event);
            }
            return null;
        }

        private static int indexOf(Table table, NewsColumn column) {
            if (table.isDisposed()) {
                return -1;
            }
            TableColumn[] columns = table.getColumns();
            int i = 0;
            while (i < columns.length) {
                if (column == columns[i].getData("org.rssowl.ui.internal.editors.feed.ColumnIdentifier")) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public static void enableFor(ColumnViewer viewer) {
            new FeedColumnToolTipSupport(viewer, 2);
        }
    }

    private class FirstTimeLowScoreFilter
    extends ViewerFilter {
        private final AtomicBoolean fEnabled = new AtomicBoolean(true);

        private FirstTimeLowScoreFilter() {
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            Object[] result = elements;
            if (this.fEnabled.get()) {
                result = super.filter(viewer, parent, elements);
                this.fEnabled.set(false);
            }
            SearchNewsDialog.this.fLowScoreNewsFilteredCount.set(elements.length - result.length);
            return result;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.fEnabled.get() && element instanceof ScoredNews) {
                ScoredNews news = (ScoredNews)element;
                return news.getRelevance() == Relevance.HIGH || news.getRelevance() == Relevance.MEDIUM;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Relevance {
        LOW,
        MEDIUM,
        HIGH;

    }

    private static class ScoredNews {
        private NewsReference fNewsRef;
        private INews fResolvedNews;
        private Float fScore;
        private Relevance fRelevance;
        private final INews.State fState;

        ScoredNews(NewsReference newsRef, INews.State state, Float score, Relevance relevance) {
            this.fNewsRef = newsRef;
            this.fState = state;
            this.fScore = score;
            this.fRelevance = relevance;
        }

        INews getNews() {
            if (this.fResolvedNews == null) {
                this.fResolvedNews = this.fNewsRef.resolve();
                if (this.fResolvedNews == null || !this.fResolvedNews.isVisible()) {
                    CoreUtils.reportIndexIssue();
                }
            }
            return this.fResolvedNews;
        }

        INews.State getState() {
            return this.fState;
        }

        NewsReference getNewsReference() {
            return this.fNewsRef;
        }

        Float getScore() {
            return this.fScore;
        }

        Relevance getRelevance() {
            return this.fRelevance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScoredNewsComparator
    extends ViewerComparator
    implements Comparator<ScoredNews> {
        private NewsComparator fNewsComparator = new NewsComparator();

        private ScoredNewsComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof ScoredNews) || !(e2 instanceof ScoredNews)) {
                return 0;
            }
            return this.compare((ScoredNews)e1, (ScoredNews)e2);
        }

        @Override
        public int compare(ScoredNews news1, ScoredNews news2) {
            if (this.fNewsComparator.getSortBy() != NewsColumn.RELEVANCE) {
                return this.fNewsComparator.compare(news1.getNews(), news2.getNews());
            }
            if (!news1.getScore().equals(news2.getScore())) {
                int result = news1.getScore().compareTo(news2.getScore());
                return this.fNewsComparator.isAscending() ? result : result * -1;
            }
            Date date1 = DateUtils.getRecentDate((INews)news1.getNews());
            Date date2 = DateUtils.getRecentDate((INews)news2.getNews());
            return date2.compareTo(date1);
        }

        void setAscending(boolean ascending) {
            this.fNewsComparator.setAscending(ascending);
        }

        void setSortBy(NewsColumn sortColumn) {
            this.fNewsComparator.setSortBy(sortColumn);
        }

        NewsColumn getSortBy() {
            return this.fNewsComparator.getSortBy();
        }

        boolean isAscending() {
            return this.fNewsComparator.isAscending();
        }
    }

    private static class ScoredNewsLabelProvider
    extends NewsTableLabelProvider {
        private Image fHighRelevanceIcon;
        private Image fMediumRelevanceIcon;
        private Image fLowRelevanceIcon;

        ScoredNewsLabelProvider(NewsColumnViewModel model) {
            super(model);
            this.createResources();
        }

        private void createResources() {
            this.fHighRelevanceIcon = OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/high.gif");
            this.fMediumRelevanceIcon = OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/medium.gif");
            this.fLowRelevanceIcon = OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/low.gif");
        }

        public void update(ViewerCell cell) {
            Item item;
            ScoredNews scoredNews = (ScoredNews)cell.getElement();
            NewsColumn column = this.fColumnModel.getColumn(cell.getColumnIndex());
            cell.setText(this.getColumnText(scoredNews.getNews(), column, cell.getColumnIndex()));
            cell.setImage(this.getColumnImage(scoredNews, column, cell.getColumnIndex()));
            cell.setFont(this.getFont(scoredNews.getNews(), cell.getColumnIndex()));
            Color foreground = this.getForeground(scoredNews.getNews(), cell.getColumnIndex());
            if (!OwlUI.isHighContrast() && (item = (Item)cell.getItem()) instanceof TableItem) {
                ((TableItem)cell.getItem()).setForeground(foreground);
            }
            if (!OwlUI.isHighContrast()) {
                cell.setBackground(this.getBackground(scoredNews.getNews(), cell.getColumnIndex()));
            }
        }

        protected Image getColumnImage(Object element, NewsColumn column, int colIndex) {
            if (column == NewsColumn.RELEVANCE) {
                ScoredNews scoredNews = (ScoredNews)element;
                switch (scoredNews.getRelevance()) {
                    case HIGH: {
                        return this.fHighRelevanceIcon;
                    }
                    case MEDIUM: {
                        return this.fMediumRelevanceIcon;
                    }
                    case LOW: {
                        return this.fLowRelevanceIcon;
                    }
                }
            }
            return super.getColumnImage(((ScoredNews)element).getNews(), column, colIndex);
        }

        public String getToolTipText(Object element) {
            INewsBin bin;
            ScoredNews scoredNews = (ScoredNews)element;
            INews news = scoredNews.getNews();
            String feedRef = news.getFeedLinkAsText();
            IBookMark bookMark = CoreUtils.getBookMark((String)feedRef);
            String name = null;
            name = bookMark != null ? bookMark.getName() : feedRef;
            if (news.getParentId() != 0L && (bin = (INewsBin)DynamicDAO.load(INewsBin.class, (long)news.getParentId())) != null) {
                name = NLS.bind((String)Messages.SearchNewsDialog_BIN_NAME, (Object)bin.getName(), (Object)name);
            }
            return StringUtils.replaceAll((String)name, (String)"&", (String)"&&");
        }

        public void erase(Event event, Object element) {
            super.erase(event, ((ScoredNews)element).getNews());
        }

        protected void paint(Event event, Object element) {
            super.paint(event, ((ScoredNews)element).getNews());
        }

        protected void measure(Event event, Object element) {
            super.measure(event, ((ScoredNews)element).getNews());
        }
    }
}

