/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.generic;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.marshall.ClassMarshaller;
import com.db4o.internal.marshall.FieldMarshaller;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.RawClassSpec;
import com.db4o.internal.marshall.RawFieldSpec;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.ReflectClassBuilder;

public class KnownClassesRepository {
    private static final Hashtable4 PRIMITIVES = new Hashtable4();
    private ObjectContainerBase _stream;
    private Transaction _trans;
    private ReflectClassBuilder _builder;
    private final Hashtable4 _classByName = new Hashtable4();
    private final Hashtable4 _classByID = new Hashtable4();
    private Collection4 _pendingClasses = new Collection4();
    private final Collection4 _classes = new Collection4();

    private static void registerPrimitive(Class clazz, Class clazz2) {
        PRIMITIVES.put(clazz.getName(), (Object)clazz2);
    }

    public KnownClassesRepository(ReflectClassBuilder reflectClassBuilder) {
        this._builder = reflectClassBuilder;
    }

    public void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this._trans = transaction;
            this._stream = transaction.stream();
        }
    }

    public void register(ReflectClass reflectClass) {
        this._classByName.put(reflectClass.getName(), (Object)reflectClass);
        this._classes.add(reflectClass);
    }

    public ReflectClass forID(int n) {
        if (this._stream.handlers().isSystemHandler(n)) {
            return this._stream.handlerByID(n).classReflector();
        }
        this.ensureClassAvailability(n);
        return this.lookupByID(n);
    }

    public ReflectClass forName(String string) {
        int n;
        ReflectClass reflectClass = (ReflectClass)this._classByName.get(string);
        if (reflectClass != null) {
            return reflectClass;
        }
        if (this._stream == null) {
            return null;
        }
        if (this._stream.classCollection() != null && (n = this._stream.classCollection().getYapClassID(string)) > 0) {
            reflectClass = this.ensureClassInitialised(n);
            this._classByName.put(string, (Object)reflectClass);
            return reflectClass;
        }
        return null;
    }

    private void readAll() {
        Iterator4 iterator4 = this._stream.classCollection().ids();
        while (iterator4.moveNext()) {
            this.ensureClassAvailability((Integer)iterator4.current());
        }
        iterator4 = this._stream.classCollection().ids();
        while (iterator4.moveNext()) {
            this.ensureClassRead((Integer)iterator4.current());
        }
    }

    private ReflectClass ensureClassAvailability(int n) {
        if (n == 0) {
            return null;
        }
        ReflectClass reflectClass = (ReflectClass)this._classByID.get(n);
        if (reflectClass != null) {
            return reflectClass;
        }
        ClassMarshaller classMarshaller = this.marshallerFamily()._class;
        StatefulBuffer statefulBuffer = this._stream.readWriterByID(this._trans, n);
        RawClassSpec rawClassSpec = classMarshaller.readSpec(this._trans, statefulBuffer);
        String string = rawClassSpec.name();
        reflectClass = (ReflectClass)this._classByName.get(string);
        if (reflectClass != null) {
            this._classByID.put(n, (Object)reflectClass);
            this._pendingClasses.add(new Integer(n));
            return reflectClass;
        }
        reflectClass = this._builder.createClass(string, this.ensureClassAvailability(rawClassSpec.superClassID()), rawClassSpec.numFields());
        this._classByID.put(n, (Object)reflectClass);
        this._pendingClasses.add(new Integer(n));
        return reflectClass;
    }

    private void ensureClassRead(int n) {
        ReflectClass reflectClass = this.lookupByID(n);
        ClassMarshaller classMarshaller = this.marshallerFamily()._class;
        StatefulBuffer statefulBuffer = this._stream.readWriterByID(this._trans, n);
        RawClassSpec rawClassSpec = classMarshaller.readSpec(this._trans, statefulBuffer);
        String string = rawClassSpec.name();
        if (this._classByName.get(string) != null) {
            return;
        }
        this._classByName.put(string, (Object)reflectClass);
        this._classes.add(reflectClass);
        int n2 = rawClassSpec.numFields();
        ReflectField[] reflectFieldArray = this._builder.fieldArray(n2);
        FieldMarshaller fieldMarshaller = this.marshallerFamily()._field;
        for (int i = 0; i < n2; ++i) {
            RawFieldSpec rawFieldSpec = fieldMarshaller.readSpec(this._stream, statefulBuffer);
            String string2 = rawFieldSpec.name();
            ReflectClass reflectClass2 = this.reflectClassForFieldSpec(rawFieldSpec);
            reflectFieldArray[i] = this._builder.createField(reflectClass, string2, reflectClass2, rawFieldSpec.isVirtual(), rawFieldSpec.isPrimitive(), rawFieldSpec.isArray(), rawFieldSpec.isNArray());
        }
        this._builder.initFields(reflectClass, reflectFieldArray);
    }

    private ReflectClass reflectClassForFieldSpec(RawFieldSpec rawFieldSpec) {
        if (rawFieldSpec.isVirtual()) {
            VirtualFieldMetadata virtualFieldMetadata = this._stream.handlers().virtualFieldByName(rawFieldSpec.name());
            return virtualFieldMetadata.getHandler().classReflector();
        }
        int n = rawFieldSpec.handlerID();
        ReflectClass reflectClass = null;
        switch (n) {
            case 11: {
                reflectClass = this._stream.reflector().forClass(Object.class);
                break;
            }
            case 12: {
                reflectClass = this.arrayClass(this._stream.reflector().forClass(Object.class));
                break;
            }
            default: {
                reflectClass = this.forID(n);
                reflectClass = this._stream.reflector().forName(reflectClass.getName());
                if (rawFieldSpec.isPrimitive()) {
                    reflectClass = this.primitiveClass(reflectClass);
                }
                if (!rawFieldSpec.isArray()) break;
                reflectClass = this.arrayClass(reflectClass);
            }
        }
        return reflectClass;
    }

    private MarshallerFamily marshallerFamily() {
        return MarshallerFamily.forConverterVersion(this._stream.converterVersion());
    }

    private ReflectClass ensureClassInitialised(int n) {
        ReflectClass reflectClass = this.ensureClassAvailability(n);
        while (this._pendingClasses.size() > 0) {
            Collection4 collection4 = this._pendingClasses;
            this._pendingClasses = new Collection4();
            Iterator4 iterator4 = collection4.iterator();
            while (iterator4.moveNext()) {
                this.ensureClassRead((Integer)iterator4.current());
            }
        }
        return reflectClass;
    }

    public Iterator4 classes() {
        this.readAll();
        return this._classes.iterator();
    }

    public void register(int n, ReflectClass reflectClass) {
        this._classByID.put(n, (Object)reflectClass);
    }

    public ReflectClass lookupByID(int n) {
        return (ReflectClass)this._classByID.get(n);
    }

    public ReflectClass lookupByName(String string) {
        return (ReflectClass)this._classByName.get(string);
    }

    private ReflectClass arrayClass(ReflectClass reflectClass) {
        Object object = reflectClass.reflector().array().newInstance(reflectClass, 0);
        return reflectClass.reflector().forObject(object);
    }

    private ReflectClass primitiveClass(ReflectClass reflectClass) {
        Class clazz = (Class)PRIMITIVES.get(reflectClass.getName());
        if (clazz != null) {
            return reflectClass.reflector().forClass(clazz);
        }
        return reflectClass;
    }

    static {
        KnownClassesRepository.registerPrimitive(Boolean.class, Boolean.TYPE);
        KnownClassesRepository.registerPrimitive(Byte.class, Byte.TYPE);
        KnownClassesRepository.registerPrimitive(Short.class, Short.TYPE);
        KnownClassesRepository.registerPrimitive(Character.class, Character.TYPE);
        KnownClassesRepository.registerPrimitive(Integer.class, Integer.TYPE);
        KnownClassesRepository.registerPrimitive(Long.class, Long.TYPE);
        KnownClassesRepository.registerPrimitive(Float.class, Float.TYPE);
        KnownClassesRepository.registerPrimitive(Double.class, Double.TYPE);
    }
}

