/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.CorruptionException;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.Transaction;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.RawClassSpec;

public abstract class ClassMarshaller {
    public MarshallerFamily _family;

    public RawClassSpec readSpec(Transaction transaction, Buffer buffer) {
        byte[] byArray = this.readName(transaction, buffer);
        String string = transaction.stream().stringIO().read(byArray);
        this.readMetaClassID(buffer);
        int n = buffer.readInt();
        buffer.incrementOffset(4);
        int n2 = buffer.readInt();
        return new RawClassSpec(string, n, n2);
    }

    public void write(Transaction transaction, ClassMetadata classMetadata, Buffer buffer) {
        buffer.writeShortString(transaction, classMetadata.nameToWrite());
        int n = 0;
        buffer.writeInt(n);
        buffer.writeIDOf(transaction, classMetadata.i_ancestor);
        this.writeIndex(transaction, classMetadata, buffer);
        FieldMetadata[] fieldMetadataArray = classMetadata.i_fields;
        if (fieldMetadataArray == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(fieldMetadataArray.length);
        for (int i = 0; i < fieldMetadataArray.length; ++i) {
            this._family._field.write(transaction, classMetadata, fieldMetadataArray[i], buffer);
        }
    }

    protected void writeIndex(Transaction transaction, ClassMetadata classMetadata, Buffer buffer) {
        int n = classMetadata.index().write(transaction);
        buffer.writeInt(this.indexIDForWriting(n));
    }

    protected abstract int indexIDForWriting(int var1);

    public byte[] readName(Transaction transaction, Buffer buffer) {
        byte[] byArray = this.readName(transaction.stream().stringIO(), buffer);
        return byArray;
    }

    public int readMetaClassID(Buffer buffer) {
        return buffer.readInt();
    }

    private byte[] readName(LatinStringIO latinStringIO, Buffer buffer) {
        int n = buffer.readInt();
        byte[] byArray = new byte[n *= latinStringIO.bytesPerChar()];
        System.arraycopy(buffer._buffer, buffer._offset, byArray, 0, n);
        buffer.incrementOffset(n);
        return byArray;
    }

    public void read(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata, Buffer buffer) {
        classMetadata.i_ancestor = objectContainerBase.getYapClass(buffer.readInt());
        if (classMetadata.i_dontCallConstructors) {
            classMetadata.createConstructor(objectContainerBase, classMetadata.classReflector(), classMetadata.getName(), true);
        }
        classMetadata.checkType();
        this.readIndex(objectContainerBase, classMetadata, buffer);
        classMetadata.i_fields = this.createFields(classMetadata, buffer.readInt());
        this.readFields(objectContainerBase, buffer, classMetadata.i_fields);
    }

    protected abstract void readIndex(ObjectContainerBase var1, ClassMetadata var2, Buffer var3);

    private FieldMetadata[] createFields(ClassMetadata classMetadata, int n) {
        FieldMetadata[] fieldMetadataArray = new FieldMetadata[n];
        for (int i = 0; i < fieldMetadataArray.length; ++i) {
            fieldMetadataArray[i] = new FieldMetadata(classMetadata);
            fieldMetadataArray[i].setArrayPosition(i);
        }
        return fieldMetadataArray;
    }

    private void readFields(ObjectContainerBase objectContainerBase, Buffer buffer, FieldMetadata[] fieldMetadataArray) {
        for (int i = 0; i < fieldMetadataArray.length; ++i) {
            fieldMetadataArray[i] = this._family._field.read(objectContainerBase, fieldMetadataArray[i], buffer);
        }
    }

    public int marshalledLength(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata) {
        int n = objectContainerBase.stringIO().shortLength(classMetadata.nameToWrite()) + 0 + 8 + 4;
        n += classMetadata.index().ownLength();
        if (classMetadata.i_fields != null) {
            for (int i = 0; i < classMetadata.i_fields.length; ++i) {
                n += this._family._field.marshalledLength(objectContainerBase, classMetadata.i_fields[i]);
            }
        }
        return n;
    }

    public void defrag(ClassMetadata classMetadata, LatinStringIO latinStringIO, ReaderPair readerPair, int n) throws CorruptionException {
        this.readName(latinStringIO, readerPair.source());
        this.readName(latinStringIO, readerPair.target());
        int n2 = 0;
        readerPair.writeInt(n2);
        readerPair.copyID();
        readerPair.writeInt(this.indexIDForWriting(n));
        readerPair.incrementIntSize();
        FieldMetadata[] fieldMetadataArray = classMetadata.i_fields;
        for (int i = 0; i < fieldMetadataArray.length; ++i) {
            this._family._field.defrag(classMetadata, fieldMetadataArray[i], latinStringIO, readerPair);
        }
    }
}

