/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.defragment.DefragContextImpl;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.DefragmentInfo;
import com.db4o.defragment.DefragmentListener;
import com.db4o.defragment.FirstPassCommand;
import com.db4o.defragment.PassCommand;
import com.db4o.defragment.SecondPassCommand;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.io.File4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.handlers.StringHandler;
import java.io.File;
import java.io.IOException;

public class Defragment {
    public static void defrag(String string) throws IOException {
        Defragment.defrag(new DefragmentConfig(string), new NullListener());
    }

    public static void defrag(String string, String string2) throws IOException {
        Defragment.defrag(new DefragmentConfig(string, string2), new NullListener());
    }

    public static void defrag(DefragmentConfig defragmentConfig) throws IOException {
        Defragment.defrag(defragmentConfig, new NullListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defrag(DefragmentConfig defragmentConfig, DefragmentListener defragmentListener) throws IOException {
        File file = new File(defragmentConfig.backupPath());
        if (file.exists()) {
            if (!defragmentConfig.forceBackupDelete()) {
                throw new IOException("Could not use '" + defragmentConfig.backupPath() + "' as backup path - file exists.");
            }
            file.delete();
        }
        File4.rename(defragmentConfig.origPath(), defragmentConfig.backupPath());
        if (defragmentConfig.fileNeedsUpgrade()) {
            Defragment.upgradeFile(defragmentConfig);
        }
        DefragContextImpl defragContextImpl = new DefragContextImpl(defragmentConfig, defragmentListener);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            Defragment.firstPass(defragContextImpl, defragmentConfig);
            Defragment.secondPass(defragContextImpl, defragmentConfig);
            Defragment.defragUnindexed(defragContextImpl);
            n = defragContextImpl.mappedID(defragContextImpl.sourceClassCollectionID());
            defragContextImpl.targetClassCollectionID(n);
            int n4 = defragContextImpl.databaseIdentityID(DefragContextImpl.SOURCEDB);
            n2 = defragContextImpl.mappedID(n4, 0);
            n3 = defragContextImpl.mappedID(defragContextImpl.sourceUuidIndexID(), 0);
        }
        catch (CorruptionException corruptionException) {
            corruptionException.printStackTrace();
        }
        finally {
            defragContextImpl.close();
        }
        if (n2 > 0) {
            Defragment.setIdentity(defragmentConfig.origPath(), n2, n3, defragmentConfig.blockSize());
        } else {
            defragmentListener.notifyDefragmentInfo(new DefragmentInfo("No database identity found in original file."));
        }
    }

    private static void upgradeFile(DefragmentConfig defragmentConfig) {
        File4.copy(defragmentConfig.backupPath(), defragmentConfig.tempPath());
        Configuration configuration = (Configuration)((Config4Impl)defragmentConfig.db4oConfig()).deepClone(null);
        configuration.allowVersionUpdates(true);
        ObjectContainer objectContainer = Db4o.openFile(configuration, defragmentConfig.tempPath());
        objectContainer.close();
    }

    private static void defragUnindexed(DefragContextImpl defragContextImpl) throws CorruptionException {
        Iterator4 iterator4 = defragContextImpl.unindexedIDs();
        while (iterator4.moveNext()) {
            int n = (Integer)iterator4.current();
            ReaderPair.processCopy(defragContextImpl, n, new SlotCopyHandler(){

                public void processCopy(ReaderPair readerPair) throws CorruptionException {
                    ClassMetadata.defragObject(readerPair);
                }
            }, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setIdentity(String string, int n, int n2, int n3) {
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)Db4o.openFile(DefragmentConfig.vanillaDb4oConfig(n3), string);
        try {
            Db4oDatabase db4oDatabase = (Db4oDatabase)localObjectContainer.getByID(n);
            localObjectContainer.setIdentity(db4oDatabase);
            localObjectContainer.systemData().uuidIndexId(n2);
        }
        finally {
            localObjectContainer.close();
        }
    }

    private static void firstPass(DefragContextImpl defragContextImpl, DefragmentConfig defragmentConfig) throws CorruptionException {
        Defragment.pass(defragContextImpl, defragmentConfig, new FirstPassCommand());
    }

    private static void secondPass(DefragContextImpl defragContextImpl, DefragmentConfig defragmentConfig) throws CorruptionException {
        Defragment.pass(defragContextImpl, defragmentConfig, new SecondPassCommand(defragmentConfig.objectCommitFrequency()));
    }

    private static void pass(DefragContextImpl defragContextImpl, DefragmentConfig defragmentConfig, PassCommand passCommand) throws CorruptionException {
        passCommand.processClassCollection(defragContextImpl);
        StoredClass[] storedClassArray = defragContextImpl.storedClasses(DefragContextImpl.SOURCEDB);
        for (int i = 0; i < storedClassArray.length; ++i) {
            ClassMetadata classMetadata = (ClassMetadata)storedClassArray[i];
            if (!defragmentConfig.storedClassFilter().accept(classMetadata)) continue;
            Defragment.processYapClass(defragContextImpl, classMetadata, passCommand);
            passCommand.flush(defragContextImpl);
            if (defragmentConfig.objectCommitFrequency() <= 0) continue;
            defragContextImpl.targetCommit();
        }
        BTree bTree = defragContextImpl.sourceUuidIndex();
        if (bTree != null) {
            passCommand.processBTree(defragContextImpl, bTree);
        }
        passCommand.flush(defragContextImpl);
        defragContextImpl.targetCommit();
    }

    private static void processYapClass(DefragContextImpl defragContextImpl, ClassMetadata classMetadata, PassCommand passCommand) throws CorruptionException {
        Defragment.processClassIndex(defragContextImpl, classMetadata, passCommand);
        if (!Defragment.parentHasIndex(classMetadata)) {
            Defragment.processObjectsForYapClass(defragContextImpl, classMetadata, passCommand);
        }
        Defragment.processYapClassAndFieldIndices(defragContextImpl, classMetadata, passCommand);
    }

    private static boolean parentHasIndex(ClassMetadata classMetadata) {
        ClassMetadata classMetadata2 = classMetadata.i_ancestor;
        while (classMetadata2 != null) {
            if (classMetadata2.hasIndex()) {
                return true;
            }
            classMetadata2 = classMetadata2.i_ancestor;
        }
        return false;
    }

    private static void processObjectsForYapClass(final DefragContextImpl defragContextImpl, final ClassMetadata classMetadata, final PassCommand passCommand) {
        final boolean bl = Defragment.withFieldIndex(classMetadata);
        defragContextImpl.traverseAll(classMetadata, new Visitor4(){

            public void visit(Object object) {
                int n = (Integer)object;
                try {
                    passCommand.processObjectSlot(defragContextImpl, classMetadata, n, bl);
                }
                catch (CorruptionException corruptionException) {
                    corruptionException.printStackTrace();
                }
            }
        });
    }

    private static boolean withFieldIndex(ClassMetadata classMetadata) {
        Iterator4 iterator4 = classMetadata.fields();
        while (iterator4.moveNext()) {
            FieldMetadata fieldMetadata = (FieldMetadata)iterator4.current();
            if (!fieldMetadata.hasIndex() || !(fieldMetadata.getHandler() instanceof StringHandler)) continue;
            return true;
        }
        return false;
    }

    private static void processYapClassAndFieldIndices(DefragContextImpl defragContextImpl, ClassMetadata classMetadata, PassCommand passCommand) throws CorruptionException {
        int n = 0;
        int n2 = 0;
        if (classMetadata.hasIndex()) {
            n = classMetadata.index().id();
            n2 = defragContextImpl.mappedID(n, -1);
        }
        passCommand.processClass(defragContextImpl, classMetadata, classMetadata.getID(), n2);
    }

    private static void processClassIndex(DefragContextImpl defragContextImpl, ClassMetadata classMetadata, PassCommand passCommand) throws CorruptionException {
        if (classMetadata.hasIndex()) {
            BTreeClassIndexStrategy bTreeClassIndexStrategy = (BTreeClassIndexStrategy)classMetadata.index();
            BTree bTree = bTreeClassIndexStrategy.btree();
            passCommand.processBTree(defragContextImpl, bTree);
        }
    }

    static class NullListener
    implements DefragmentListener {
        NullListener() {
        }

        public void notifyDefragmentInfo(DefragmentInfo defragmentInfo) {
        }
    }
}

