/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.interpreter.Messages;
import org.rssowl.core.internal.interpreter.OPMLConstants;
import org.rssowl.core.interpreter.ITypeExporter;
import org.rssowl.core.interpreter.InterpreterException;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.pref.IPreferenceType;
import org.rssowl.core.persist.pref.Preference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPMLExporter
implements ITypeExporter {
    private static final String UTF_8 = "UTF-8";

    @Override
    public void exportTo(File destination, Collection<? extends IFolderChild> elements, Set<ITypeExporter.Options> options) throws InterpreterException {
        boolean exportPreferences;
        Format format = Format.getPrettyFormat();
        format.setEncoding(UTF_8);
        XMLOutputter output = new XMLOutputter(format);
        DateFormat dateFormat = DateFormat.getDateInstance();
        Document document = new Document();
        Element root = new Element(OPMLConstants.Tag.OPML.get());
        root.setAttribute(OPMLConstants.Attributes.VERSION.get(), "1.1");
        root.addNamespaceDeclaration(OPMLConstants.RSSOWL_NS);
        document.setRootElement(root);
        Element head = new Element(OPMLConstants.Tag.HEAD.get());
        root.addContent((Content)head);
        Element title = new Element(OPMLConstants.Tag.TITLE.get());
        title.setText(Messages.OPMLExporter_RSSOWL_SUBSCRIPTIONS);
        head.addContent((Content)title);
        Element dateModified = new Element(OPMLConstants.Tag.DATE_MODIFIED.get());
        dateModified.setText(new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").format(new Date()));
        head.addContent((Content)dateModified);
        Element body = new Element(OPMLConstants.Tag.BODY.get());
        root.addContent((Content)body);
        boolean bl = exportPreferences = options != null && options.contains((Object)ITypeExporter.Options.EXPORT_PREFERENCES);
        if (elements != null && !elements.isEmpty()) {
            HashMap<IFolder, Element> mapFolderToElement = new HashMap<IFolder, Element>();
            mapFolderToElement.put(null, body);
            this.repairHierarchy(mapFolderToElement, elements, exportPreferences);
            this.exportFolderChilds(mapFolderToElement, elements, exportPreferences, dateFormat);
        }
        if (options != null && options.contains((Object)ITypeExporter.Options.EXPORT_LABELS)) {
            this.exportLabels(body);
        }
        if (options != null && options.contains((Object)ITypeExporter.Options.EXPORT_FILTERS)) {
            this.exportFilters(body, dateFormat);
        }
        if (exportPreferences) {
            this.exportPreferences(body);
        }
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(destination);
                output.output(document, (OutputStream)out);
                out.close();
            }
            catch (FileNotFoundException e) {
                throw new InterpreterException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
            catch (IOException e) {
                throw new InterpreterException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new InterpreterException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
                }
            }
        }
    }

    private void repairHierarchy(Map<IFolder, Element> mapFolderToElement, Collection<? extends IFolderChild> elementsToExport, boolean exportPreferences) {
        Element folderElement;
        HashSet<IFolder> allParentFolders = new HashSet<IFolder>();
        for (IFolderChild iFolderChild : elementsToExport) {
            this.fillParents(allParentFolders, iFolderChild);
        }
        if (allParentFolders.isEmpty()) {
            return;
        }
        for (IFolder iFolder : allParentFolders) {
            folderElement = this.createElement(iFolder, exportPreferences);
            mapFolderToElement.put(iFolder, folderElement);
        }
        for (IFolder iFolder : allParentFolders) {
            folderElement = mapFolderToElement.get(iFolder);
            Element parentElement = mapFolderToElement.get(iFolder.getParent());
            parentElement.addContent((Content)folderElement);
        }
    }

    private void fillParents(Set<IFolder> parents, IFolderChild child) {
        IFolder parent = child.getParent();
        if (parent != null) {
            parents.add(parent);
            this.fillParents(parents, parent);
        }
    }

    private void exportFolderChilds(Map<IFolder, Element> mapFolderToElement, Collection<? extends IFolderChild> childs, boolean exportPreferences, DateFormat df) {
        for (IFolderChild iFolderChild : childs) {
            if (iFolderChild instanceof IFolder) {
                this.exportFolder(mapFolderToElement, (IFolder)iFolderChild, exportPreferences, df);
                continue;
            }
            if (!(iFolderChild instanceof IMark)) continue;
            this.exportMark(mapFolderToElement, (IMark)iFolderChild, exportPreferences, df);
        }
    }

    private Element createElement(IFolder folder, boolean exportPreferences) {
        Element folderElement = new Element(OPMLConstants.Tag.OUTLINE.get());
        folderElement.setAttribute(OPMLConstants.Attributes.TEXT.get(), folder.getName());
        folderElement.setAttribute(OPMLConstants.Attributes.IS_SET.get(), String.valueOf(folder.getParent() == null), OPMLConstants.RSSOWL_NS);
        folderElement.setAttribute(OPMLConstants.Attributes.ID.get(), String.valueOf(folder.getId()), OPMLConstants.RSSOWL_NS);
        if (exportPreferences) {
            this.exportPreferences(folderElement, folder);
        }
        return folderElement;
    }

    private void exportFolder(Map<IFolder, Element> mapFolderToElement, IFolder folder, boolean exportPreferences, DateFormat df) {
        Element folderElement = this.createElement(folder, exportPreferences);
        mapFolderToElement.put(folder, folderElement);
        mapFolderToElement.get(folder.getParent()).addContent((Content)folderElement);
        this.exportFolderChilds(mapFolderToElement, folder.getChildren(), exportPreferences, df);
    }

    private void exportPreferences(Element parent, IFolderChild child) {
        Map<String, Serializable> properties = child.getProperties();
        if (properties != null) {
            Set<Map.Entry<String, Serializable>> entries = properties.entrySet();
            for (Map.Entry<String, Serializable> entry : entries) {
                String value;
                if (!StringUtils.isSet(entry.getKey()) || entry.getValue() == null || (value = this.getValueAsString(entry.getValue())) == null) continue;
                Element prefElement = new Element(OPMLConstants.Tag.PREFERENCE.get(), OPMLConstants.RSSOWL_NS);
                prefElement.setAttribute(OPMLConstants.Attributes.ID.get(), entry.getKey());
                prefElement.setAttribute(OPMLConstants.Attributes.VALUE.get(), value);
                prefElement.setAttribute(OPMLConstants.Attributes.TYPE.get(), String.valueOf(IPreferenceType.getType(entry.getValue()).ordinal()));
                parent.addContent((Content)prefElement);
            }
        }
    }

    private String getValueAsString(Object property) {
        if (property instanceof String) {
            return (String)property;
        }
        if (property instanceof Long || property instanceof Integer || property instanceof Boolean) {
            return String.valueOf(property);
        }
        if (property instanceof long[]) {
            long[] values = (long[])property;
            StringBuilder builder = new StringBuilder();
            long[] lArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                long val = lArray[n2];
                builder.append(val).append(",");
                ++n2;
            }
            if (values.length > 0) {
                builder.delete(builder.length() - 1, builder.length());
            }
            return builder.toString();
        }
        if (property instanceof int[]) {
            int[] values = (int[])property;
            StringBuilder builder = new StringBuilder();
            int[] nArray = values;
            int n = values.length;
            int n3 = 0;
            while (n3 < n) {
                int val = nArray[n3];
                builder.append(val).append(",");
                ++n3;
            }
            if (values.length > 0) {
                builder.delete(builder.length() - 1, builder.length());
            }
            return builder.toString();
        }
        if (property instanceof String[]) {
            String[] values = (String[])property;
            StringBuilder builder = new StringBuilder();
            String[] stringArray = values;
            int n = values.length;
            int n4 = 0;
            while (n4 < n) {
                String val = stringArray[n4];
                builder.append(val).append(",");
                ++n4;
            }
            if (values.length > 0) {
                builder.delete(builder.length() - 1, builder.length());
            }
            return builder.toString();
        }
        return null;
    }

    private void exportMark(Map<IFolder, Element> mapFolderToElement, IMark mark, boolean exportPreferences, DateFormat df) {
        String name = mark.getName();
        Element element = null;
        if (mark instanceof IBookMark) {
            String link = ((IBookMark)mark).getFeedLinkReference().getLinkAsText();
            element = new Element(OPMLConstants.Tag.OUTLINE.get());
            element.setAttribute(OPMLConstants.Attributes.TEXT.get(), name);
            element.setAttribute(OPMLConstants.Attributes.XML_URL.get(), link);
            element.setAttribute(OPMLConstants.Attributes.ID.get(), String.valueOf(mark.getId()), OPMLConstants.RSSOWL_NS);
            mapFolderToElement.get(mark.getParent()).addContent((Content)element);
        } else if (mark instanceof ISearchMark) {
            ISearchMark searchMark = (ISearchMark)mark;
            List conditions = searchMark.getSearchConditions();
            element = new Element(OPMLConstants.Tag.SAVED_SEARCH.get(), OPMLConstants.RSSOWL_NS);
            element.setAttribute(OPMLConstants.Attributes.NAME.get(), name);
            element.setAttribute(OPMLConstants.Attributes.MATCH_ALL_CONDITIONS.get(), String.valueOf(searchMark.matchAllConditions()));
            element.setAttribute(OPMLConstants.Attributes.ID.get(), String.valueOf(mark.getId()), OPMLConstants.RSSOWL_NS);
            mapFolderToElement.get(mark.getParent()).addContent((Content)element);
            for (ISearchCondition condition : conditions) {
                Element conditionElement = new Element(OPMLConstants.Tag.SEARCH_CONDITION.get(), OPMLConstants.RSSOWL_NS);
                element.addContent((Content)conditionElement);
                if (condition.getValue() == null) continue;
                this.fillElement(conditionElement, condition, df);
            }
        } else if (mark instanceof INewsBin) {
            element = new Element(OPMLConstants.Tag.BIN.get(), OPMLConstants.RSSOWL_NS);
            element.setAttribute(OPMLConstants.Attributes.NAME.get(), name);
            element.setAttribute(OPMLConstants.Attributes.ID.get(), String.valueOf(mark.getId()), OPMLConstants.RSSOWL_NS);
            mapFolderToElement.get(mark.getParent()).addContent((Content)element);
        }
        if (element != null && exportPreferences) {
            this.exportPreferences(element, mark);
        }
    }

    private void exportFilters(Element body, DateFormat df) {
        Collection<ISearchFilter> filters = DynamicDAO.loadAll(ISearchFilter.class);
        for (ISearchFilter filter : filters) {
            String name = filter.getName();
            int order = filter.getOrder();
            boolean isEnabled = filter.isEnabled() && !CoreUtils.isOrphaned(filter);
            boolean matchAllNews = filter.matchAllNews();
            Element filterElement = new Element(OPMLConstants.Tag.FILTER.get(), OPMLConstants.RSSOWL_NS);
            filterElement.setAttribute(OPMLConstants.Attributes.NAME.get(), name);
            filterElement.setAttribute(OPMLConstants.Attributes.ORDER.get(), String.valueOf(order));
            filterElement.setAttribute(OPMLConstants.Attributes.ENABLED.get(), String.valueOf(isEnabled));
            filterElement.setAttribute(OPMLConstants.Attributes.MATCH_ALL_NEWS.get(), String.valueOf(matchAllNews));
            body.addContent((Content)filterElement);
            ISearch search = filter.getSearch();
            if (search != null) {
                List<ISearchCondition> conditions = search.getSearchConditions();
                Element searchElement = new Element(OPMLConstants.Tag.SEARCH.get(), OPMLConstants.RSSOWL_NS);
                searchElement.setAttribute(OPMLConstants.Attributes.MATCH_ALL_CONDITIONS.get(), String.valueOf(search.matchAllConditions()));
                filterElement.addContent((Content)searchElement);
                for (ISearchCondition condition : conditions) {
                    Element conditionElement = new Element(OPMLConstants.Tag.SEARCH_CONDITION.get(), OPMLConstants.RSSOWL_NS);
                    searchElement.addContent((Content)conditionElement);
                    if (condition.getValue() == null) continue;
                    this.fillElement(conditionElement, condition, df);
                }
            }
            List<IFilterAction> actions = filter.getActions();
            for (IFilterAction action : actions) {
                Object data;
                String actionId = action.getActionId();
                Element actionElement = new Element(OPMLConstants.Tag.ACTION.get(), OPMLConstants.RSSOWL_NS);
                actionElement.setAttribute(OPMLConstants.Attributes.ID.get(), actionId);
                if (action.getData() instanceof Properties) {
                    data = (Properties)action.getData();
                    Set<Map.Entry<Object, Object>> entries = ((Properties)data).entrySet();
                    for (Map.Entry<Object, Object> entry : entries) {
                        String key = entry.getKey().toString();
                        String value = entry.getValue().toString();
                        Element actionProperty = new Element(OPMLConstants.Tag.ACTION_PROPERTY.get(), OPMLConstants.RSSOWL_NS);
                        actionProperty.setAttribute(OPMLConstants.Attributes.ID.get(), key);
                        actionProperty.setAttribute(OPMLConstants.Attributes.VALUE.get(), value);
                        actionElement.addContent((Content)actionProperty);
                    }
                } else {
                    data = this.toString(action.getData());
                    if (data != null) {
                        actionElement.setAttribute(OPMLConstants.Attributes.DATA.get(), (String)data);
                    }
                }
                filterElement.addContent((Content)actionElement);
            }
        }
    }

    private void fillElement(Element conditionElement, ISearchCondition condition, DateFormat df) {
        Element searchSpecifier = new Element(OPMLConstants.Tag.SPECIFIER.get(), OPMLConstants.RSSOWL_NS);
        searchSpecifier.setAttribute(OPMLConstants.Attributes.ID.get(), String.valueOf(condition.getSpecifier().ordinal()));
        conditionElement.addContent((Content)searchSpecifier);
        if (condition.getValue() instanceof Long[][]) {
            List<IFolderChild> locations = CoreUtils.toEntities((Long[][])condition.getValue());
            Element searchValue = new Element(OPMLConstants.Tag.SEARCH_VALUE.get(), OPMLConstants.RSSOWL_NS);
            searchValue.setAttribute(OPMLConstants.Attributes.TYPE.get(), String.valueOf(condition.getField().getSearchValueType().getId()));
            conditionElement.addContent((Content)searchValue);
            for (IFolderChild child : locations) {
                boolean isFolder = child instanceof IFolder;
                boolean isNewsbin = child instanceof INewsBin;
                Element location = new Element(OPMLConstants.Tag.LOCATION.get(), OPMLConstants.RSSOWL_NS);
                location.setAttribute(OPMLConstants.Attributes.IS_BIN.get(), String.valueOf(isNewsbin));
                location.setAttribute(OPMLConstants.Attributes.IS_FOLDER.get(), String.valueOf(isFolder));
                location.setAttribute(OPMLConstants.Attributes.VALUE.get(), String.valueOf(child.getId()));
                searchValue.addContent((Content)location);
            }
        } else if (!EnumSet.class.isAssignableFrom(condition.getValue().getClass())) {
            Element searchValue = new Element(OPMLConstants.Tag.SEARCH_VALUE.get(), OPMLConstants.RSSOWL_NS);
            searchValue.setAttribute(OPMLConstants.Attributes.TYPE.get(), String.valueOf(condition.getField().getSearchValueType().getId()));
            searchValue.setAttribute(OPMLConstants.Attributes.VALUE.get(), this.getValueString(df, condition));
            conditionElement.addContent((Content)searchValue);
        } else {
            EnumSet values = (EnumSet)condition.getValue();
            Element searchValue = new Element(OPMLConstants.Tag.SEARCH_VALUE.get(), OPMLConstants.RSSOWL_NS);
            searchValue.setAttribute(OPMLConstants.Attributes.TYPE.get(), String.valueOf(condition.getField().getSearchValueType().getId()));
            conditionElement.addContent((Content)searchValue);
            for (Enum enumValue : values) {
                Element state = new Element(OPMLConstants.Tag.STATE.get(), OPMLConstants.RSSOWL_NS);
                state.setAttribute(OPMLConstants.Attributes.VALUE.get(), String.valueOf(enumValue.ordinal()));
                searchValue.addContent((Content)state);
            }
        }
        Element field = new Element(OPMLConstants.Tag.SEARCH_FIELD.get(), OPMLConstants.RSSOWL_NS);
        field.setAttribute(OPMLConstants.Attributes.ID.get(), String.valueOf(condition.getField().getId()));
        field.setAttribute(OPMLConstants.Attributes.ENTITY.get(), condition.getField().getEntityName());
        conditionElement.addContent((Content)field);
    }

    private String toString(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof Long) {
            return String.valueOf(data);
        }
        if (data instanceof Long[]) {
            Long[] value = (Long[])data;
            StringBuilder builder = new StringBuilder();
            Long[] longArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                Long val = longArray[n2];
                builder.append(val).append(",");
                ++n2;
            }
            if (value.length > 0) {
                builder.delete(builder.length() - 1, builder.length());
            }
            return builder.toString();
        }
        return null;
    }

    private String getValueString(DateFormat df, ISearchCondition condition) {
        if (condition.getValue() instanceof Date) {
            return df.format((Date)condition.getValue());
        }
        return condition.getValue().toString();
    }

    private void exportLabels(Element body) {
        Collection<ILabel> labels = DynamicDAO.loadAll(ILabel.class);
        for (ILabel label : labels) {
            Long id = label.getId();
            String name = label.getName();
            String color = label.getColor();
            int order = label.getOrder();
            Element labelElement = new Element(OPMLConstants.Tag.LABEL.get(), OPMLConstants.RSSOWL_NS);
            labelElement.setAttribute(OPMLConstants.Attributes.ID.get(), String.valueOf(id));
            labelElement.setAttribute(OPMLConstants.Attributes.NAME.get(), name);
            labelElement.setAttribute(OPMLConstants.Attributes.ORDER.get(), String.valueOf(order));
            labelElement.setAttribute(OPMLConstants.Attributes.COLOR.get(), color);
            body.addContent((Content)labelElement);
        }
    }

    private void exportPreferences(Element body) {
        Preference[] preferences;
        IPreferenceScope globalPreferences = Owl.getPreferenceService().getGlobalScope();
        IPreferenceScope eclipsePreferences = Owl.getPreferenceService().getEclipseScope();
        Preference[] preferenceArray = preferences = Preference.values();
        int n = preferences.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            Preference preference = preferenceArray[n2];
            if (preference.getKind() != IPreferenceScope.Kind.ENTITY && (value = this.getValueAsString(preference, globalPreferences, eclipsePreferences)) != null) {
                Element prefElement = new Element(OPMLConstants.Tag.PREFERENCE.get(), OPMLConstants.RSSOWL_NS);
                prefElement.setAttribute(OPMLConstants.Attributes.ID.get(), preference.id());
                prefElement.setAttribute(OPMLConstants.Attributes.VALUE.get(), value);
                prefElement.setAttribute(OPMLConstants.Attributes.TYPE.get(), String.valueOf(preference.getType().ordinal()));
                prefElement.setAttribute(OPMLConstants.Attributes.KIND.get(), String.valueOf(preference.getKind().ordinal()));
                body.addContent((Content)prefElement);
            }
            ++n2;
        }
    }

    private String getValueAsString(Preference preference, IPreferenceScope global, IPreferenceScope eclipse) {
        IPreferenceScope actualScope = preference.getKind() == IPreferenceScope.Kind.GLOBAL ? global : eclipse;
        String id = preference.id();
        switch (preference.getType()) {
            case BOOLEAN: {
                return this.getValueAsString(actualScope.getBoolean(id));
            }
            case INTEGER: {
                return this.getValueAsString(actualScope.getInteger(id));
            }
            case INTEGERS: {
                return this.getValueAsString(actualScope.getIntegers(id));
            }
            case LONG: {
                return this.getValueAsString(actualScope.getLong(id));
            }
            case LONGS: {
                return this.getValueAsString(actualScope.getLongs(id));
            }
            case STRING: {
                return this.getValueAsString(actualScope.getString(id));
            }
            case STRINGS: {
                return this.getValueAsString(actualScope.getStrings(id));
            }
        }
        return null;
    }
}

