/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.AlphanumComparator;
import com.jidesoft.comparator.BooleanComparator;
import com.jidesoft.comparator.CalendarComparator;
import com.jidesoft.comparator.CharSequenceComparator;
import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.DateComparator;
import com.jidesoft.comparator.DefaultComparator;
import com.jidesoft.comparator.FastComparableComparator;
import com.jidesoft.comparator.NumberComparator;
import com.jidesoft.utils.CacheMap;
import com.jidesoft.utils.RegistrationListener;
import java.text.Collator;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

public class ObjectComparatorManager {
    private static final CacheMap<Comparator<?>, ComparatorContext> _cache = new CacheMap(new ComparatorContext(""));
    private static final Comparator<Object> _defaultComparator = new DefaultComparator();
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;

    public static void registerComparator(Class<?> clazz, Comparator comparator) {
        ObjectComparatorManager.registerComparator(clazz, comparator, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static void registerComparator(Class<?> clazz, Comparator comparator, ComparatorContext context) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        if (context == null) {
            context = ComparatorContext.DEFAULT_CONTEXT;
        }
        if (ObjectComparatorManager.isAutoInit() && !_inited && !_initing) {
            ObjectComparatorManager.initDefaultComparator();
        }
        _cache.register(clazz, comparator, context);
    }

    public static void unregisterComparator(Class<?> clazz) {
        ObjectComparatorManager.unregisterComparator(clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static void unregisterComparator(Class<?> clazz, ComparatorContext context) {
        if (context == null) {
            context = ComparatorContext.DEFAULT_CONTEXT;
        }
        if (ObjectComparatorManager.isAutoInit() && !_inited && !_initing) {
            ObjectComparatorManager.initDefaultComparator();
        }
        _cache.unregister(clazz, context);
    }

    public static void unregisterAllComparators(Class<?> clazz) {
        _cache.remove(clazz);
    }

    public static void unregisterAllComparators() {
        _cache.clear();
    }

    public static Comparator getComparator(Class<?> clazz) {
        return ObjectComparatorManager.getComparator(clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static Comparator getComparator(Class<?> clazz, ComparatorContext context) {
        Comparator<?> object;
        if (ObjectComparatorManager.isAutoInit() && !_inited && !_initing) {
            ObjectComparatorManager.initDefaultComparator();
        }
        if (context == null) {
            context = ComparatorContext.DEFAULT_CONTEXT;
        }
        if ((object = _cache.getRegisteredObject(clazz, context)) != null) {
            return object;
        }
        return _defaultComparator;
    }

    public static int compare(Object o1, Object o2) {
        return ObjectComparatorManager.compare(o1, o2, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static int compare(Object o1, Object o2, ComparatorContext context) {
        Class<?> clazz2;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Class<?> clazz1 = o1.getClass();
        Class<Object> clazz = clazz1 == (clazz2 = o2.getClass()) ? clazz1 : (clazz1.isAssignableFrom(clazz2) ? clazz1 : (clazz2.isAssignableFrom(clazz1) ? clazz2 : (clazz1.isAssignableFrom(Comparable.class) && clazz2.isAssignableFrom(Comparable.class) ? Comparable.class : Object.class)));
        return ObjectComparatorManager.compare(o1, o2, clazz, context);
    }

    public static int compare(Object o1, Object o2, Class<?> clazz) {
        return ObjectComparatorManager.compare(o1, o2, clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static int compare(Object o1, Object o2, Class<?> clazz, ComparatorContext context) {
        Comparator comparator = ObjectComparatorManager.getComparator(clazz, context);
        if (comparator != null) {
            try {
                return comparator.compare(o1, o2);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.toString().compareTo(o2.toString());
    }

    public static boolean isAutoInit() {
        return _autoInit;
    }

    public static void setAutoInit(boolean autoInit) {
        _autoInit = autoInit;
    }

    public static void addRegistrationListener(RegistrationListener l) {
        _cache.addRegistrationListener(l);
    }

    public static void removeRegistrationListener(RegistrationListener l) {
        _cache.removeRegistrationListener(l);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return _cache.getRegistrationListeners();
    }

    public static ComparatorContext[] getComparatorContexts(Class<?> clazz) {
        return _cache.getKeys(clazz, (ComparatorContext[])new ComparatorContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultComparator() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            ObjectComparatorManager.registerComparator(Object.class, new DefaultComparator());
            ObjectComparatorManager.registerComparator(Boolean.class, new BooleanComparator());
            ObjectComparatorManager.registerComparator(Calendar.class, new CalendarComparator());
            ObjectComparatorManager.registerComparator(Date.class, new DateComparator());
            NumberComparator numberComparator = new NumberComparator();
            ObjectComparatorManager.registerComparator(Number.class, numberComparator);
            ObjectComparatorManager.registerComparator(Double.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Float.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Long.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Integer.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Short.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Byte.TYPE, numberComparator);
            NumberComparator absoluteNumberComparator = new NumberComparator();
            absoluteNumberComparator.setAbsolute(true);
            ObjectComparatorManager.registerComparator(Number.class, absoluteNumberComparator, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Double.TYPE, absoluteNumberComparator, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Float.TYPE, absoluteNumberComparator, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Long.TYPE, absoluteNumberComparator, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Integer.TYPE, absoluteNumberComparator, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Short.TYPE, absoluteNumberComparator, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Byte.TYPE, absoluteNumberComparator, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Comparable.class, new FastComparableComparator());
            ObjectComparatorManager.registerComparator(String.class, Collator.getInstance());
            Collator caseInsensitiveCollator = Collator.getInstance();
            caseInsensitiveCollator.setStrength(0);
            ObjectComparatorManager.registerComparator(String.class, caseInsensitiveCollator, new ComparatorContext("Ignorecase"));
            Collator secondaryCollator = Collator.getInstance();
            secondaryCollator.setStrength(1);
            ObjectComparatorManager.registerComparator(String.class, secondaryCollator, new ComparatorContext("Secondary"));
            ObjectComparatorManager.registerComparator(CharSequence.class, new CharSequenceComparator(), CharSequenceComparator.CONTEXT);
            ObjectComparatorManager.registerComparator(CharSequence.class, new CharSequenceComparator(false), CharSequenceComparator.CONTEXT_IGNORE_CASE);
            ObjectComparatorManager.registerComparator(CharSequence.class, new AlphanumComparator(), AlphanumComparator.CONTEXT);
            ObjectComparatorManager.registerComparator(CharSequence.class, new AlphanumComparator(false), AlphanumComparator.CONTEXT_IGNORE_CASE);
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }

    public static void resetInit() {
        _inited = false;
    }

    public static void clear() {
        ObjectComparatorManager.resetInit();
        _cache.clear();
    }
}

