/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.res.GetIcon;
import mediathek.tool.EscBeenden;
import org.jdesktop.swingx.JXBusyLabel;

public class DialogBeendenZeit
extends JDialog {
    private static final String WAIT_FOR_DOWNLOADS_AND_TERMINATE = "Auf Abschlu\u00df aller Downloads warten und danach Programm beenden";
    private static final String WAIT_FOR_DOWNLOADS_AND_DONT_TERMINATE_PROGRAM = "Auf Abschlu\u00df aller Downloads warten, Programm danach NICHT beenden";
    private static final String DONT_START = "Downloads nicht starten";
    private final JFrame parent;
    private final Daten daten;
    private final ArrayList<DatenDownload> listeDownloadsStarten;
    private boolean applicationCanTerminate = false;
    private boolean shutdown = false;
    private JPanel glassPane = null;
    private final JXBusyLabel lblGlassPane = new JXBusyLabel();
    private SwingWorker<Void, Void> downloadMonitorWorker = null;
    private JButton btnCancel;
    private JButton btnContinue;
    private JCheckBox cbShutdownComputer;
    private JComboBox<String> comboActions;
    private JButton jButtonHilfe;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner jSpinnerTime;

    public boolean applicationCanTerminate() {
        return this.applicationCanTerminate;
    }

    public boolean isShutdownRequested() {
        return this.shutdown;
    }

    public DialogBeendenZeit(JFrame pparent, Daten daten_, ArrayList<DatenDownload> listeDownloadsStarten_) {
        super((Frame)pparent, true);
        this.initComponents();
        this.parent = pparent;
        this.daten = daten_;
        this.listeDownloadsStarten = listeDownloadsStarten_;
        this.setTitle("Zeitverz\u00f6gerter Download-Start");
        if (this.parent != null) {
            this.setLocationRelativeTo(this.parent);
        }
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogBeendenZeit.this.escapeHandler();
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogBeendenZeit.this.escapeHandler();
            }
        });
        Calendar cal = Calendar.getInstance();
        cal.add(12, 1);
        Date startDate = cal.getTime();
        cal.add(12, 60);
        Date now = cal.getTime();
        cal.add(5, 2);
        Date endDate = cal.getTime();
        SpinnerDateModel model = new SpinnerDateModel(now, startDate, endDate, 12);
        if (!Daten.mVConfig.get("Dialog-Download-Starten-Zeit").isEmpty()) {
            try {
                String heute = new SimpleDateFormat("yyyyMMdd").format(new Date());
                heute = heute + Daten.mVConfig.get("Dialog-Download-Starten-Zeit");
                Date start = new SimpleDateFormat("yyyyMMddHH:mm").parse(heute);
                if (start.after(startDate)) {
                    model = new SpinnerDateModel(start, startDate, endDate, 12);
                } else {
                    start = new Date(start.getTime() + 86400000L);
                    model = new SpinnerDateModel(start, startDate, endDate, 12);
                }
            }
            catch (Exception heute) {
                // empty catch block
            }
        }
        this.jSpinnerTime.setModel(model);
        JSpinner.DateEditor dEditor = new JSpinner.DateEditor(this.jSpinnerTime, "dd.MM.yyy  HH:mm");
        this.jSpinnerTime.setEditor(dEditor);
        this.comboActions.setModel(this.getComboBoxModel());
        this.comboActions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBeendenZeit.this.setCbShutdownCoputer();
            }
        });
        this.jButtonHilfe.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(DialogBeendenZeit.this.parent, true, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_BEENDEN)).setVisible(true);
            }
        });
        this.setCbShutdownCoputer();
        this.cbShutdownComputer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBeendenZeit.this.shutdown = DialogBeendenZeit.this.cbShutdownComputer.isSelected();
            }
        });
        this.cbShutdownComputer.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Dialog-Download-Shutdown")));
        this.btnContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strSelectedItem = DialogBeendenZeit.this.comboActions.getSelectedItem().toString();
                Daten.mVConfig.add("Dialog-Download-Shutdown", String.valueOf(DialogBeendenZeit.this.cbShutdownComputer.isSelected()));
                SimpleDateFormat format = ((JSpinner.DateEditor)DialogBeendenZeit.this.jSpinnerTime.getEditor()).getFormat();
                format.applyPattern("HH:mm");
                Date sp = (Date)DialogBeendenZeit.this.jSpinnerTime.getValue();
                String strDate = format.format(sp);
                Daten.mVConfig.add("Dialog-Download-Starten-Zeit", strDate);
                switch (strSelectedItem) {
                    case "Auf Abschlu\u00df aller Downloads warten und danach Programm beenden": {
                        DialogBeendenZeit.this.applicationCanTerminate = true;
                        DialogBeendenZeit.this.waitUntilDownloadsHaveFinished();
                        break;
                    }
                    case "Auf Abschlu\u00df aller Downloads warten, Programm danach NICHT beenden": {
                        DialogBeendenZeit.this.applicationCanTerminate = false;
                        DialogBeendenZeit.this.waitUntilDownloadsHaveFinished();
                        break;
                    }
                    case "Downloads nicht starten": {
                        DialogBeendenZeit.this.applicationCanTerminate = false;
                        DialogBeendenZeit.this.dispose();
                    }
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBeendenZeit.this.escapeHandler();
            }
        });
        this.pack();
        this.getRootPane().setDefaultButton(this.btnContinue);
    }

    private void setCbShutdownCoputer() {
        String strSelectedItem;
        switch (strSelectedItem = (String)this.comboActions.getSelectedItem()) {
            case "Auf Abschlu\u00df aller Downloads warten und danach Programm beenden": {
                this.cbShutdownComputer.setEnabled(true);
                break;
            }
            default: {
                this.cbShutdownComputer.setEnabled(false);
                this.cbShutdownComputer.setSelected(false);
                this.shutdown = false;
            }
        }
    }

    private DefaultComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{WAIT_FOR_DOWNLOADS_AND_TERMINATE, WAIT_FOR_DOWNLOADS_AND_DONT_TERMINATE_PROGRAM, DONT_START});
    }

    private void escapeHandler() {
        if (this.downloadMonitorWorker != null) {
            this.downloadMonitorWorker.cancel(true);
        }
        if (this.glassPane != null) {
            this.glassPane.setVisible(false);
        }
        this.applicationCanTerminate = false;
        this.dispose();
    }

    private JPanel createGlassPane() {
        String strMessage = "<html>Warte auf Abschluss der Downloads...";
        if (this.isShutdownRequested()) {
            strMessage = strMessage + "<br><b>Der Rechner wird danach heruntergefahren.</b>";
        }
        strMessage = strMessage + "<br>Sie k\u00f6nnen den Vorgang mit Escape abbrechen.</html>";
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        this.lblGlassPane.setText(strMessage);
        this.lblGlassPane.setBusy(true);
        this.lblGlassPane.setVerticalAlignment(0);
        this.lblGlassPane.setHorizontalAlignment(0);
        panel.add((Component)this.lblGlassPane, "Center");
        return panel;
    }

    private void setTextWait() {
        SimpleDateFormat format = ((JSpinner.DateEditor)this.jSpinnerTime.getEditor()).getFormat();
        format.applyPattern("dd.MM.yyy  HH:mm");
        Date sp = (Date)this.jSpinnerTime.getValue();
        String strDate = format.format(sp);
        String strMessage = "<html>Downloads starten:<br><br><b>" + strDate + "</b><br>";
        if (this.isShutdownRequested()) {
            strMessage = strMessage + "<br><b>Der Rechner wird danach heruntergefahren.</b>";
        }
        strMessage = strMessage + "<br>Sie k\u00f6nnen den Vorgang mit Escape abbrechen.</html>";
        this.lblGlassPane.setText(strMessage);
    }

    private void setTextDownload_() {
        String strMessage = "<html>Warte auf Abschluss der Downloads...";
        if (this.isShutdownRequested()) {
            strMessage = strMessage + "<br><b>Der Rechner wird danach heruntergefahren.</b>";
        }
        strMessage = strMessage + "<br>Sie k\u00f6nnen den Vorgang mit Escape abbrechen.</html>";
        this.lblGlassPane.setText(strMessage);
    }

    private void setTextDownload() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setTextDownload_();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogBeendenZeit.this.setTextDownload_();
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void waitUntilDownloadsHaveFinished() {
        this.glassPane = this.createGlassPane();
        this.setGlassPane(this.glassPane);
        this.setTextWait();
        this.glassPane.setVisible(true);
        this.downloadMonitorWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                while (((Date)DialogBeendenZeit.this.jSpinnerTime.getValue()).after(new Date())) {
                    Thread.sleep(1000L);
                }
                DialogBeendenZeit.this.setTextDownload();
                DatenDownload.startenDownloads(DialogBeendenZeit.this.daten, DialogBeendenZeit.this.listeDownloadsStarten);
                while (Daten.listeDownloads.nochNichtFertigeDownloads() > 0 && !this.isCancelled()) {
                    Thread.sleep(1000L);
                }
                return null;
            }

            @Override
            protected void done() {
                DialogBeendenZeit.this.glassPane.setVisible(false);
                DialogBeendenZeit.this.dispose();
                DialogBeendenZeit.this.downloadMonitorWorker = null;
            }
        };
        this.downloadMonitorWorker.execute();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.comboActions = new JComboBox();
        this.btnContinue = new JButton();
        this.cbShutdownComputer = new JCheckBox();
        this.btnCancel = new JButton();
        this.jButtonHilfe = new JButton();
        this.jLabel2 = new JLabel();
        this.jSpinnerTime = new JSpinner();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        jLabel1.setText("<html>Wie m\u00f6chten Sie fortfahren<br>\nwenn alle Downloads fertig sind?</html>");
        this.btnContinue.setText("Weiter");
        this.cbShutdownComputer.setText("Rechner herunterfahren");
        this.btnCancel.setText("Zur\u00fcck");
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jLabel2.setText("alle Downloads starten um: ");
        this.jLabel3.setText("Uhr");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel1, -1, 551, Short.MAX_VALUE).addComponent(this.comboActions, 0, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonHilfe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnContinue)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShutdownComputer).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerTime, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSpinnerTime, -2, -1, -2).addComponent(this.jLabel3)).addGap(18, 18, Short.MAX_VALUE).addComponent(jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboActions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.cbShutdownComputer).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnContinue).addComponent(this.btnCancel))).addComponent(this.jButtonHilfe)).addContainerGap()));
        this.pack();
    }
}

