/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.MenuItemEnabledListener;
import freemind.controller.MenuItemSelectedListener;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.HookContentNodeAction;
import freemind.controller.actions.generated.instance.HookNodeAction;
import freemind.controller.actions.generated.instance.NodeListMember;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookFactory;
import freemind.extensions.HookInstanciationMethod;
import freemind.extensions.NodeHook;
import freemind.extensions.PermanentNodeHook;
import freemind.extensions.StatefulNodeHook;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.HookAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import freemind.view.mindmapview.NodeView;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class NodeHookAction
extends FreemindAction
implements HookAction,
ActorXml,
MenuItemEnabledListener,
MenuItemSelectedListener {
    String _hookName;
    MindMapController mMindMapController;
    private static Logger logger;

    public MindMapController getController() {
        return this.mMindMapController;
    }

    public NodeHookAction(String hookName, MindMapController controller) {
        super(hookName, (Icon)null, null);
        this._hookName = hookName;
        this.mMindMapController = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent arg0) {
        this.mMindMapController.getFrame().setWaitingCursor(true);
        this.invoke(this.mMindMapController.getSelected(), this.mMindMapController.getSelecteds());
        this.mMindMapController.getFrame().setWaitingCursor(false);
    }

    public void addHook(MindMapNode focussed, List selecteds, String hookName) {
        HookNodeAction doAction = this.createHookNodeAction(focussed, selecteds, hookName);
        CompoundAction undoAction = null;
        undoAction = new CompoundAction();
        if (this.getInstanciationMethod(hookName).isPermanent()) {
            undoAction = this.createHookNodeUndoAction(focussed, selecteds, hookName);
        }
        if (this.getInstanciationMethod(hookName).isUndoable()) {
            this.getController().getActionFactory().startTransaction((String)this.getValue("Name"));
            this.getController().getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
            this.getController().getActionFactory().endTransaction((String)this.getValue("Name"));
        } else {
            this.invoke(focussed, selecteds, hookName);
        }
    }

    private XmlAction createHookNodeUndoAction(MindMapNode focussed, List selecteds, String hookName) {
        CompoundAction undoAction = new CompoundAction();
        undoAction.addChoice((Object)this.createHookNodeAction(focussed, selecteds, hookName));
        HookInstanciationMethod instMethod = this.getInstanciationMethod(hookName);
        Collection destinationNodes = instMethod.getDestinationNodes(this.mMindMapController, focussed, selecteds);
        MindMapNode adaptedFocussedNode = instMethod.getCenterNode(this.mMindMapController, focussed, selecteds);
        if (instMethod.isAlreadyPresent(this.mMindMapController, hookName, adaptedFocussedNode)) {
            Iterator i = destinationNodes.iterator();
            while (i.hasNext()) {
                PermanentNodeHook hook;
                MindMapNode currentDestinationNode = (MindMapNode)i.next();
                Iterator j = currentDestinationNode.getActivatedHooks().iterator();
                if (!j.hasNext() || !(hook = (PermanentNodeHook)j.next()).getName().equals(hookName) || !(hook instanceof StatefulNodeHook)) continue;
                StatefulNodeHook stateHook = (StatefulNodeHook)hook;
                HookContentNodeAction choice = this.getController().undoableHookContentActor.createHookContentNodeAction(focussed, hookName, null, stateHook.getContent());
                undoAction.addChoice((Object)choice);
            }
        }
        return undoAction;
    }

    public void invoke(MindMapNode focussed, List selecteds) {
        this.addHook(focussed, selecteds, this._hookName);
    }

    private void invoke(MindMapNode focussed, List selecteds, String hookName) {
        logger.finest("invoke(selecteds) called.");
        HookInstanciationMethod instMethod = this.getInstanciationMethod(hookName);
        Collection destinationNodes = instMethod.getDestinationNodes(this.mMindMapController, focussed, selecteds);
        MindMapNode adaptedFocussedNode = instMethod.getCenterNode(this.mMindMapController, focussed, selecteds);
        if (instMethod.isAlreadyPresent(this.mMindMapController, hookName, adaptedFocussedNode)) {
            Iterator i = destinationNodes.iterator();
            block0: while (i.hasNext()) {
                MindMapNode currentDestinationNode = (MindMapNode)i.next();
                Iterator j = currentDestinationNode.getActivatedHooks().iterator();
                while (j.hasNext()) {
                    PermanentNodeHook hook = (PermanentNodeHook)j.next();
                    if (!hook.getName().equals(hookName)) continue;
                    currentDestinationNode.removeHook(hook);
                    this.mMindMapController.nodeChanged(currentDestinationNode);
                    continue block0;
                }
            }
        } else {
            Iterator it = destinationNodes.iterator();
            while (it.hasNext()) {
                MindMapNode currentDestinationNode = (MindMapNode)it.next();
                NodeHook hook = this.mMindMapController.createNodeHook(hookName, currentDestinationNode, this.mMindMapController.getMap());
                logger.finest("created hook " + hookName);
                currentDestinationNode.invokeHook(hook);
                if (!(hook instanceof PermanentNodeHook)) continue;
                PermanentNodeHook permHook = (PermanentNodeHook)hook;
                logger.finest("This is a permanent hook " + hookName);
                if (currentDestinationNode == adaptedFocussedNode) {
                    permHook.onSelectHook(this.mMindMapController.getNodeView(currentDestinationNode));
                }
                this.mMindMapController.nodeChanged(currentDestinationNode);
            }
            this.finishInvocation(focussed, selecteds, adaptedFocussedNode, destinationNodes);
        }
    }

    private void finishInvocation(MindMapNode focussed, List selecteds, MindMapNode adaptedFocussedNode, Collection destinationNodes) {
        NodeView focussedNodeView = this.mMindMapController.getNodeView(focussed);
        if (focussedNodeView != null) {
            this.getController().getView().selectAsTheOnlyOneSelected(focussedNodeView);
            this.getController().getView().scrollNodeToVisible(focussedNodeView);
            Iterator i = selecteds.iterator();
            while (i.hasNext()) {
                MindMapNode node = (MindMapNode)i.next();
                NodeView nodeView = this.mMindMapController.getNodeView(node);
                if (nodeView == null) continue;
                this.getController().getView().makeTheSelected(nodeView);
            }
        }
    }

    private HookInstanciationMethod getInstanciationMethod(String hookName) {
        HookFactory factory = this.getHookFactory();
        HookInstanciationMethod instMethod = factory.getInstanciationMethod(hookName);
        return instMethod;
    }

    private HookFactory getHookFactory() {
        HookFactory factory = this.mMindMapController.getHookFactory();
        return factory;
    }

    public boolean isEnabled(JMenuItem item, Action action) {
        if (this.mMindMapController.getView() == null) {
            return false;
        }
        HookFactory factory = this.getHookFactory();
        Object baseClass = factory.getPluginBaseClass(this._hookName);
        if (baseClass != null && baseClass instanceof MenuItemEnabledListener) {
            MenuItemEnabledListener listener = (MenuItemEnabledListener)baseClass;
            return listener.isEnabled(item, action);
        }
        return true;
    }

    public HookNodeAction createHookNodeAction(MindMapNode focussed, List selecteds, String hookName) {
        HookNodeAction hookNodeAction = new HookNodeAction();
        hookNodeAction.setNode(focussed.getObjectId(this.getController()));
        hookNodeAction.setHookName(hookName);
        Iterator i = selecteds.iterator();
        while (i.hasNext()) {
            MindMapNode node = (MindMapNode)i.next();
            NodeListMember nodeListMember = new NodeListMember();
            nodeListMember.setNode(node.getObjectId(this.getController()));
            hookNodeAction.addNodeListMember(nodeListMember);
        }
        return hookNodeAction;
    }

    public void act(XmlAction action) {
        if (action instanceof HookNodeAction) {
            HookNodeAction hookNodeAction = (HookNodeAction)action;
            NodeAdapter selected = this.getController().getNodeFromID(hookNodeAction.getNode());
            Vector<NodeAdapter> selecteds = new Vector<NodeAdapter>();
            Iterator i = hookNodeAction.getListNodeListMemberList().iterator();
            while (i.hasNext()) {
                NodeListMember node = (NodeListMember)i.next();
                selecteds.add(this.getController().getNodeFromID(node.getNode()));
            }
            this.invoke(selected, selecteds, hookNodeAction.getHookName());
        }
    }

    public Class getDoActionClass() {
        return HookNodeAction.class;
    }

    public String getHookName() {
        return this._hookName;
    }

    public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
        HookFactory factory = this.getHookFactory();
        Object baseClass = factory.getPluginBaseClass(this._hookName);
        if (baseClass != null && baseClass instanceof MenuItemSelectedListener) {
            MenuItemSelectedListener listener = (MenuItemSelectedListener)baseClass;
            return listener.isSelected(pCheckItem, pAction);
        }
        MindMapNode focussed = this.mMindMapController.getSelected();
        List selecteds = this.mMindMapController.getSelecteds();
        HookInstanciationMethod instMethod = this.getInstanciationMethod(this._hookName);
        Collection destinationNodes = instMethod.getDestinationNodes(this.mMindMapController, focussed, selecteds);
        MindMapNode adaptedFocussedNode = instMethod.getCenterNode(this.mMindMapController, focussed, selecteds);
        return instMethod.isAlreadyPresent(this.mMindMapController, this._hookName, adaptedFocussedNode);
    }
}

