/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.listeners;

import freemind.controller.MapMouseMotionListener;
import freemind.modes.ModeController;
import freemind.view.mindmapview.MapView;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class CommonMouseMotionManager
implements MapMouseMotionListener.MapMouseMotionReceiver {
    int originX = -1;
    int originY = -1;
    private final ModeController mController;

    public CommonMouseMotionManager(ModeController controller) {
        this.mController = controller;
    }

    public void mouseDragged(MouseEvent e) {
        Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
        MapView mapView = (MapView)e.getComponent();
        boolean isEventPointVisible = mapView.getVisibleRect().contains(r);
        if (!isEventPointVisible) {
            mapView.scrollRectToVisible(r);
        }
        if (this.originX >= 0 && isEventPointVisible) {
            ((MapView)e.getComponent()).scrollBy(this.originX - e.getX(), this.originY - e.getY());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!this.mController.isBlocked() && e.getButton() == 1) {
            this.mController.getView().setMoveCursor(true);
            this.originX = e.getX();
            this.originY = e.getY();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.originX = -1;
        this.originY = -1;
    }
}

