/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.ExportHook;
import freemind.extensions.ModeControllerHookAdapter;
import freemind.main.Resources;
import freemind.main.XMLParseException;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ImportMindmanagerFiles
extends ModeControllerHookAdapter {
    public void startupMapHook() {
        int returnVal;
        super.startupMapHook();
        String type = "mmap";
        Container component = this.getController().getFrame().getContentPane();
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new ExportHook.ImageFilter(type, null));
        File mmFile = this.getController().getMap().getFile();
        if (mmFile != null && mmFile.getParentFile() != null) {
            chooser.setSelectedFile(mmFile.getParentFile());
        }
        if ((returnVal = chooser.showOpenDialog(component)) != 0) {
            return;
        }
        File chosenFile = chooser.getSelectedFile();
        this.importMindmanagerFile(chosenFile);
    }

    private void importMindmanagerFile(File file) {
        try {
            ZipInputStream in = new ZipInputStream(new FileInputStream(file));
            while (in.available() != 0) {
                ZipEntry entry = in.getNextEntry();
                if (!entry.getName().equals("Document.xml")) continue;
                String xsltFileName = "accessories/mindmanager2mm.xsl";
                URL xsltUrl = this.getResource(xsltFileName);
                if (xsltUrl == null) {
                    this.logger.severe("Can't find " + xsltFileName + " as resource.");
                    throw new IllegalArgumentException("Can't find " + xsltFileName + " as resource.");
                }
                InputStream xsltFile = xsltUrl.openStream();
                String xml = this.transForm(new StreamSource(in), xsltFile);
                if (xml != null) {
                    File tempFile = File.createTempFile(file.getName(), ".mm", file.getParentFile());
                    FileWriter fw = new FileWriter(tempFile);
                    fw.write(xml);
                    fw.close();
                    this.getController().load(tempFile);
                }
                break;
            }
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
        catch (XMLParseException e) {
            Resources.getInstance().logException(e);
        }
    }

    public String transForm(Source xmlSource, InputStream xsltStream) {
        StreamSource xsltSource = new StreamSource(xsltStream);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return null;
        }
        return writer.toString();
    }
}

