/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.ICharacterEscaper;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.GenericXMLWriter;
import org.jibx.runtime.impl.ISO88591Escaper;
import org.jibx.runtime.impl.ISO88591StreamWriter;
import org.jibx.runtime.impl.USASCIIEscaper;
import org.jibx.runtime.impl.UTF8Escaper;
import org.jibx.runtime.impl.UTF8StreamWriter;
import org.jibx.runtime.impl.XMLWriterBase;

public class MarshallingContext
implements IMarshallingContext {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final int INITIAL_STACK_SIZE = 20;
    private IBindingFactory m_factory;
    private String[] m_classes;
    private int m_globalCount;
    private String[] m_marshallerClasses;
    private IMarshaller[] m_marshallers;
    private String[] m_uris;
    private int m_stackDepth;
    private Object[] m_objectStack;
    private int m_indentCount;
    private String m_newLine;
    private char m_indentChar;
    private HashMap m_idMap;
    private IXMLWriter m_writer;
    static /* synthetic */ Class class$org$jibx$runtime$impl$UnmarshallingContext;

    public MarshallingContext(String[] stringArray, String[] stringArray2, String[] stringArray3, IBindingFactory iBindingFactory) {
        this.m_classes = stringArray;
        this.m_globalCount = stringArray2.length;
        this.m_marshallers = new IMarshaller[stringArray.length];
        this.m_marshallerClasses = new String[stringArray.length];
        System.arraycopy(stringArray2, 0, this.m_marshallerClasses, 0, stringArray2.length);
        this.m_uris = stringArray3;
        this.m_objectStack = new Object[20];
        this.m_indentCount = -1;
        this.m_indentChar = (char)32;
        this.m_newLine = "\n";
        this.m_factory = iBindingFactory;
    }

    private ICharacterEscaper createEscaper(String string) throws JiBXException {
        if (string.equalsIgnoreCase("UTF-8") || string.equalsIgnoreCase("UTF-16") || string.equalsIgnoreCase("UTF-16BE") || string.equalsIgnoreCase("UTF-16LE")) {
            return UTF8Escaper.getInstance();
        }
        if (string.equalsIgnoreCase("ISO-8859-1")) {
            return ISO88591Escaper.getInstance();
        }
        if (string.equalsIgnoreCase("US-ASCII")) {
            return USASCIIEscaper.getInstance();
        }
        throw new JiBXException("No character escaper defined for encoding " + string);
    }

    public void setOutput(OutputStream outputStream, String string, ICharacterEscaper iCharacterEscaper) throws JiBXException {
        try {
            if (string == null) {
                string = "UTF-8";
            }
            if (!(this.m_writer instanceof GenericXMLWriter)) {
                this.m_writer = new GenericXMLWriter(this.m_uris);
                this.m_writer.setIndentSpaces(this.m_indentCount, this.m_newLine, this.m_indentChar);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string));
            ((GenericXMLWriter)this.m_writer).setOutput(bufferedWriter, iCharacterEscaper);
            this.reset();
        }
        catch (IOException iOException) {
            throw new JiBXException("Error setting output", iOException);
        }
    }

    public void setOutput(OutputStream outputStream, String string) throws JiBXException {
        if (string == null) {
            string = "UTF-8";
        }
        if ("UTF-8".equalsIgnoreCase(string)) {
            if (!(this.m_writer instanceof UTF8StreamWriter)) {
                this.m_writer = new UTF8StreamWriter(this.m_uris);
                this.m_writer.setIndentSpaces(this.m_indentCount, this.m_newLine, this.m_indentChar);
            }
            ((UTF8StreamWriter)this.m_writer).setOutput(outputStream);
            this.reset();
        } else if ("ISO-8859-1".equalsIgnoreCase(string)) {
            if (!(this.m_writer instanceof ISO88591StreamWriter)) {
                this.m_writer = new ISO88591StreamWriter(this.m_uris);
                this.m_writer.setIndentSpaces(this.m_indentCount, this.m_newLine, this.m_indentChar);
            }
            ((ISO88591StreamWriter)this.m_writer).setOutput(outputStream);
            this.reset();
        } else {
            this.setOutput(outputStream, string, this.createEscaper(string));
        }
    }

    public void setOutput(Writer writer, ICharacterEscaper iCharacterEscaper) {
        if (!(this.m_writer instanceof GenericXMLWriter)) {
            this.m_writer = new GenericXMLWriter(this.m_uris);
            this.m_writer.setIndentSpaces(this.m_indentCount, this.m_newLine, this.m_indentChar);
        }
        ((GenericXMLWriter)this.m_writer).setOutput(writer, iCharacterEscaper);
        this.reset();
    }

    public void setOutput(Writer writer) {
        this.setOutput(writer, UTF8Escaper.getInstance());
    }

    public IXMLWriter getXmlWriter() {
        return this.m_writer;
    }

    public void setXmlWriter(IXMLWriter iXMLWriter) {
        this.m_writer = iXMLWriter;
    }

    public int getIndent() {
        return this.m_indentCount;
    }

    public void setIndent(int n) {
        if (this.m_writer != null) {
            this.m_writer.setIndentSpaces(n, this.m_newLine, this.m_indentChar);
        }
        this.m_indentCount = n;
    }

    public void setIndent(int n, String string, char c) {
        if (this.m_writer != null) {
            this.m_writer.setIndentSpaces(n, string, c);
        }
        this.m_indentCount = n;
        this.m_newLine = string;
        this.m_indentChar = c;
    }

    public void setFromContext(MarshallingContext marshallingContext) {
        this.reset();
        this.m_writer = marshallingContext.m_writer instanceof XMLWriterBase ? ((XMLWriterBase)marshallingContext.m_writer).createChildWriter(this.m_uris) : marshallingContext.m_writer;
    }

    public void reset() {
        int n;
        if (this.m_writer != null) {
            this.m_writer.reset();
        }
        for (n = this.m_globalCount; n < this.m_marshallers.length; ++n) {
            this.m_marshallers[n] = null;
        }
        for (n = 0; n < this.m_objectStack.length; ++n) {
            this.m_objectStack[n] = null;
        }
        this.m_stackDepth = 0;
    }

    public IBindingFactory getFactory() {
        return this.m_factory;
    }

    public String[] getNamespaces() {
        return this.m_uris;
    }

    public void startDocument(String string, Boolean bl) throws JiBXException {
        try {
            String string2 = null;
            if (bl != null) {
                string2 = bl != false ? "yes" : "no";
            }
            this.m_writer.writeXMLDecl("1.0", string, string2);
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public void startDocument(String string, Boolean bl, OutputStream outputStream) throws JiBXException {
        this.setOutput(outputStream, string);
        this.startDocument(string, bl);
    }

    public void startDocument(String string, Boolean bl, Writer writer) throws JiBXException {
        this.setOutput(writer);
        this.startDocument(string, bl);
    }

    public void endDocument() throws JiBXException {
        try {
            this.m_writer.close();
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public String buildNameString(int n, String string) {
        String string2 = this.m_writer.getNamespaceUri(n);
        if (string2 == null || "".equals(string2)) {
            return "\"" + string + "\"";
        }
        return "\"{" + string2 + "}" + string + "\"";
    }

    public MarshallingContext startTag(int n, String string) throws JiBXException {
        try {
            this.m_writer.startTagClosed(n, string);
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext startTagAttributes(int n, String string) throws JiBXException {
        try {
            this.m_writer.startTagOpen(n, string);
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext attribute(int n, String string, String string2) throws JiBXException {
        try {
            this.m_writer.addAttribute(n, string, string2);
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
        catch (Exception exception) {
            String string3 = this.buildNameString(n, string);
            if (string2 == null) {
                throw new JiBXException("null value for attribute " + string3 + " from object of type " + this.getStackTop().getClass().getName());
            }
            throw new JiBXException("Exception while marshalling attribute " + string3, exception);
        }
    }

    public MarshallingContext attribute(int n, String string, int n2) throws JiBXException {
        return this.attribute(n, string, Integer.toString(n2));
    }

    public MarshallingContext attribute(int n, String string, int n2, String[] stringArray) throws JiBXException {
        try {
            return this.attribute(n, string, stringArray[n2]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JiBXException("Enumeration value of " + n2 + " is outside to allowed range of 0 to " + stringArray.length);
        }
    }

    public MarshallingContext closeStartContent() throws JiBXException {
        try {
            this.m_writer.closeStartTag();
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext closeStartEmpty() throws JiBXException {
        try {
            this.m_writer.closeEmptyTag();
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext content(String string) throws JiBXException {
        try {
            this.m_writer.writeTextContent(string);
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext content(int n) throws JiBXException {
        this.content(Integer.toString(n));
        return this;
    }

    public MarshallingContext content(int n, String[] stringArray) throws JiBXException {
        try {
            this.content(stringArray[n]);
            return this;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JiBXException("Enumeration value of " + n + " is outside to allowed range of 0 to " + stringArray.length);
        }
    }

    public MarshallingContext endTag(int n, String string) throws JiBXException {
        try {
            this.m_writer.endTag(n, string);
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext element(int n, String string, String string2) throws JiBXException {
        try {
            if (string2.length() == 0) {
                this.m_writer.startTagOpen(n, string);
                this.m_writer.closeEmptyTag();
            } else {
                this.m_writer.startTagClosed(n, string);
                this.m_writer.writeTextContent(string2);
                this.m_writer.endTag(n, string);
            }
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
        catch (Exception exception) {
            String string3 = this.buildNameString(n, string);
            if (string2 == null) {
                throw new JiBXException("null value for element " + string3 + " from object of type " + this.getStackTop().getClass().getName());
            }
            throw new JiBXException("Exception while marshalling element " + string3, exception);
        }
    }

    public MarshallingContext element(int n, String string, int n2) throws JiBXException {
        return this.element(n, string, Integer.toString(n2));
    }

    public MarshallingContext element(int n, String string, int n2, String[] stringArray) throws JiBXException {
        try {
            return this.element(n, string, stringArray[n2]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JiBXException("Enumeration value of " + n2 + " is outside to allowed range of 0 to " + stringArray.length);
        }
    }

    public MarshallingContext writeCData(String string) throws IOException {
        try {
            this.m_writer.writeCData(string);
            return this;
        }
        catch (NullPointerException nullPointerException) {
            if (string == null) {
                throw new IOException("Null value writing CDATA from object of type " + this.getStackTop().getClass().getName());
            }
            throw nullPointerException;
        }
    }

    public MarshallingContext writeContent(String string) throws IOException {
        try {
            this.m_writer.writeTextContent(string);
            return this;
        }
        catch (NullPointerException nullPointerException) {
            if (string == null) {
                throw new IOException("Null value writing text content from object " + this.getStackTop().getClass().getName());
            }
            throw nullPointerException;
        }
    }

    public MarshallingContext marshalCollection(Collection collection) throws JiBXException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IMarshallable) {
                ((IMarshallable)e).marshal(this);
                continue;
            }
            throw new JiBXException("Unmarshallable object of class " + e.getClass() + " found in marshalling");
        }
        return this;
    }

    public MarshallingContext marshalCollection(ArrayList arrayList) throws JiBXException {
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof IMarshallable)) {
                throw new JiBXException("Unmarshallable object of class " + e.getClass().getName() + " found in marshalling");
            }
            ((IMarshallable)e).marshal(this);
        }
        return this;
    }

    public MarshallingContext marshalCollection(Vector vector) throws JiBXException {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof IMarshallable)) {
                throw new JiBXException("Unmarshallable object of class " + e.getClass().getName() + " found in marshalling");
            }
            ((IMarshallable)e).marshal(this);
        }
        return this;
    }

    public void addMarshalling(int n, String string) {
        this.m_marshallerClasses[n] = string;
    }

    public void removeMarshalling(int n) {
        this.m_marshallers[n] = null;
    }

    public MarshallingContext startTagNamespaces(int n, String string, int[] nArray, String[] stringArray) throws JiBXException {
        try {
            this.m_writer.startTagNamespaces(n, string, nArray, stringArray);
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public IMarshaller getMarshaller(int n, String string) throws JiBXException {
        if (n >= this.m_classes.length || !string.equals(this.m_classes[n])) {
            throw new JiBXException("Marshalling not defined for class " + string);
        }
        if (this.m_marshallers[n] == null) {
            String string2 = this.m_marshallerClasses[n];
            if (string2 == null) {
                throw new JiBXException("No marshaller defined for class " + string);
            }
            try {
                IMarshaller iMarshaller;
                Class<?> clazz = null;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    try {
                        clazz = classLoader.loadClass(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz == null) {
                    clazz = (class$org$jibx$runtime$impl$UnmarshallingContext == null ? (class$org$jibx$runtime$impl$UnmarshallingContext = MarshallingContext.class$("org.jibx.runtime.impl.UnmarshallingContext")) : class$org$jibx$runtime$impl$UnmarshallingContext).getClassLoader().loadClass(string2);
                }
                this.m_marshallers[n] = iMarshaller = (IMarshaller)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JiBXException("Unable to create unmarshaller of class " + string2 + ":", exception);
            }
        }
        return this.m_marshallers[n];
    }

    protected void marshalRoot(Object object) throws JiBXException {
        IMarshallable iMarshallable;
        if (object instanceof IMarshallable) {
            boolean bl = false;
            iMarshallable = (IMarshallable)object;
            int n = iMarshallable.JiBX_getIndex();
            if (n < this.m_classes.length) {
                String string = this.m_classes[n];
                Class<?> clazz = iMarshallable.getClass();
                while (!clazz.getName().equals("java.lang.Object")) {
                    if (clazz.getName().equals(string)) {
                        bl = true;
                        break;
                    }
                    clazz = clazz.getSuperclass();
                }
            }
            if (!bl) {
                throw new JiBXException("Supplied root object of class " + object.getClass().getName() + " is incompatible with the binding used for this context");
            }
        } else {
            throw new JiBXException("Supplied root object of class " + object.getClass().getName() + " cannot be marshalled without top-level mapping");
        }
        iMarshallable.marshal(this);
    }

    public void marshalDocument(Object object) throws JiBXException {
        this.marshalRoot(object);
        this.endDocument();
    }

    public void marshalDocument(Object object, String string, Boolean bl) throws JiBXException {
        this.startDocument(string, bl);
        this.marshalRoot(object);
        this.endDocument();
    }

    public void marshalDocument(Object object, String string, Boolean bl, OutputStream outputStream) throws JiBXException {
        this.startDocument(string, bl, outputStream);
        this.marshalRoot(object);
        this.endDocument();
    }

    public void marshalDocument(Object object, String string, Boolean bl, Writer writer) throws JiBXException {
        this.startDocument(string, bl, writer);
        this.marshalRoot(object);
        this.endDocument();
    }

    public HashMap getIdMap() {
        if (this.m_idMap == null) {
            this.m_idMap = new HashMap();
        }
        return this.m_idMap;
    }

    public void pushObject(Object object) {
        int n = this.m_stackDepth;
        if (n >= this.m_objectStack.length) {
            Object[] objectArray = new Object[n * 2];
            System.arraycopy(this.m_objectStack, 0, objectArray, 0, n);
            this.m_objectStack = objectArray;
        }
        this.m_objectStack[n] = object;
        ++this.m_stackDepth;
    }

    public void popObject() throws JiBXException {
        if (this.m_stackDepth > 0) {
            --this.m_stackDepth;
        } else {
            throw new JiBXException("No object on stack");
        }
    }

    public int getStackDepth() {
        return this.m_stackDepth;
    }

    public Object getStackObject(int n) {
        return this.m_objectStack[this.m_stackDepth - n - 1];
    }

    public Object getStackTop() {
        if (this.m_stackDepth > 0) {
            return this.m_objectStack[this.m_stackDepth - 1];
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

