/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class InputStreamWrapper {
    private static final int BUFFER_SIZE = 2048;
    private String m_encodingName;
    private InputStream m_stream;
    private boolean m_isEnd;
    private byte[] m_buffer = new byte[2048];
    private int m_endOffset;
    private int m_emptyOffset;
    private int m_scanOffset;

    public void setInput(InputStream inputStream) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_stream = inputStream;
        this.reset();
    }

    public void setInput(InputStream inputStream, String string) throws IOException {
        this.setInput(inputStream);
        this.setEncoding(string);
    }

    public void setEncoding(String string) throws IOException {
        if (this.m_encodingName != null) {
            throw new IOException("Encoding has already been set for stream");
        }
        this.m_encodingName = string;
    }

    private boolean fillBuffer() throws IOException {
        if (this.m_isEnd) {
            return false;
        }
        int n = this.m_endOffset - this.m_emptyOffset;
        if (n > 0) {
            System.arraycopy(this.m_buffer, this.m_emptyOffset, this.m_buffer, 0, n);
        }
        this.m_emptyOffset = 0;
        int n2 = this.m_buffer.length - n;
        int n3 = this.m_stream.read(this.m_buffer, n, n2);
        if (n3 >= 0) {
            this.m_endOffset = n + n3;
            return true;
        }
        this.m_endOffset = n;
        this.m_isEnd = true;
        return false;
    }

    private boolean require(int n) throws IOException {
        while (this.m_endOffset - this.m_emptyOffset < n) {
            if (this.fillBuffer()) continue;
            return false;
        }
        return true;
    }

    private boolean isWhite(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13;
    }

    private String scanToken() throws IOException {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.require(this.m_scanOffset + 1)) {
            char c = (char)this.m_buffer[this.m_scanOffset++];
            if (bl) {
                if (this.isWhite(c)) continue;
                bl = false;
                stringBuffer.append(c);
                if (c != '=') continue;
                return stringBuffer.toString();
            }
            if (this.isWhite(c) || c == '=') {
                --this.m_scanOffset;
                return stringBuffer.toString();
            }
            stringBuffer.append(c);
            if (c != '>') continue;
            return stringBuffer.toString();
        }
        return null;
    }

    private String scanQuoted() throws IOException {
        boolean bl = true;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (this.require(this.m_scanOffset + 1)) {
            char c2 = (char)this.m_buffer[this.m_scanOffset++];
            if (bl) {
                if (this.isWhite(c2)) continue;
                if (c2 != '\"' && c2 != '\'') break;
                bl = false;
                c = c2;
                continue;
            }
            if (c2 == c) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c2);
        }
        return null;
    }

    public Reader getReader() throws IOException {
        if (this.m_encodingName == null) {
            this.m_encodingName = "UTF-8";
            if (this.require(4)) {
                int n = (((this.m_buffer[0] << 8) + (this.m_buffer[1] & 0xFF) << 8) + (this.m_buffer[2] & 0xFF) << 8) + (this.m_buffer[3] & 0xFF);
                if (n == 1010792557) {
                    this.m_scanOffset = 2;
                    String string = this.scanToken();
                    if ("xml".equals(string)) {
                        while ((string = this.scanToken()) != null && !"?>".equals(string)) {
                            if ("encoding".equals(string)) {
                                if (!"=".equals(this.scanToken()) || (string = this.scanQuoted()) == null) continue;
                                this.m_encodingName = string;
                                break;
                            }
                            if (!"=".equals(string)) continue;
                            this.scanQuoted();
                        }
                    }
                } else if (n == 65279 || n == -131072 || n == 65534 || n == -16842752) {
                    this.m_encodingName = "UCS-4";
                } else if ((n & 0xFFFFFF00) == -272908544) {
                    this.m_encodingName = "UTF-8";
                } else {
                    int n2 = n & 0xFFFF0000;
                    if (n2 == -16842752 || n == 3932223) {
                        this.m_encodingName = "UTF-16BE";
                    } else if (n2 == -131072 || n == 1006649088) {
                        this.m_encodingName = "UTF-16LE";
                    } else if (n == 1282385812) {
                        this.m_encodingName = "EBCDIC";
                    }
                }
            }
        }
        if (this.m_encodingName.equalsIgnoreCase("UTF-8")) {
            return new WrappedStreamUTF8Reader();
        }
        if (this.m_encodingName.equalsIgnoreCase("ISO-8859-1") || this.m_encodingName.equalsIgnoreCase("ASCII")) {
            return new WrappedStreamISO88591Reader();
        }
        return new InputStreamReader((InputStream)new WrappedStream(), this.m_encodingName);
    }

    public String getEncoding() {
        return this.m_encodingName;
    }

    public void close() throws IOException {
        if (this.m_stream != null) {
            this.m_stream.close();
            this.m_stream = null;
        }
        this.reset();
    }

    public void reset() {
        this.m_isEnd = false;
        this.m_endOffset = 0;
        this.m_emptyOffset = 0;
        this.m_encodingName = null;
    }

    private class WrappedStreamISO88591Reader
    extends Reader {
        private WrappedStreamISO88591Reader() {
        }

        public void close() throws IOException {
            InputStreamWrapper.this.close();
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            int n4 = InputStreamWrapper.this.m_emptyOffset;
            byte[] byArray = InputStreamWrapper.this.m_buffer;
            while (n < n3) {
                int n5;
                int n6 = InputStreamWrapper.this.m_endOffset - n4;
                if (n6 == 0) {
                    InputStreamWrapper.this.m_emptyOffset = n4;
                    if (InputStreamWrapper.this.fillBuffer()) {
                        n4 = InputStreamWrapper.this.m_emptyOffset;
                        n6 = InputStreamWrapper.this.m_endOffset - n4;
                    } else {
                        n5 = n2 + n - n3;
                        return n5 > 0 ? n5 : -1;
                    }
                }
                if ((n5 = n3 - n) > n6) {
                    n5 = n6;
                }
                int n7 = n4 + n5;
                while (n4 < n7) {
                    cArray[n++] = (char)(byArray[n4++] & 0xFF);
                }
            }
            InputStreamWrapper.this.m_emptyOffset = n4;
            return n2;
        }

        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        public int read() throws IOException {
            if (InputStreamWrapper.this.m_emptyOffset >= InputStreamWrapper.this.m_endOffset && !InputStreamWrapper.this.fillBuffer()) {
                return -1;
            }
            return InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++] & 0xFF;
        }

        public boolean ready() throws IOException {
            return InputStreamWrapper.this.m_emptyOffset < InputStreamWrapper.this.m_endOffset;
        }
    }

    private class WrappedStreamUTF8Reader
    extends Reader {
        private WrappedStreamUTF8Reader() {
        }

        public void close() throws IOException {
            InputStreamWrapper.this.close();
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            int n4 = InputStreamWrapper.this.m_emptyOffset;
            byte[] byArray = InputStreamWrapper.this.m_buffer;
            while (n < n3) {
                int n5;
                if (n4 + 3 > InputStreamWrapper.this.m_endOffset) {
                    InputStreamWrapper.this.m_emptyOffset = n4;
                    InputStreamWrapper.this.fillBuffer();
                    n4 = InputStreamWrapper.this.m_emptyOffset;
                    if (n4 == InputStreamWrapper.this.m_endOffset) {
                        n5 = n2 + n - n3;
                        return n5 > 0 ? n5 : -1;
                    }
                }
                if ((n5 = byArray[n4++]) >= 0) {
                    cArray[n++] = (char)n5;
                    if (n5 != 0) continue;
                    System.err.println("Wrote null");
                    continue;
                }
                if ((n5 & 0xE0) == 192) {
                    if (n4 < InputStreamWrapper.this.m_endOffset) {
                        cArray[n++] = (char)(((n5 & 0x1F) << 6) + (byArray[n4++] & 0x3F));
                        if (cArray[n - 1] != '\u0000') continue;
                        System.err.println("Wrote null");
                        continue;
                    }
                    throw new IOException("UTF-8 conversion error");
                }
                if (n4 + 1 < InputStreamWrapper.this.m_endOffset) {
                    int n6 = byArray[n4++] & 0x3F;
                    cArray[n++] = (char)((((n5 & 0xF) << 6) + n6 << 6) + (byArray[n4++] & 0x3F));
                    if (cArray[n - 1] != '\u0000') continue;
                    System.err.println("Wrote null");
                    continue;
                }
                throw new IOException("UTF-8 conversion error");
            }
            InputStreamWrapper.this.m_emptyOffset = n4;
            return n2;
        }

        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        public int read() throws IOException {
            byte by;
            if (InputStreamWrapper.this.m_emptyOffset + 3 > InputStreamWrapper.this.m_endOffset) {
                InputStreamWrapper.this.fillBuffer();
                if (InputStreamWrapper.this.m_emptyOffset == InputStreamWrapper.this.m_endOffset) {
                    return -1;
                }
            }
            if ((by = InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++]) >= 0) {
                return by & 0xFF;
            }
            if ((by & 0xE0) == 192) {
                if (InputStreamWrapper.this.m_emptyOffset < InputStreamWrapper.this.m_endOffset) {
                    return ((by & 0x1F) << 6) + (InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++] & 0x3F);
                }
                throw new IOException("UTF-8 conversion error");
            }
            if (InputStreamWrapper.this.m_emptyOffset + 1 < InputStreamWrapper.this.m_endOffset) {
                int n = InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++] & 0xFF;
                return (((by & 0xF) << 6) + n << 6) + (InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++] & 0x3F);
            }
            throw new IOException("UTF-8 conversion error");
        }

        public boolean ready() throws IOException {
            return InputStreamWrapper.this.m_emptyOffset + 2 < InputStreamWrapper.this.m_endOffset;
        }
    }

    private class WrappedStream
    extends InputStream {
        private WrappedStream() {
        }

        public int available() throws IOException {
            return InputStreamWrapper.this.m_endOffset - InputStreamWrapper.this.m_emptyOffset + InputStreamWrapper.this.m_stream.available();
        }

        public void close() throws IOException {
            InputStreamWrapper.this.close();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = 0;
            while (n2 > (n3 = InputStreamWrapper.this.m_endOffset - InputStreamWrapper.this.m_emptyOffset)) {
                System.arraycopy(InputStreamWrapper.this.m_buffer, InputStreamWrapper.this.m_emptyOffset, byArray, n, n3);
                n += n3;
                n2 -= n3;
                n4 += n3;
                InputStreamWrapper.this.m_emptyOffset = (InputStreamWrapper.this.m_endOffset = 0);
                if (InputStreamWrapper.this.fillBuffer()) continue;
                return n4 == 0 ? -1 : n4;
            }
            System.arraycopy(InputStreamWrapper.this.m_buffer, InputStreamWrapper.this.m_emptyOffset, byArray, n, n2);
            InputStreamWrapper.this.m_emptyOffset += n2;
            return n4 + n2;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public long skip(long l) throws IOException {
            int n = InputStreamWrapper.this.m_endOffset - InputStreamWrapper.this.m_emptyOffset;
            if (l >= (long)n) {
                return (long)n + InputStreamWrapper.this.m_stream.skip(l - (long)n);
            }
            InputStreamWrapper.this.m_emptyOffset += (int)l;
            return l;
        }

        public int read() throws IOException {
            if (InputStreamWrapper.this.m_emptyOffset >= InputStreamWrapper.this.m_endOffset && !InputStreamWrapper.this.fillBuffer()) {
                return -1;
            }
            return InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++];
        }
    }
}

