/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview.attributeview;

import freemind.modes.attributes.Attribute;
import freemind.view.mindmapview.attributeview.AttributeTableModelDecoratorAdapter;
import freemind.view.mindmapview.attributeview.AttributeView;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;

class ReducedAttributeTableModelDecorator
extends AttributeTableModelDecoratorAdapter {
    private Vector index = null;
    private int visibleRowCount;

    ReducedAttributeTableModelDecorator(AttributeView attrView) {
        super(attrView);
        this.rebuildTableModel();
    }

    private Vector getIndex() {
        if (this.index == null && this.attributeRegistry.getVisibleElementsNumber() > 0) {
            this.index = new Vector(this.nodeAttributeModel.getRowCount(), 10);
        }
        return this.index;
    }

    public int getRowCount() {
        return this.visibleRowCount;
    }

    public Object getValueAt(int row, int col) {
        return this.nodeAttributeModel.getValueAt(this.calcRow(row), col);
    }

    public boolean isCellEditable(int row, int col) {
        if (this.nodeAttributeModel.isCellEditable(row, col)) {
            return col == 1;
        }
        return false;
    }

    private int calcRow(int row) {
        return (Integer)this.index.get(row);
    }

    public void setValueAt(Object o, int row, int col) {
        this.nodeAttributeModel.setValueAt(o, this.calcRow(row), col);
        this.fireTableCellUpdated(row, col);
    }

    public void insertRow(int index, Attribute newAttribute) {
        throw new Error();
    }

    public void addRow(Attribute newAttribute) {
        throw new Error();
    }

    public Object removeRow(int index) {
        throw new Error();
    }

    public void stateChanged(ChangeEvent e) {
        this.rebuildTableModel();
        if (this.index != null) {
            this.fireTableDataChanged();
        }
    }

    private void rebuildTableModel() {
        this.getIndex();
        if (this.index != null) {
            this.visibleRowCount = 0;
            this.index.clear();
            for (int i = 0; i < this.nodeAttributeModel.getRowCount(); ++i) {
                String name = (String)this.nodeAttributeModel.getValueAt(i, 0);
                if (!this.attributeRegistry.getElement((Comparable)((Object)name)).isVisible()) continue;
                this.index.add(new Integer(i));
                ++this.visibleRowCount;
            }
        }
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getType() != 0 || e.getColumn() != 0) {
            this.rebuildTableModel();
            this.fireTableDataChanged();
        }
    }

    public boolean areAttributesVisible() {
        return this.getRowCount() != 0;
    }
}

