/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.attributes;

import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.AttributeController;
import freemind.modes.attributes.AttributeTableLayoutModel;
import freemind.modes.attributes.AttributeTableModel;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class NodeAttributeTableModel
extends AbstractTableModel
implements AttributeTableModel {
    private static boolean SHOW_ATTRIBUTE_ICON = Resources.getInstance().getBoolProperty("el__show_icon_for_attributes");
    private MindMapNode node;
    private Vector attributes = null;
    private AttributeTableLayoutModel layout = null;
    private static final int CAPACITY_INCREMENT = 10;
    private static ImageIcon noteIcon = null;
    private static final String STATE_ICON = "AttributeExist";

    public NodeAttributeTableModel(MindMapNode node, int size) {
        this.allocateAttributes(size);
        this.node = node;
    }

    private void allocateAttributes(int size) {
        if (this.attributes == null && size > 0) {
            this.attributes = new Vector(size, 10);
        }
    }

    public NodeAttributeTableModel(MindMapNode node) {
        this(node, 0);
    }

    public int getRowCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public Object getValueAt(int row, int col) {
        if (this.attributes != null) {
            switch (col) {
                case 0: {
                    return this.getName(row);
                }
                case 1: {
                    return this.getValue(row);
                }
            }
        }
        return null;
    }

    public Object getName(int row) {
        Attribute attr = (Attribute)this.attributes.get(row);
        return attr.getName();
    }

    public Object getValue(int row) {
        Attribute attr = (Attribute)this.attributes.get(row);
        return attr.getValue();
    }

    public AttributeController getAttributeController() {
        return this.node.getMap().getRegistry().getModeController().getAttributeController();
    }

    public void setValueAt(Object o, int row, int col) {
        this.getAttributeController().performSetValueAt(this, o, row, col);
    }

    public void enableStateIcon() {
        if (SHOW_ATTRIBUTE_ICON && this.getRowCount() == 1) {
            if (noteIcon == null) {
                noteIcon = new ImageIcon(Resources.getInstance().getResource("images/showAttributes.gif"));
            }
            this.node.setStateIcon(STATE_ICON, noteIcon);
        }
    }

    public void disableStateIcon() {
        if (SHOW_ATTRIBUTE_ICON && this.getRowCount() == 0) {
            this.node.setStateIcon(STATE_ICON, null);
        }
    }

    public void insertRow(int index, String name, String value) {
        this.getAttributeController().performInsertRow(this, index, name, value);
    }

    public void addRowNoUndo(Attribute newAttribute) {
        this.allocateAttributes(10);
        int index = this.getRowCount();
        this.node.getMap().getRegistry().getAttributes().registry(newAttribute);
        this.attributes.add(newAttribute);
        this.enableStateIcon();
        this.fireTableRowsInserted(index, index);
    }

    public void setName(int row, Object newName) {
        Attribute attr = (Attribute)this.attributes.get(row);
        attr.setName(newName.toString());
        this.fireTableRowsUpdated(row, row);
    }

    public void setValue(int row, Object newValue) {
        Attribute attr = (Attribute)this.attributes.get(row);
        attr.setValue(newValue.toString());
        this.fireTableRowsUpdated(row, row);
    }

    public Object removeRow(int index) {
        Object o = this.getAttributes().elementAt(index);
        this.getAttributeController().performRemoveRow(this, index);
        return o;
    }

    public void save(XMLElement node) {
        this.saveLayout(node);
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                this.saveAttribute(node, i);
            }
        }
    }

    private void saveAttribute(XMLElement node, int i) {
        XMLElement attributeElement = new XMLElement();
        attributeElement.setName("attribute");
        Attribute attr = (Attribute)this.attributes.get(i);
        attributeElement.setAttribute("NAME", attr.getName());
        attributeElement.setAttribute("VALUE", attr.getValue());
        node.addChild(attributeElement);
    }

    private void saveLayout(XMLElement node) {
        if (this.layout != null) {
            XMLElement attributeElement = null;
            if (this.layout.getColumnWidth(0) != 75) {
                attributeElement = this.initializeNodeAttributeLayoutXMLElement(attributeElement);
                attributeElement.setIntAttribute("NAME_WIDTH", this.getColumnWidth(0));
            }
            if (this.layout.getColumnWidth(1) != 75) {
                attributeElement = this.initializeNodeAttributeLayoutXMLElement(attributeElement);
                attributeElement.setIntAttribute("VALUE_WIDTH", this.layout.getColumnWidth(1));
            }
            if (attributeElement != null) {
                node.addChild(attributeElement);
            }
        }
    }

    private XMLElement initializeNodeAttributeLayoutXMLElement(XMLElement attributeElement) {
        if (attributeElement == null) {
            attributeElement = new XMLElement();
            attributeElement.setName("attribute_layout");
        }
        return attributeElement;
    }

    public MindMapNode getNode() {
        return this.node;
    }

    public Attribute getAttribute(int row) {
        return (Attribute)this.attributes.get(row);
    }

    public int getColumnCount() {
        return 2;
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return !this.node.getMap().isReadOnly();
    }

    public String getColumnName(int col) {
        return "";
    }

    public Class getColumnClass(int col) {
        return Object.class;
    }

    public int getColumnWidth(int col) {
        return this.getLayout().getColumnWidth(col);
    }

    public void setColumnWidth(int col, int width) {
        this.getAttributeController().performSetColumnWidth(this, col, width);
    }

    public AttributeTableLayoutModel getLayout() {
        if (this.layout == null) {
            this.layout = new AttributeTableLayoutModel();
        }
        return this.layout;
    }

    public Vector getAttributes() {
        this.allocateAttributes(10);
        return this.attributes;
    }
}

