/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.impl.MozillaContainer;

public class JFakeTooltip
extends JDialog {
    private static final long serialVersionUID = -5265135238377781454L;
    private final MozillaPanel owner;
    private JLabel tooltipLabel;

    public static JFakeTooltip create(MozillaPanel owner) {
        Window win = SwingUtilities.getWindowAncestor(owner.getMozillaContainer());
        if (win instanceof Frame) {
            return new JFakeTooltip((Frame)win, owner);
        }
        if (win instanceof Dialog) {
            return new JFakeTooltip((Dialog)win, owner);
        }
        return new JFakeTooltip((Frame)null, owner);
    }

    public JFakeTooltip(Frame ownerFrame, MozillaPanel owner) {
        super(ownerFrame);
        this.owner = owner;
        this.init();
    }

    public JFakeTooltip(Dialog ownerDialog, MozillaPanel owner) {
        super(ownerDialog);
        this.owner = owner;
        this.init();
    }

    public void init() {
        JFakeTooltip.setDefaultLookAndFeelDecorated(false);
        this.setUndecorated(true);
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        JPanel box = new JPanel();
        Border border = UIManager.getBorder("ToolTip.border");
        box.setBorder(border);
        box.setLayout(new BorderLayout());
        this.tooltipLabel = new JLabel("");
        this.tooltipLabel.setHorizontalAlignment(0);
        Color fg = UIManager.getColor("ToolTip.foreground");
        Color bg = UIManager.getColor("ToolTip.background");
        Font f = UIManager.getFont("ToolTip.font");
        this.tooltipLabel.setOpaque(true);
        this.tooltipLabel.setForeground(fg);
        this.tooltipLabel.setBackground(bg);
        this.tooltipLabel.setFont(f);
        Border b = BorderFactory.createEmptyBorder(0, 3, 0, 3);
        this.tooltipLabel.setBorder(b);
        box.add((Component)this.tooltipLabel, "Center");
        this.setContentPane(box);
    }

    public void setup(int x, int y, String aText) {
        this.tooltipLabel.setText(aText);
        Point loc = new Point(x, y);
        MozillaContainer parent = this.owner.getMozillaContainer();
        SwingUtilities.convertPointToScreen(loc, parent);
        loc.translate(15, 15);
        this.setLocation(loc);
        this.pack();
    }

    public JLabel getTooltipLabel() {
        return this.tooltipLabel;
    }
}

