/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.limewire.friend.api.FriendRequest;
import org.limewire.friend.api.FriendRequestDecisionHandler;
import org.limewire.friend.api.FriendRequestEvent;
import org.limewire.friend.impl.util.PresenceUtils;
import org.limewire.listener.EventBroadcaster;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

class SubscriptionListener
implements PacketListener,
PacketFilter,
FriendRequestDecisionHandler {
    private static final Log LOG = LogFactory.getLog(SubscriptionListener.class);
    private final XMPPConnection connection;
    private final EventBroadcaster<FriendRequestEvent> friendRequestBroadcaster;

    SubscriptionListener(XMPPConnection connection, EventBroadcaster<FriendRequestEvent> friendRequestBroadcaster) {
        this.connection = connection;
        this.friendRequestBroadcaster = friendRequestBroadcaster;
    }

    @Override
    public void processPacket(Packet packet) {
        try {
            Presence presence = (Presence)packet;
            String friendUsername = PresenceUtils.parseBareAddress(packet.getFrom());
            if (presence.getType() == Presence.Type.subscribe) {
                LOG.debugf("subscribe from {0}", (Object)friendUsername);
                Roster roster = this.connection.getRoster();
                if (roster != null) {
                    RosterEntry entry = roster.getEntry(friendUsername);
                    if (entry == null) {
                        LOG.debug("it's a new subscription");
                        this.friendRequestBroadcaster.broadcast(new FriendRequestEvent(new FriendRequest(friendUsername, this), FriendRequestEvent.Type.REQUESTED));
                    } else {
                        LOG.debug("it's a response to our subscription");
                        Presence subbed = new Presence(Presence.Type.subscribed);
                        subbed.setTo(friendUsername);
                        this.connection.sendPacket(subbed);
                    }
                }
            } else if (presence.getType() == Presence.Type.subscribed) {
                LOG.debugf("subscribed from {0}", (Object)friendUsername);
            } else if (presence.getType() == Presence.Type.unsubscribe) {
                LOG.debugf("unsubscribe from {0}", (Object)friendUsername);
                Presence unsubbed = new Presence(Presence.Type.unsubscribed);
                unsubbed.setTo(friendUsername);
                this.connection.sendPacket(unsubbed);
                Roster roster = this.connection.getRoster();
                if (roster != null) {
                    RosterEntry entry = roster.getEntry(friendUsername);
                    if (entry == null) {
                        LOG.debug("it's a response to our unsubscription");
                    } else {
                        LOG.debug("it's a new unsubscription");
                        Presence unsub = new Presence(Presence.Type.unsubscribe);
                        unsub.setTo(friendUsername);
                        this.connection.sendPacket(unsub);
                        try {
                            roster.removeEntry(entry);
                        }
                        catch (XMPPException x) {
                            LOG.debug(x);
                        }
                    }
                }
            } else if (presence.getType() == Presence.Type.unsubscribed) {
                LOG.debugf("unsubscribed from {0}", (Object)friendUsername);
            }
        }
        catch (XMPPException e) {
            LOG.debug("processPacket failed", e);
        }
    }

    @Override
    public boolean accept(Packet packet) {
        if (packet instanceof Presence) {
            Presence presence = (Presence)packet;
            return presence.getType() == Presence.Type.subscribe || presence.getType() == Presence.Type.subscribed || presence.getType() == Presence.Type.unsubscribe || presence.getType() == Presence.Type.unsubscribed;
        }
        return false;
    }

    @Override
    public void handleDecision(String friendUsername, boolean accepted) {
        try {
            if (!this.connection.isConnected()) {
                return;
            }
            if (accepted) {
                LOG.debug("user accepted");
                Presence subbed = new Presence(Presence.Type.subscribed);
                subbed.setTo(friendUsername);
                this.connection.sendPacket(subbed);
                Roster roster = this.connection.getRoster();
                if (roster != null) {
                    roster.createEntry(friendUsername, friendUsername, null);
                }
            } else {
                LOG.debug("user declined");
                Presence unsubbed = new Presence(Presence.Type.unsubscribed);
                unsubbed.setTo(friendUsername);
                this.connection.sendPacket(unsubbed);
            }
        }
        catch (XMPPException e) {
            LOG.debug("handleDecision failed", e);
        }
    }
}

