/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.limewire.security.certificate.CipherProvider;

public final class Password {
    private static final CipherProvider.CipherType CIPHER_TYPE = CipherProvider.CipherType.AES;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final String passwordString;
    private final boolean isEncrypted;
    private CipherProvider cipherProvider;

    Password(CipherProvider cipherProvider, String passwordString, boolean isEncrypted) {
        this.cipherProvider = cipherProvider;
        this.passwordString = passwordString;
        this.isEncrypted = isEncrypted;
    }

    public String encryptPassword() throws IOException, NoSuchAlgorithmException {
        if (this.isEncrypted) {
            throw new IllegalStateException("Password is already encrypted; Cannot encrypt.");
        }
        KeyGenerator kgen = KeyGenerator.getInstance(CIPHER_TYPE.getDescription());
        SecretKey key = kgen.generateKey();
        byte[] keyAsBytes = key.getEncoded();
        byte[] encrypted = this.cipherProvider.encrypt(this.passwordString.getBytes(DEFAULT_ENCODING), key, CIPHER_TYPE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Password.writeField(baos, keyAsBytes);
        Password.writeField(baos, encrypted);
        byte[] magicBytes = baos.toByteArray();
        return new String(Base64.encodeBase64(magicBytes), DEFAULT_ENCODING);
    }

    public String decryptPassword() throws IOException, GeneralSecurityException {
        if (!this.isEncrypted) {
            throw new IllegalStateException("Password is not encrypted; Cannot decrypt.");
        }
        byte[] magicBytes = Base64.decodeBase64(this.passwordString.getBytes(DEFAULT_ENCODING));
        ByteArrayInputStream bais = new ByteArrayInputStream(magicBytes);
        byte[] keyAsBytes = Password.readField(bais);
        byte[] encryptedPassword = Password.readField(bais);
        SecretKeySpec keySpec = new SecretKeySpec(keyAsBytes, CIPHER_TYPE.getDescription());
        byte[] pwdAsBytes = this.cipherProvider.decrypt(encryptedPassword, keySpec, CIPHER_TYPE);
        if (bais.available() > 0) {
            throw new IOException("Additional bytes after encryption key");
        }
        return new String(pwdAsBytes, DEFAULT_ENCODING);
    }

    private static void writeField(ByteArrayOutputStream baos, byte[] data) throws IOException {
        baos.write(data.length);
        baos.write(data);
    }

    private static byte[] readField(ByteArrayInputStream bais) throws IOException {
        int actualFieldLen;
        int fieldStatedLen = bais.read();
        if (fieldStatedLen <= 0) {
            throw new IOException("Corrupt key detected");
        }
        byte[] fieldBytes = new byte[fieldStatedLen];
        try {
            actualFieldLen = bais.read(fieldBytes);
        }
        catch (IOException e) {
            throw new IOException("Corrupt key detected: " + e.getMessage());
        }
        if (actualFieldLen != fieldStatedLen) {
            throw new IOException("Corrupt key detected: Mismatch between stated key length and actual key length.");
        }
        return fieldBytes;
    }
}

