/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import java.util.List;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.limewire.friend.api.FriendConnectionConfiguration;
import org.limewire.io.UnresolvedIpPort;
import org.limewire.xmpp.client.impl.ConnectionConfigurationFactory;

public class FallbackConnectionConfigurationFactory
implements ConnectionConfigurationFactory {
    @Override
    public boolean hasMore(FriendConnectionConfiguration connectionConfiguration, ConnectionConfigurationFactory.RequestContext requestContext) {
        return requestContext.getNumRequests() < connectionConfiguration.getDefaultServers().size();
    }

    @Override
    public ConnectionConfiguration getConnectionConfiguration(FriendConnectionConfiguration connectionConfiguration, ConnectionConfigurationFactory.RequestContext requestContext) {
        this.checkHasMore(connectionConfiguration, requestContext);
        List<UnresolvedIpPort> defaultServers = connectionConfiguration.getDefaultServers();
        UnresolvedIpPort defaultServer = defaultServers.get(requestContext.getNumRequests());
        return new ConnectionConfiguration(defaultServer.getAddress(), defaultServer.getPort(), connectionConfiguration.getServiceName());
    }

    private void checkHasMore(FriendConnectionConfiguration connectionConfiguration, ConnectionConfigurationFactory.RequestContext requestContext) {
        if (!this.hasMore(connectionConfiguration, requestContext)) {
            throw new IllegalStateException("no more ConnectionConfigurations");
        }
    }
}

