/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.bittorrent.Torrent;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadPropertyKey;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.api.upload.UploadPropertyKey;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.properties.FileInfoOverviewPanel;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.properties.FileInfoPanelFactory;
import org.limewire.ui.swing.properties.FileInfoTabPanel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class FileInfoDialog
extends LimeJDialog {
    @Resource
    private Color backgroundColor;
    private final LibraryManager libraryManager;
    private final FileInfoTabPanel tabPanel;
    private final FileInfoOverviewPanel overviewPanel;
    private final JPanel cardPanel;
    private final Map<FileInfoTabPanel.Tabs, FileInfoPanel> cards;
    private JButton okButton;
    private PropertiableFile propertiableFile;
    private RenameListener renameListener;

    @Inject
    public FileInfoDialog(@Assisted PropertiableFile propertiable, final @Assisted FileInfoType type, FileInfoTabPanel fileInfoTabPanel, final FileInfoPanelFactory fileInfoFactory, LibraryManager libraryManager) {
        super(GuiUtils.getMainFrame());
        this.libraryManager = libraryManager;
        this.tabPanel = fileInfoTabPanel;
        this.cardPanel = new JPanel(new BorderLayout());
        this.cardPanel.setPreferredSize(new Dimension(400, 600));
        this.cards = new HashMap<FileInfoTabPanel.Tabs, FileInfoPanel>();
        this.propertiableFile = propertiable;
        GuiUtils.assignResources(this);
        this.cardPanel.setOpaque(false);
        this.createTabs(this.propertiableFile, type);
        this.cards.put(FileInfoTabPanel.Tabs.GENERAL, fileInfoFactory.createGeneralPanel(type, this.propertiableFile));
        this.cardPanel.add(this.cards.get((Object)FileInfoTabPanel.Tabs.GENERAL).getComponent());
        this.updateTitle(this.propertiableFile.getFileName());
        this.setLayout(new MigLayout("gap 0, insets 0, fill"));
        this.getContentPane().setBackground(this.backgroundColor);
        this.overviewPanel = (FileInfoOverviewPanel)fileInfoFactory.createOverviewPanel(type, this.propertiableFile);
        this.add((Component)this.overviewPanel.getComponent(), "dock north");
        this.add((Component)this.tabPanel.getComponent(), "dock north");
        this.add((Component)this.cardPanel, "gapleft 10, grow, gapright 10");
        this.createFooter();
        this.setPreferredSize(new Dimension(500, 565));
        this.setDefaultCloseOperation(2);
        if (type == FileInfoType.LOCAL_FILE) {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        }
        this.pack();
        this.setLocationRelativeTo(GuiUtils.getMainFrame());
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                FileInfoDialog.this.dispose();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (FileInfoDialog.this.okButton != null) {
                    FileInfoDialog.this.okButton.requestFocusInWindow();
                }
            }
        });
        this.renameListener = new RenameListener(libraryManager);
        libraryManager.getLibraryManagedList().addPropertyChangeListener(this.renameListener);
        this.tabPanel.addSearchTabListener(new FileInfoTabPanel.FileInfoTabListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void tabSelected(FileInfoTabPanel.Tabs tab) {
                if (!FileInfoDialog.this.cards.containsKey((Object)tab)) {
                    if (tab == FileInfoTabPanel.Tabs.GENERAL) {
                        FileInfoDialog.this.cards.put(tab, fileInfoFactory.createGeneralPanel(type, FileInfoDialog.this.propertiableFile));
                    } else if (tab == FileInfoTabPanel.Tabs.SHARING) {
                        FileInfoDialog.this.cards.put(tab, fileInfoFactory.createSharingPanel(type, FileInfoDialog.this.propertiableFile));
                    } else if (tab == FileInfoTabPanel.Tabs.TRACKERS) {
                        FileInfoDialog.this.cards.put(tab, fileInfoFactory.createTrackersPanel(type, FileInfoDialog.this.propertiableFile));
                    } else if (tab == FileInfoTabPanel.Tabs.TRANSFERS) {
                        FileInfoDialog.this.cards.put(tab, fileInfoFactory.createTransferPanel(type, FileInfoDialog.this.propertiableFile));
                    } else if (tab == FileInfoTabPanel.Tabs.BITTORENT) {
                        if (FileInfoDialog.this.propertiableFile instanceof DownloadItem) {
                            Torrent torrent = (Torrent)((DownloadItem)FileInfoDialog.this.propertiableFile).getDownloadProperty(DownloadPropertyKey.TORRENT);
                            if (torrent != null && torrent.hasMetaData()) {
                                FileInfoDialog.this.cards.put(tab, fileInfoFactory.createBittorentPanel(torrent));
                            }
                        } else {
                            if (!(FileInfoDialog.this.propertiableFile instanceof UploadItem)) throw new IllegalStateException("No Torrent found for BITTORENT tab.");
                            Torrent torrent = (Torrent)((UploadItem)FileInfoDialog.this.propertiableFile).getUploadProperty(UploadPropertyKey.TORRENT);
                            if (torrent != null && torrent.hasMetaData()) {
                                FileInfoDialog.this.cards.put(tab, fileInfoFactory.createBittorentPanel(torrent));
                            }
                        }
                    } else {
                        if (tab != FileInfoTabPanel.Tabs.PIECES) throw new IllegalStateException("Unknown state:" + (Object)((Object)tab));
                        if (!(FileInfoDialog.this.propertiableFile instanceof DownloadItem)) throw new IllegalStateException("Should not have a pieces tab for a non download");
                        FileInfoDialog.this.cards.put(tab, fileInfoFactory.createPiecesPanel(type, (DownloadItem)FileInfoDialog.this.propertiableFile));
                    }
                }
                FileInfoDialog.this.cardPanel.removeAll();
                FileInfoDialog.this.cardPanel.add(((FileInfoPanel)FileInfoDialog.this.cards.get((Object)tab)).getComponent());
                FileInfoDialog.this.validate();
                FileInfoDialog.this.repaint();
            }
        });
    }

    @Override
    public void dispose() {
        this.overviewPanel.dispose();
        for (FileInfoPanel panel : this.cards.values()) {
            panel.dispose();
        }
        this.libraryManager.getLibraryManagedList().removePropertyChangeListener(this.renameListener);
        super.dispose();
    }

    private void updateTitle(String fileName) {
        this.setTitle(I18n.tr("{0} Properties", this.propertiableFile.getFileName()));
    }

    public void renameFile() {
        this.overviewPanel.enableRename();
    }

    private void createTabs(PropertiableFile propertiableFile, FileInfoType type) {
        ArrayList<FileInfoTabPanel.Tabs> tabs = new ArrayList<FileInfoTabPanel.Tabs>();
        tabs.add(FileInfoTabPanel.Tabs.GENERAL);
        switch (type) {
            case LOCAL_FILE: {
                tabs.add(FileInfoTabPanel.Tabs.SHARING);
                break;
            }
            case DOWNLOADING_FILE: {
                Torrent torrent;
                if (propertiableFile instanceof DownloadItem && ((DownloadItem)propertiableFile).getDownloadItemType() == DownloadItem.DownloadItemType.BITTORRENT && (torrent = (Torrent)((DownloadItem)propertiableFile).getDownloadProperty(DownloadPropertyKey.TORRENT)) != null && torrent.hasMetaData()) {
                    tabs.add(FileInfoTabPanel.Tabs.BITTORENT);
                    tabs.add(FileInfoTabPanel.Tabs.TRACKERS);
                }
                tabs.add(FileInfoTabPanel.Tabs.TRANSFERS);
                tabs.add(FileInfoTabPanel.Tabs.PIECES);
                break;
            }
            case UPLOADING_FILE: {
                Torrent torrent;
                if (propertiableFile instanceof UploadItem && ((UploadItem)propertiableFile).getUploadItemType() == UploadItem.UploadItemType.BITTORRENT && (torrent = (Torrent)((UploadItem)propertiableFile).getUploadProperty(UploadPropertyKey.TORRENT)) != null && torrent.hasMetaData()) {
                    tabs.add(FileInfoTabPanel.Tabs.BITTORENT);
                    tabs.add(FileInfoTabPanel.Tabs.TRACKERS);
                }
                tabs.add(FileInfoTabPanel.Tabs.TRANSFERS);
                break;
            }
        }
        this.tabPanel.setTabs(tabs);
    }

    private void createFooter() {
        this.okButton = new JButton(new OKAction());
        JPanel footerPanel = new JPanel(new MigLayout("fill, insets 0 15 10 15"));
        footerPanel.add((Component)this.okButton, "alignx right, aligny bottom, split, tag ok");
        footerPanel.add((Component)new JButton(new CancelAction()), "aligny bottom, tag cancel");
        footerPanel.setBackground(this.backgroundColor);
        this.add((Component)footerPanel, "grow, south");
    }

    private class RenameListener
    implements PropertyChangeListener {
        private LibraryManager libraryManager;

        public RenameListener(LibraryManager libraryManager) {
            this.libraryManager = libraryManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("rename") && FileInfoDialog.this.propertiableFile instanceof LocalFileItem && ((LocalFileItem)FileInfoDialog.this.propertiableFile).getFile().equals(evt.getOldValue())) {
                FileInfoDialog.this.propertiableFile = this.libraryManager.getLibraryManagedList().getFileItem((File)evt.getNewValue());
                for (FileInfoPanel panel : FileInfoDialog.this.cards.values()) {
                    panel.updatePropertiableFile(FileInfoDialog.this.propertiableFile);
                }
                FileInfoDialog.this.overviewPanel.updatePropertiableFile(FileInfoDialog.this.propertiableFile);
                FileInfoDialog.this.updateTitle(FileInfoDialog.this.propertiableFile.getFileName());
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(I18n.tr("Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileInfoDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            super(I18n.tr("OK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileInfoDialog.this.overviewPanel.save();
            for (FileInfoPanel panel : FileInfoDialog.this.cards.values()) {
                panel.save();
            }
            FileInfoDialog.this.setVisible(false);
        }
    }

    public static enum FileInfoType {
        LOCAL_FILE,
        DOWNLOADING_FILE,
        REMOTE_FILE,
        UPLOADING_FILE;

    }
}

