/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentManagerSettings;
import org.limewire.bittorrent.TorrentSettingsAnnotation;
import org.limewire.core.settings.BittorrentSettings;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.PeriodicFieldValidator;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.actions.CancelDialogAction;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

public class BitTorrentOptionPanel
extends OptionPanel {
    private final Provider<TorrentManager> torrentManager;
    private final TorrentManagerSettings torrentSettings;
    private final JRadioButton uploadTorrentsForeverButton;
    private final JRadioButton uploadTorrentsControlButton;
    private final SpinnerNumberModel seedRatioModel;
    private final JSpinner seedRatioSpinner;
    private final SpinnerNumberModel seedDaysModel;
    private final SpinnerNumberModel seedHoursModel;
    private final JSpinner seedDaysSpinner;
    private final JSpinner seedHoursSpinner;
    private final JCheckBox chooseTorrentsCheckBox;

    @Inject
    public BitTorrentOptionPanel(Provider<TorrentManager> torrentManager, @TorrentSettingsAnnotation TorrentManagerSettings torrentSettings) {
        this.torrentManager = torrentManager;
        this.torrentSettings = torrentSettings;
        this.setLayout(new MigLayout("fill"));
        this.setOpaque(false);
        this.uploadTorrentsForeverButton = new JRadioButton(I18n.tr("Upload torrents forever"));
        this.uploadTorrentsForeverButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BitTorrentOptionPanel.this.updateState(BitTorrentOptionPanel.this.uploadTorrentsForeverButton.isSelected());
            }
        });
        this.uploadTorrentsControlButton = new JRadioButton(I18n.tr("Upload torrents until either of the following:"));
        this.uploadTorrentsControlButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BitTorrentOptionPanel.this.updateState(BitTorrentOptionPanel.this.uploadTorrentsForeverButton.isSelected());
            }
        });
        this.uploadTorrentsForeverButton.setOpaque(false);
        this.uploadTorrentsControlButton.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.uploadTorrentsForeverButton);
        buttonGroup.add(this.uploadTorrentsControlButton);
        this.seedRatioModel = new SpinnerNumberModel(BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.get().doubleValue(), ((Float)BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.getMinValue()).doubleValue(), ((Float)BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.getMaxValue()).doubleValue(), 0.05);
        this.seedRatioSpinner = new JSpinner(this.seedRatioModel);
        this.seedRatioSpinner.setPreferredSize(new Dimension(50, 20));
        this.seedRatioSpinner.setMaximumSize(new Dimension(60, 20));
        int wholeDays = BitTorrentOptionPanel.getWholeDays(BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.get());
        this.seedDaysModel = new SpinnerNumberModel(wholeDays, BitTorrentOptionPanel.getWholeDays((Integer)BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.getMinValue()), BitTorrentOptionPanel.getWholeDays((Integer)BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.getMaxValue()), 1);
        this.seedHoursModel = new SpinnerNumberModel(BitTorrentOptionPanel.getRemainderHours(BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.get(), wholeDays), 0, 24, 1);
        this.seedDaysSpinner = new JSpinner(this.seedDaysModel);
        this.seedDaysSpinner.setPreferredSize(new Dimension(50, 20));
        this.seedDaysSpinner.setMaximumSize(new Dimension(60, 20));
        this.seedHoursSpinner = new JSpinner(this.seedHoursModel);
        this.seedHoursSpinner.setPreferredSize(new Dimension(50, 20));
        this.seedHoursSpinner.setMaximumSize(new Dimension(60, 20));
        JFormattedTextField seedDaysField = ((JSpinner.DefaultEditor)this.seedDaysSpinner.getEditor()).getTextField();
        seedDaysField.addKeyListener(new PeriodicFieldValidator(seedDaysField));
        JFormattedTextField seedHoursField = ((JSpinner.DefaultEditor)this.seedHoursSpinner.getEditor()).getTextField();
        seedHoursField.addKeyListener(new PeriodicFieldValidator(seedHoursField));
        this.chooseTorrentsCheckBox = new JCheckBox(I18n.tr("Let me choose files to download when starting a torrent"));
        this.chooseTorrentsCheckBox.setOpaque(false);
        if (torrentManager.get().isValid()) {
            this.add((Component)this.uploadTorrentsForeverButton, "span 3, wrap");
            this.add((Component)this.uploadTorrentsControlButton, "span 3, wrap");
            this.add((Component)new JLabel(I18n.tr("Ratio:")), "split 2, gapleft 20");
            this.add((Component)this.seedRatioSpinner, "span, wrap");
            this.add((Component)new JLabel(I18n.tr("Maximum days:")), "gapleft 20, split 4");
            this.add((Component)this.seedDaysSpinner, "");
            this.add((Component)new JLabel("Hours:"), "gapleft 20");
            this.add((Component)this.seedHoursSpinner, "wrap");
            this.add((Component)this.chooseTorrentsCheckBox, "span, gaptop 10, gapbottom 5, wrap");
        } else {
            this.add((Component)new MultiLineLabel(I18n.tr("There was an error loading bittorrent. You will not be able to use bittorrent capabilities until this is resolved."), 500), "wrap");
        }
        this.add((Component)new JButton(new OKDialogAction()), "span, tag ok, alignx right, split 2");
        this.add((Component)new JButton(new CancelDialogAction()), "tag cancel");
    }

    @Override
    boolean applyOptions() {
        BittorrentSettings.UPLOAD_TORRENTS_FOREVER.setValue(this.uploadTorrentsForeverButton.isSelected());
        if (!this.uploadTorrentsForeverButton.isSelected()) {
            BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.setValue(this.seedRatioModel.getNumber().floatValue());
            BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.setValue(BitTorrentOptionPanel.getSeconds((Integer)this.seedDaysSpinner.getValue(), (Integer)this.seedHoursSpinner.getValue()));
        }
        BittorrentSettings.TORRENT_SHOW_POPUP_BEFORE_DOWNLOADING.setValue(this.chooseTorrentsCheckBox.isSelected());
        if (this.torrentManager.get().isInitialized() && this.torrentManager.get().isValid()) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    ((TorrentManager)BitTorrentOptionPanel.this.torrentManager.get()).setTorrentManagerSettings(BitTorrentOptionPanel.this.torrentSettings);
                }
            });
        }
        return false;
    }

    @Override
    boolean hasChanged() {
        return BittorrentSettings.UPLOAD_TORRENTS_FOREVER.getValue() != this.uploadTorrentsForeverButton.isSelected() || ((Float)this.seedRatioSpinner.getValue()).floatValue() != BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.getValue() || BitTorrentOptionPanel.getSeconds((Integer)this.seedDaysSpinner.getValue(), (Integer)this.seedHoursSpinner.getValue()) != BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.getValue() || this.chooseTorrentsCheckBox.isSelected() != BittorrentSettings.TORRENT_SHOW_POPUP_BEFORE_DOWNLOADING.getValue();
    }

    @Override
    public void initOptions() {
        boolean auto = BittorrentSettings.UPLOAD_TORRENTS_FOREVER.getValue();
        if (auto) {
            this.uploadTorrentsForeverButton.setSelected(true);
        } else {
            this.uploadTorrentsControlButton.setSelected(true);
        }
        this.seedRatioSpinner.setValue(BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.get().doubleValue());
        this.seedDaysSpinner.setValue(BitTorrentOptionPanel.getWholeDays(BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.get()));
        this.chooseTorrentsCheckBox.setSelected(BittorrentSettings.TORRENT_SHOW_POPUP_BEFORE_DOWNLOADING.getValue());
    }

    private static int getWholeDays(Integer integer) {
        return (int)Math.floor(integer.doubleValue() / 86400.0);
    }

    private static int getRemainderHours(Integer totalSeconds, int days) {
        return (int)Math.round(totalSeconds.doubleValue() / 3600.0 - (double)(days * 24));
    }

    private static int getSeconds(int days, int hours) {
        return days * 24 * 60 * 60 + hours * 60 * 60;
    }

    private void updateState(boolean uploadForever) {
        this.seedRatioSpinner.setEnabled(!uploadForever);
        this.seedDaysSpinner.setEnabled(!uploadForever);
        this.seedHoursSpinner.setEnabled(!uploadForever);
    }
}

