/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.settings;

import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.settings.MojitoProps;
import org.limewire.mojito.util.ArrayUtils;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.LongSetting;
import org.limewire.setting.StringSetting;

public class ContextSettings
extends MojitoProps {
    public static final IntSetting SHUTDOWN_MESSAGES_MULTIPLIER = FACTORY.createRemoteIntSetting("SHUTDOWN_MESSAGES_MULTIPLIER", 2, "Mojito.ShutdownMessagesMultiplier", 0, 20);
    public static final LongSetting ESTIMATE_NETWORK_SIZE_EVERY = FACTORY.createRemoteLongSetting("ESTIMATE_NETWORK_SIZE_EVERY", 60000L, "Mojito.EstimateNetworkSizeEvery", 1000L, 300000L);
    public static final LongSetting UPDATE_NETWORK_SIZE_EVERY = FACTORY.createRemoteLongSetting("UPDATE_NETWORK_SIZE_EVERY", 5000L, "Mojito.UpdateNetworkSizeEvery", 5000L, 300000L);
    public static final IntSetting MAX_LOCAL_HISTORY_SIZE = FACTORY.createRemoteIntSetting("MAX_LOCAL_HISTORY_SIZE", 20, "Mojito.MaxLocalHistorySize", 1, 100);
    public static final BooleanSetting ESTIMATE_WITH_LIVE_NODES_ONLY = FACTORY.createRemoteBooleanSetting("ESTIMATE_WITH_LIVE_NODES_ONLY", true, "Mojito.EstimateWithLiveNodesOnly");
    public static final IntSetting MAX_REMOTE_HISTORY_SIZE = FACTORY.createRemoteIntSetting("MAX_REMOTE_HISTORY_SIZE", 10, "Mojito.MaxRemoteHistorySize", 0, 100);
    public static final BooleanSetting COUNT_REMOTE_SIZE = FACTORY.createRemoteBooleanSetting("COUNT_REMOTE_SIZE", true, "Mojito.CountRemoteSize");
    public static final IntSetting SKIP_REMOTE_ESTIMATES = FACTORY.createRemoteIntSetting("SKIP_REMOTE_ESTIMATES", 1, "Mojito.SkipRemoteEstimates", 0, Integer.MAX_VALUE);
    public static final StringSetting MASTER_KEY = FACTORY.createStringSetting("MASTER_KEY", "public.key");
    public static final LongSetting WAIT_ON_LOCK = FACTORY.createLongSetting("WAIT_ON_LOCK", 180000L);
    public static final BooleanSetting ASSERT_COLLISION_PING = FACTORY.createBooleanSetting("ASSERT_COLLISION_PING", true);
    public static final IntSetting VENDOR = FACTORY.createIntSetting("VENDOR", ArrayUtils.toInteger("LIME"));
    public static final IntSetting VERSION = FACTORY.createIntSetting("VERSION", 0);
    public static final BooleanSetting SEND_SHUTDOWN_MESSAGE = FACTORY.createBooleanSetting("SEND_SHUTDOWN_MESSAGE", true);
    public static final BooleanSetting THROW_EXCEPTION_IF_NOT_BOOTSTRAPPED = FACTORY.createBooleanSetting("THROW_EXCEPTION_IF_NOT_BOOTSTRAPPED", true);

    private ContextSettings() {
    }

    public static Vendor getVendor() {
        return Vendor.valueOf(VENDOR.getValue());
    }

    public static Version getVersion() {
        return Version.valueOf(VERSION.getValue());
    }

    public static long getWaitOnLock(long timeout) {
        return Math.max((long)((float)timeout * 1.5f), WAIT_ON_LOCK.getValue());
    }
}

