/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.fix;

import java.io.File;
import java.io.FileFilter;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.ogg.OggFileReader;
import org.jaudiotagger.fix.Fix;

public class Fix202 {
    public static final String IDENT = "$Id: Fix202.java,v 1.1 2008/02/21 14:26:33 paultaylor Exp $";

    public static void main(String[] args) {
        File dir;
        Fix202 test = new Fix202();
        if (args.length != 1) {
            System.err.println("usage Fix202 Folder");
            System.err.println("      You must enter the folder containing the corrupted files");
            System.exit(1);
        }
        if (!(dir = new File(args[0])).exists()) {
            System.err.println("usage Fix202 Folder");
            System.err.println("      File " + args[0] + " does not exist");
            System.exit(1);
        }
        if (!dir.isDirectory()) {
            System.err.println("usage Fix202 Folder");
            System.err.println("      File " + args[0] + " is not a folder");
            System.exit(1);
        }
        try {
            File[] audioFiles = dir.listFiles(new OggFileFilter());
            if (audioFiles.length > 0) {
                for (File oggFile : audioFiles) {
                    AudioFile audioFile;
                    OggFileReader fileReader;
                    System.out.print("Processing " + oggFile.getPath() + " ");
                    try {
                        fileReader = new OggFileReader();
                        audioFile = fileReader.read(oggFile);
                        System.out.println(":Not Broken");
                    }
                    catch (Throwable t) {
                        try {
                            fileReader = new OggFileReader(Fix.FIX_OGG_VORBIS_COMMENT_NOT_COUNTING_EMPTY_COLUMNS);
                            audioFile = fileReader.read(oggFile);
                            audioFile.commit();
                            fileReader = new OggFileReader();
                            audioFile = fileReader.read(oggFile);
                            audioFile.commit();
                            System.out.println(":********Fixed*************");
                        }
                        catch (Throwable t2) {
                            System.err.println("Unable to fix");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Unable to extract tag");
            System.exit(1);
        }
    }

    static class OggFileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        @Override
        public final boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".ogg");
        }

        @Override
        public final String getDescription() {
            return new String(".ogg Files");
        }
    }
}

