/*
 * Decompiled with CFR 0.152.
 */
package com.lti.utils.synchronization;

public class SynchronizedBoolean {
    private boolean b = false;

    public SynchronizedBoolean() {
    }

    public SynchronizedBoolean(boolean initValue) {
        this.b = initValue;
    }

    public synchronized boolean getValue() {
        return this.b;
    }

    public synchronized void setValue(boolean newValue) {
        if (this.b != newValue) {
            this.b = newValue;
            this.notifyAll();
        }
    }

    public synchronized void waitUntil(boolean value) throws InterruptedException {
        while (this.b != value) {
            this.wait();
        }
    }

    public synchronized boolean waitUntil(boolean value, int timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (this.b != value) {
            long now = System.currentTimeMillis();
            long diff = now - start;
            long wait = (long)timeout - diff;
            if (wait <= 0L) {
                return false;
            }
            this.wait(wait);
        }
        return true;
    }

    public synchronized boolean getAndSet(boolean oldValue, boolean newValue) {
        if (this.b != oldValue) {
            return false;
        }
        this.setValue(newValue);
        return true;
    }
}

