/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import org.limewire.io.GUID;
import org.limewire.util.ByteUtils;

public class UDPCrawlerPing
extends AbstractVendorMessage {
    public static final int VERSION = 1;
    public static final int ALL = -1;
    private int _numberUP;
    private int _numberLeaves;
    private byte _format;
    public static final byte PLAIN = 0;
    public static final byte CONNECTION_TIME = 1;
    public static final byte LOCALE_INFO = 2;
    public static final byte NEW_ONLY = 4;
    public static final byte USER_AGENT = 8;
    public static final byte NODE_UPTIME = 16;
    public static final byte REPLIES = 32;
    public static final byte DHT_STATUS = 64;
    public static final byte FEATURE_MASK = 127;

    public UDPCrawlerPing(GUID guid, int numberUP, int numberLeaves, byte features) {
        super(F_LIME_VENDOR_ID, 5, 1, UDPCrawlerPing.derivePayload(numberUP, numberLeaves, features));
        this.setGUID(guid);
        this._numberUP = numberUP;
        this._numberLeaves = numberLeaves;
        this._format = (byte)(features & 0x7F);
    }

    public UDPCrawlerPing(GUID guid) {
        this(guid, -1, -1, 0);
    }

    private static byte[] derivePayload(int numberUP, int numberLeaves, byte features) {
        if (numberUP > 255) {
            numberUP = 255;
        }
        if (numberLeaves > 255) {
            numberLeaves = 255;
        }
        features = (byte)(features & 0x7F);
        byte[] temp = new byte[2];
        byte[] payload = new byte[3];
        ByteUtils.short2leb((short)numberUP, temp, 0);
        payload[0] = temp[0];
        ByteUtils.short2leb((short)numberLeaves, temp, 0);
        payload[1] = temp[0];
        payload[2] = features;
        return payload;
    }

    protected UDPCrawlerPing(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 5, version, payload, network);
        if (this.getVersion() == 1 && (payload == null || payload.length != 3)) {
            throw new BadPacketException();
        }
        this._numberUP = ByteUtils.ubyte2int(payload[0]);
        this._numberLeaves = ByteUtils.ubyte2int(payload[1]);
        this._format = payload[2];
        this._format = (byte)(this._format & 0x7F);
    }

    public int getNumberUP() {
        return this._numberUP;
    }

    public int getNumberLeaves() {
        return this._numberLeaves;
    }

    public boolean hasNodeUptime() {
        return (byte)(0x10 & this._format) == 16;
    }

    public boolean hasDHTStatus() {
        return (byte)(0x40 & this._format) == 64;
    }

    public boolean hasConnectionTime() {
        return (byte)(1 & this._format) == 1;
    }

    public boolean hasLocaleInfo() {
        return (byte)(2 & this._format) == 2;
    }

    public boolean hasNewOnly() {
        return (byte)(4 & this._format) == 4;
    }

    public boolean hasUserAgent() {
        return (byte)(8 & this._format) == 8;
    }

    public boolean hasReplies() {
        return this.hasFeature((byte)32);
    }

    public boolean hasFeature(byte featureId) {
        return (byte)(featureId & this._format) == featureId;
    }

    public byte getFormat() {
        return this._format;
    }
}

