# Locate FBX
# This module defines:
# FBX_INCLUDE_DIR, where to find the headers
#
# FBX_LIBRARY, FBX_LIBRARY_DEBUG
# FBX_FOUND
#
# $FBX_DIR is an environment variable that would
# correspond to the ./configure --prefix=$FBX_DIR

IF(WIN32)
SET(FBX_ROOT "$ENV{PROGRAMFILES}/Autodesk/FBX/FbxSdk/2010.2" CACHE PATH "Location of FBX SDK directory")
ELSE(WIN32)
SET(FBX_ROOT $ENV{FBX_DIR} CACHE PATH "Location of FBX SDK directory")
ENDIF(WIN32)

IF(APPLE)
    SET(FBX_LIBNAME "libfbxsdk_gcc4_ub")
ELSEIF(CMAKE_COMPILER_IS_GNUCXX)
    SET(FBX_LIBNAME "libfbxsdk_gcc4")#TODO: libs are provided for GCC 3.4 & 4.0 in both 32 and 64 bit versions, but I don't know how to confgure that here.
ELSEIF(MSVC71)
    SET(FBX_LIBNAME "fbxsdk_md2003")
ELSEIF(MSVC80)
    SET(FBX_LIBNAME "fbxsdk_md2005")
ELSEIF(MSVC90 OR MSVC_VER>1500)
    SET(FBX_LIBNAME "fbxsdk_md2008")
ENDIF(APPLE)

IF(CMAKE_CL_64)
    SET(FBX_LIBNAME ${FBX_LIBNAME}_amd64)
ENDIF(CMAKE_CL_64)

IF(APPLE)
SET(FBX_LIBNAME_DEBUG ${FBX_LIBNAME})
ELSE(APPLE)
SET(FBX_LIBNAME_DEBUG ${FBX_LIBNAME}d)
ENDIF(APPLE)

FIND_PATH(FBX_INCLUDE_DIR fbxsdk.h
    ${FBX_ROOT}/include
)

FIND_LIBRARY(FBX_LIBRARY ${FBX_LIBNAME} ${FBX_ROOT}/lib)

FIND_LIBRARY(FBX_LIBRARY_DEBUG ${FBX_LIBNAME_DEBUG} ${FBX_ROOT}/lib)

IF(FBX_LIBRARY AND FBX_LIBRARY_DEBUG AND FBX_INCLUDE_DIR)
    SET(FBX_FOUND "YES")
ELSE(FBX_LIBRARY AND FBX_LIBRARY_DEBUG AND FBX_INCLUDE_DIR)
    SET(FBX_FOUND "NO")
ENDIF(FBX_LIBRARY AND FBX_LIBRARY_DEBUG AND FBX_INCLUDE_DIR)
