/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.AdvancedToolbarLayout;
import org.xmind.ui.gallery.ShadowBorder;

public class ShadowedLayer
extends Layer {
    private double ratio = 0.0;
    private ShadowBorder shadowBorder;
    private boolean pressed = false;

    public ShadowedLayer() {
        this.setLayoutManager((LayoutManager)new AdvancedToolbarLayout(false));
        this.shadowBorder = new ShadowBorder();
        this.setBorder((Border)this.shadowBorder);
        this.setForegroundColor(ColorConstants.black);
        this.setBackgroundColor(ColorConstants.white);
        this.setOpaque(true);
    }

    public void togglePressed() {
        if (!this.isEnabled()) {
            return;
        }
        this.shadowBorder.reverseShadow();
        this.shadowBorder.setShadowVisible(!this.shadowBorder.isShadowVisible());
        this.pressed = !this.pressed;
        this.revalidate();
        this.repaint();
    }

    public void press() {
        if (!this.isEnabled() || this.isPressed()) {
            return;
        }
        this.shadowBorder.setHorizontalShadowDepth(-Math.abs(this.shadowBorder.getHorizontalShadowDepth()));
        this.shadowBorder.setVerticalShadowDepth(-Math.abs(this.shadowBorder.getVerticalShadowDepth()));
        this.shadowBorder.hideShadow();
        this.pressed = true;
        this.revalidate();
        this.repaint();
    }

    public void unpress() {
        if (!this.isEnabled() || !this.isPressed()) {
            return;
        }
        this.shadowBorder.setHorizontalShadowDepth(Math.abs(this.shadowBorder.getHorizontalShadowDepth()));
        this.shadowBorder.setVerticalShadowDepth(Math.abs(this.shadowBorder.getVerticalShadowDepth()));
        this.shadowBorder.showShadow();
        this.pressed = false;
        this.revalidate();
        this.repaint();
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        if (pressed) {
            this.press();
        } else {
            this.unpress();
        }
    }

    public ShadowBorder getShadowBorder() {
        return this.shadowBorder;
    }

    protected void paintFigure(Graphics graphics) {
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.fillRectangle(this.getClientArea());
        }
        super.paintClientArea(graphics);
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        if (ratio == this.ratio) {
            return;
        }
        this.ratio = ratio;
        this.revalidate();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = super.getPreferredSize(wHint, hHint);
        if (this.ratio > 0.0) {
            int width = wHint < 0 ? size.width : wHint;
            int height = (int)Math.ceil((double)width / this.ratio);
            size = new Dimension(width, height);
        } else if (this.ratio < 0.0) {
            int height = hHint < 0 ? size.height : hHint;
            int width = (int)Math.ceil((double)height * -this.ratio);
            size = new Dimension(width, height);
        }
        return size;
    }

    public Color getBorderColor() {
        return this.shadowBorder.getBorderColor();
    }

    public int getBorderWidth() {
        return this.shadowBorder.getBorderWidth();
    }

    public Dimension getShadowDepths() {
        return this.shadowBorder.getShadowDepths();
    }

    public int getHorizontalShadowDepth() {
        return this.shadowBorder.getHorizontalShadowDepth();
    }

    public int getShadowAlpha() {
        return this.shadowBorder.getShadowAlpha();
    }

    public int getBorderAlpha() {
        return this.shadowBorder.getBorderAlpha();
    }

    public Color getShadowColor() {
        return this.shadowBorder.getShadowColor();
    }

    public int getVerticalShadowDepth() {
        return this.shadowBorder.getVerticalShadowDepth();
    }

    public void hideShadow() {
        this.shadowBorder.hideShadow();
        this.revalidate();
        this.repaint();
    }

    public boolean isShadowVisible() {
        return this.shadowBorder.isShadowVisible();
    }

    public void setBorderColor(Color borderColor) {
        this.shadowBorder.setBorderColor(borderColor);
        this.repaint();
    }

    public void setBorderWidth(int lineWidth) {
        this.shadowBorder.setBorderWidth(lineWidth);
        this.revalidate();
        this.repaint();
    }

    public void setShadowDepths(int depth) {
        this.shadowBorder.setShadowDepths(depth);
        this.revalidate();
        this.repaint();
    }

    public void setShadowDepths(Dimension depths) {
        this.shadowBorder.setShadowDepths(depths);
        this.revalidate();
        this.repaint();
    }

    public void setHorizontalShadowDepth(int depth) {
        this.shadowBorder.setHorizontalShadowDepth(depth);
        this.revalidate();
        this.repaint();
    }

    public void setShadowAlpha(int shadowAlpha) {
        this.shadowBorder.setShadowAlpha(shadowAlpha);
        this.repaint();
    }

    public void setBorderAlpha(int borderAlpha) {
        this.shadowBorder.setBorderAlpha(borderAlpha);
        this.repaint();
    }

    public void setShadowColor(Color backColor) {
        this.shadowBorder.setShadowColor(backColor);
        this.repaint();
    }

    public void setShadowVisible(boolean visible) {
        this.shadowBorder.setShadowVisible(visible);
        this.revalidate();
        this.repaint();
    }

    public void setVerticalShadowDepth(int depth) {
        this.shadowBorder.setVerticalShadowDepth(depth);
        this.revalidate();
        this.repaint();
    }

    public void showShadow() {
        this.shadowBorder.showShadow();
        this.revalidate();
        this.repaint();
    }
}

