/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.xmind.gef.command.CommandStack;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ICommandStackListener;
import org.xmind.gef.ui.editor.IEditable;
import org.xmind.gef.ui.editor.IEditableCleaner;
import org.xmind.gef.ui.editor.IEditingContext;
import org.xmind.gef.ui.editor.IInteractiveMessage;

public abstract class Editable
implements IEditable {
    private URI uri;
    private int state;
    private long modificationTime = 0L;
    private int progress = 0;
    private ICommandStack commandStack = null;
    private IEditingContext activeContext = null;
    private final List<IEditableCleaner> cleaners = new ArrayList<IEditableCleaner>();
    private final ListenerList<IPropertyChangeListener> listenerManager = new ListenerList();
    private int contentRefCount = 0;
    private ICommandStackListener commandStackHook = new ICommandStackListener(){

        public void handleCommandStackEvent(CommandStackEvent event) {
            if ((event.getStatus() & 0x80) != 0) {
                boolean isDirty = Editable.this.isDirty();
                Editable.this.firePropertyChanged("dirty", false, isDirty);
            }
            Editable.this.doHandleCommandStackChange(event);
        }
    };
    private final List<IInteractiveMessage> messages = new ArrayList<IInteractiveMessage>();

    protected Editable(URI uri) {
        this.uri = uri;
        this.state = 1;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (URI.class.equals(adapter)) {
            return adapter.cast(this.getURI());
        }
        if (ICommandStack.class.equals(adapter)) {
            return adapter.cast(this.getCommandStack());
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getName() {
        String path;
        if (this.uri != null && (path = this.uri.getPath()) != null && path.length() > 0) {
            int sep;
            if (path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length() - 1);
            }
            if ((sep = path.lastIndexOf(47)) >= 0) {
                return path.substring(sep + 1);
            }
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public long getModificationTime() {
        return this.modificationTime;
    }

    protected void setModificationTime(long modificationTime) {
        long oldModificationTime = this.modificationTime;
        if (modificationTime == oldModificationTime) {
            return;
        }
        this.modificationTime = modificationTime;
        this.firePropertyChanged("modificationTime", oldModificationTime, modificationTime);
    }

    @Override
    public synchronized int getState() {
        return this.state;
    }

    @Override
    public boolean isInState(int state) {
        return (this.getState() & state) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int newState) {
        int oldState;
        Editable editable = this;
        synchronized (editable) {
            oldState = this.state;
            if (newState == oldState) {
                return;
            }
            this.state = newState;
        }
        this.firePropertyChanged("state", oldState, newState);
    }

    protected void modifyState(int stateToAdd, int stateToRemove) {
        int newState = this.getState();
        if (stateToAdd != 0) {
            newState |= stateToAdd;
        }
        if (stateToRemove != 0) {
            newState &= ~stateToRemove;
        }
        this.setState(newState);
    }

    protected void addState(int state) {
        this.setState(this.getState() | state);
    }

    protected void removeState(int state) {
        this.setState(this.getState() & ~state);
    }

    @Override
    public synchronized int getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProgress(int newProgress) {
        int oldProgress;
        Editable editable = this;
        synchronized (editable) {
            oldProgress = this.progress;
            if (newProgress == oldProgress) {
                return;
            }
            this.progress = newProgress;
        }
        this.firePropertyChanged("progress", oldProgress, newProgress);
    }

    protected void addProgress(int delta) {
        this.setProgress(this.getProgress() + delta);
    }

    protected void removeProgress(int delta) {
        this.setProgress(this.getProgress() - delta);
    }

    @Override
    public ICommandStack getCommandStack() {
        if (this.commandStack == null) {
            this.setCommandStack(this.createDefaultCommandStack());
        }
        return this.commandStack;
    }

    protected ICommandStack createDefaultCommandStack() {
        return new CommandStack();
    }

    protected void setCommandStack(ICommandStack commandStack) {
        ICommandStack oldCommandStack = this.commandStack;
        if (oldCommandStack == commandStack) {
            return;
        }
        if (oldCommandStack != null) {
            oldCommandStack.removeCSListener(this.commandStackHook);
            oldCommandStack.dispose();
        }
        this.commandStack = commandStack;
        if (commandStack != null) {
            commandStack.addCSListener(this.commandStackHook);
        }
        this.firePropertyChanged("commandStack", oldCommandStack, commandStack);
    }

    @Override
    public IEditingContext getActiveContext() {
        IEditingContext context = this.activeContext;
        return context == null ? IEditingContext.NULL : context;
    }

    protected <T> T getService(Class<T> serviceType) {
        return (T)this.getActiveContext().getAdapter(serviceType);
    }

    @Override
    public void setActiveContext(IEditingContext context) {
        IEditingContext oldContext = this.activeContext;
        if (oldContext == context) {
            return;
        }
        this.activeContext = context;
        this.firePropertyChanged("activeContext", oldContext, context);
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.commandStack != null && this.commandStack.isDirty() || !this.cleaners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDirtyWith(IEditableCleaner cleaner) {
        boolean wasDirty = this.isDirty();
        List<IEditableCleaner> list = this.cleaners;
        synchronized (list) {
            this.cleaners.add(cleaner);
        }
        boolean isDirty = this.isDirty();
        if (wasDirty != isDirty) {
            this.firePropertyChanged("dirty", wasDirty, isDirty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmarkDirtyWith(IEditableCleaner cleaner) {
        boolean wasDirty = this.isDirty();
        List<IEditableCleaner> list = this.cleaners;
        synchronized (list) {
            this.cleaners.remove(cleaner);
        }
        boolean isDirty = this.isDirty();
        if (wasDirty != isDirty) {
            this.firePropertyChanged("dirty", wasDirty, isDirty);
        }
    }

    @Override
    public void discardChanges() {
        boolean wasDirty = this.isDirty();
        this.doDiscardChanges();
        boolean isDirty = this.isDirty();
        if (wasDirty != isDirty) {
            this.firePropertyChanged("dirty", wasDirty, isDirty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDiscardChanges() {
        if (this.commandStack != null) {
            while (this.commandStack.isDirty() && this.commandStack.canUndo()) {
                this.commandStack.markSaved();
            }
        }
        List<IEditableCleaner> list = this.cleaners;
        synchronized (list) {
            this.cleaners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        IEditableCleaner[] theCleaners = new IEditableCleaner[]{};
        List<IEditableCleaner> list = this.cleaners;
        synchronized (list) {
            theCleaners = this.cleaners.toArray(theCleaners);
            this.cleaners.clear();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)theCleaners.length);
        int i = 0;
        while (i < theCleaners.length) {
            IEditableCleaner cleaner = theCleaners[i];
            this.doClean((IProgressMonitor)subMonitor.newChild(1), cleaner);
            ++i;
        }
    }

    protected void doClean(IProgressMonitor monitor, IEditableCleaner cleaner) throws InterruptedException, InvocationTargetException {
        cleaner.cleanEditable(monitor, this);
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerManager.add((Object)listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerManager.remove((Object)listener);
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
        Object[] objectArray = this.listenerManager.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IPropertyChangeListener) {
                try {
                    ((IPropertyChangeListener)o).propertyChange(event);
                }
                catch (Exception e) {
                    this.handlePropertyChangeNotificationError(e);
                }
            }
            ++n2;
        }
    }

    private void handlePropertyChangeNotificationError(Exception e) {
    }

    @Override
    public void open(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        if (!this.isInState(1)) {
            ++this.contentRefCount;
            return;
        }
        if (this.isInState(56)) {
            throw new IllegalStateException("Concurrent open/close/save operations are not allowed");
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.newChild(10);
            this.addState(8);
            try {
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                this.doOpen((IProgressMonitor)subMonitor.newChild(80));
                subMonitor.newChild(5);
                ++this.contentRefCount;
                if (this.isInState(1)) {
                    this.removeState(1);
                }
            }
            finally {
                subMonitor.setWorkRemaining(5);
                subMonitor.newChild(5);
                this.removeState(8);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
    }

    protected void doOpen(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public void save(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        if (!this.canSave()) {
            throw new IllegalStateException("Save operation is not allowed");
        }
        if (this.isInState(1)) {
            throw new IllegalStateException("Can't perform save operation while editable is closed");
        }
        if (this.isInState(56)) {
            throw new IllegalStateException("Concurrent open/close/save operations are not allowed in SynchronizedEditable");
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.newChild(5);
            this.addState(16);
            try {
                boolean wasDirty = this.isDirty();
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                this.clean((IProgressMonitor)subMonitor.newChild(5));
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.doSave((IProgressMonitor)subMonitor.newChild(80));
                this.markSaved((IProgressMonitor)subMonitor.newChild(5));
                subMonitor.newChild(4);
                boolean isDirty = this.isDirty();
                if (wasDirty != isDirty) {
                    this.firePropertyChanged("dirty", wasDirty, isDirty);
                }
            }
            finally {
                subMonitor.setWorkRemaining(1);
                subMonitor.newChild(1);
                this.removeState(16);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
    }

    protected void doSave(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    protected void markSaved(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        ICommandStack commandStack = this.getCommandStack();
        if (commandStack != null) {
            commandStack.markSaved();
        }
    }

    @Override
    public void close(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        if (this.isInState(1)) {
            return;
        }
        if (this.isInState(56)) {
            throw new IllegalStateException("Concurrent open/close/save operations are not allowed in SynchronizedEditable");
        }
        if (this.contentRefCount > 1) {
            --this.contentRefCount;
            return;
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (this.isDirty() && this.canSave()) {
                this.doSave((IProgressMonitor)subMonitor.newChild(70));
            }
            if (subMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            subMonitor.setWorkRemaining(30);
            if (this.commandStack != null) {
                this.commandStack.clear();
            }
            subMonitor.newChild(5);
            --this.contentRefCount;
            this.addState(1);
            try {
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                this.doClose((IProgressMonitor)subMonitor.newChild(20));
                if (!this.isInState(1)) {
                    this.addState(1);
                }
            }
            finally {
                subMonitor.setWorkRemaining(5);
                subMonitor.newChild(5);
                this.removeState(32);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
    }

    protected void doClose(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
    }

    @Override
    public List<IInteractiveMessage> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    @Override
    public void addMessage(IInteractiveMessage message) {
        ArrayList<IInteractiveMessage> oldMessages = new ArrayList<IInteractiveMessage>(this.messages);
        if (this.messages.add(message)) {
            this.firePropertyChanged("messages", oldMessages, new ArrayList<IInteractiveMessage>(this.messages));
        }
    }

    @Override
    public void removeMessage(IInteractiveMessage message) {
        ArrayList<IInteractiveMessage> oldMessages = new ArrayList<IInteractiveMessage>(this.messages);
        if (this.messages.remove(message)) {
            this.firePropertyChanged("messages", oldMessages, new ArrayList<IInteractiveMessage>(this.messages));
        }
    }

    protected void doHandleCommandStackChange(CommandStackEvent event) {
    }
}

