/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmind.core.Core;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IEntryStreamNormalizer;
import org.xmind.core.IFileEntry;
import org.xmind.core.IFileEntryFilter;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.internal.Manifest;
import org.xmind.core.internal.dom.FileEntryImpl;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestImpl
extends Manifest
implements ICoreEventSource {
    private Document implementation;
    private IStorage storage;
    private WorkbookImpl ownedWorkbook;
    private final Map<String, IFileEntry> entries;
    private IEntryStreamNormalizer normalizer;
    private CoreEventSupport coreEventSupport;

    public ManifestImpl(Document implementation, IStorage storage) {
        this.implementation = implementation;
        this.storage = storage == null ? new ByteArrayStorage() : storage;
        this.normalizer = IEntryStreamNormalizer.NULL;
        this.ownedWorkbook = null;
        this.entries = new HashMap<String, IFileEntry>();
        this.init();
    }

    private void init() {
        Element m = DOMUtils.ensureChildElement(this.implementation, "manifest");
        NS.setNS(NS.Manifest, m, new NS[0]);
        Iterator<IFileEntry> it = this.iterFileEntries();
        while (it.hasNext()) {
            it.next();
        }
        IFileEntry metaEntry = this.createFileEntry("META-INF/manifest.xml", "text/xml");
        this.insertFileEntryImpl(metaEntry.getAdapter(Element.class));
    }

    public Document getImplementation() {
        return this.implementation;
    }

    public Element getManifestElement() {
        return this.implementation.getDocumentElement();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(Document.class)) {
            return adapter.cast(this.implementation);
        }
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.ownedWorkbook);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return this.ownedWorkbook == null;
    }

    protected void setWorkbook(WorkbookImpl workbook) {
        this.ownedWorkbook = workbook;
        if (workbook != null) {
            this.getCoreEventSupport().setParent(workbook.getCoreEventSupport());
        }
    }

    protected void setStorage(IStorage storage) {
        this.storage = storage == null ? new ByteArrayStorage() : storage;
    }

    protected IStorage getStorage() {
        return this.storage;
    }

    public void setStreamNormalizer(IEntryStreamNormalizer normalizer) {
        this.normalizer = normalizer == null ? IEntryStreamNormalizer.NULL : normalizer;
    }

    protected IEntryStreamNormalizer getStreamNormalizer() {
        return this.normalizer;
    }

    protected Collection<IFileEntry> getAllRegisteredEntries() {
        return this.entries.values();
    }

    @Override
    public Iterator<IFileEntry> iterFileEntries() {
        return this.iterFileEntries(null);
    }

    @Override
    public Iterator<IFileEntry> iterFileEntries(final IFileEntryFilter filter) {
        final Iterator<Element> it = DOMUtils.childElementIterByTag(this.getManifestElement(), "file-entry");
        return new Iterator<IFileEntry>(){
            IFileEntry next = this.findNext();

            private IFileEntry findNext() {
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    if (!e.hasAttribute("full-path") || !this.select(e)) continue;
                    return ManifestImpl.this.getFileEntry(e);
                }
                return null;
            }

            private boolean select(Element e) {
                if (filter == null) {
                    return true;
                }
                String path = e.getAttribute("full-path");
                String mediaType = e.getAttribute("media-type");
                boolean isDirectory = path.endsWith("/");
                return filter.select(path, mediaType, isDirectory);
            }

            @Override
            public void remove() {
            }

            @Override
            public IFileEntry next() {
                IFileEntry n = this.next;
                this.next = this.findNext();
                return n;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }
        };
    }

    @Override
    public IFileEntry getFileEntry(String path) {
        if (path == null) {
            return null;
        }
        IFileEntry entry = this.findEntry(path);
        if (entry == null) {
            while (path.startsWith("/")) {
                entry = this.findEntry(path = path.substring(1, path.length()));
                if (entry != null) break;
            }
        }
        if (entry == null) {
            entry = this.findEntry("/" + path);
        }
        return entry;
    }

    private IFileEntry findEntry(String path) {
        Element e;
        IFileEntry entry = this.entries.get(path);
        if (entry == null && (e = this.findEntryElementByPath(path)) != null) {
            entry = this.createFileEntry(path, e);
        }
        return entry;
    }

    private Element findEntryElementByPath(String path) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getManifestElement(), "file-entry");
        while (it.hasNext()) {
            Element e = it.next();
            if (!path.equals(e.getAttribute("full-path"))) continue;
            return e;
        }
        return null;
    }

    @Override
    public IFileEntry createFileEntry(String path) {
        return this.createFileEntry(path, "");
    }

    @Override
    public IFileEntry createFileEntry(String path, String mediaType) {
        IFileEntry entry = this.getFileEntry(path);
        if (entry != null) {
            return entry;
        }
        String parent = InternalDOMUtils.getParentPath(path);
        if (parent != null) {
            IFileEntry parentFileEntry = this.createFileEntry(parent);
            this.insertFileEntryImpl(parentFileEntry.getAdapter(Element.class));
        }
        Element e = this.implementation.createElement("file-entry");
        e.setAttribute("full-path", path);
        e.setAttribute("media-type", mediaType);
        return this.createFileEntry(path, e);
    }

    private IFileEntry createFileEntry(String path, Element entryElement) {
        FileEntryImpl entry = new FileEntryImpl(entryElement, this);
        this.entries.put(path, entry);
        return entry;
    }

    private IFileEntry getFileEntry(Element element) {
        String path = element.getAttribute("full-path");
        IFileEntry entry = this.entries.get(path);
        if (entry != null) {
            return entry;
        }
        return this.createFileEntry(path, element);
    }

    protected void insertFileEntry(IFileEntry entry) {
        Element e = entry.getAdapter(Element.class);
        if (e != null) {
            this.insertFileEntryImpl(e);
        }
        this.getCoreEventSupport().dispatchTargetChange(this, "fileEntryAdd", entry);
    }

    protected void removeFileEntry(IFileEntry entry) {
        Element m;
        Element e = entry.getAdapter(Element.class);
        if (e != null && (m = this.getManifestElement()) == e.getParentNode()) {
            m.removeChild(e);
        }
        this.getCoreEventSupport().dispatchTargetChange(this, "fileEntryRemove", entry);
    }

    private void insertFileEntryImpl(Element entryElement) {
        Element e = this.findInsertLocation(entryElement);
        if (e != null) {
            this.getManifestElement().insertBefore(entryElement, e);
        } else {
            this.getManifestElement().appendChild(entryElement);
        }
    }

    private Element findInsertLocation(Element entryElement) {
        if (entryElement.hasAttribute("full-path")) {
            return this.findInsertLocation(entryElement, entryElement.getAttribute("full-path"));
        }
        return null;
    }

    private Element findInsertLocation(Element entryElement, String path) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getManifestElement(), "file-entry");
        while (it.hasNext()) {
            String p;
            Element e = it.next();
            if (e == entryElement || !e.hasAttribute("full-path") || (p = e.getAttribute("full-path")) == null || path.compareToIgnoreCase(p) >= 0) continue;
            return e;
        }
        return null;
    }

    @Override
    public IFileEntry createAttachmentFromFilePath(String sourcePath) throws IOException {
        return this.createAttachmentFromFilePath(sourcePath, null);
    }

    @Override
    public IFileEntry createAttachmentFromFilePath(String sourcePath, String mediaType) throws IOException {
        if (sourcePath == null) {
            throw new IllegalArgumentException("Path is null!");
        }
        File file = new File(sourcePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Source path does not exists.");
        }
        if (file.isFile()) {
            IFileEntry entry = this.createAttachmentFromStream(new FileInputStream(sourcePath), sourcePath, mediaType);
            if (entry != null) {
                entry.setTime(file.lastModified());
            }
            return entry;
        }
        if (file.isDirectory()) {
            IFileEntry root;
            String fileName = file.getName();
            String path = this.makeAttachmentPath(fileName, true);
            if (mediaType == null) {
                mediaType = FileUtils.getMediaType(fileName);
            }
            if ((root = this.createFileEntry(path, mediaType)) != null) {
                this.importDirectory(path, file);
            }
            return root;
        }
        throw new IllegalArgumentException("Unknown file type (neither a file nor a directory)");
    }

    protected void importDirectory(String parentPath, File dir) throws IOException {
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            String sub = stringArray[n2];
            File f = new File(dir, sub);
            if (f.isFile()) {
                String mediaType;
                path = parentPath == null ? sub : String.valueOf(parentPath) + sub;
                IFileEntry e = this.createFileEntry(path, mediaType = FileUtils.getMediaType(sub));
                if (e != null) {
                    e.setTime(f.lastModified());
                    OutputStream os = e.openOutputStream();
                    try {
                        FileInputStream is = new FileInputStream(f);
                        try {
                            FileUtils.transfer(is, os);
                        }
                        finally {
                            is.close();
                        }
                    }
                    finally {
                        os.close();
                    }
                }
            } else if (f.isDirectory()) {
                path = parentPath == null ? String.valueOf(sub) + "/" : String.valueOf(parentPath) + sub + "/";
                this.importDirectory(path, f);
            }
            ++n2;
        }
    }

    @Override
    public IFileEntry createAttachmentFromStream(InputStream stream, String sourceName) throws IOException {
        return this.createAttachmentFromStream(stream, sourceName, null);
    }

    @Override
    public IFileEntry createAttachmentFromStream(InputStream stream, String sourceName, String mediaType) throws IOException {
        IFileEntry entry;
        if (sourceName == null || stream == null) {
            return null;
        }
        String path = this.makeAttachmentPath(sourceName, false);
        if (mediaType == null) {
            mediaType = FileUtils.getMediaType(sourceName);
        }
        if ((entry = this.createFileEntry(path, mediaType)) != null) {
            OutputStream os = entry.openOutputStream();
            try {
                FileUtils.transfer(stream, os);
            }
            finally {
                os.close();
            }
        }
        return entry;
    }

    @Override
    public IFileEntry cloneEntry(IFileEntry sourceEntry, String targetPath) throws IOException {
        if (sourceEntry == null || targetPath == null) {
            return null;
        }
        IFileEntry existingEntry = this.getFileEntry(targetPath);
        if (existingEntry != null) {
            return null;
        }
        if (sourceEntry.isDirectory()) {
            if (!targetPath.endsWith("/")) {
                targetPath = String.valueOf(targetPath) + "/";
            }
            this.importDirectoryEntry(targetPath, sourceEntry);
        } else {
            this.importFileEntry(targetPath, sourceEntry);
        }
        return this.getFileEntry(targetPath);
    }

    private void importFileEntry(String path, IFileEntry sourceEntry) throws IOException {
        InputStream is = sourceEntry.openInputStream();
        try {
            IFileEntry entry = this.createFileEntry(path, sourceEntry.getMediaType());
            entry.setTime(sourceEntry.getTime());
            OutputStream os = entry.openOutputStream();
            try {
                FileUtils.transfer(is, os);
            }
            finally {
                os.close();
            }
        }
        finally {
            is.close();
        }
    }

    private void importDirectoryEntry(String parentPath, IFileEntry sourceEntry) throws IOException {
        String sourceParentPath = InternalDOMUtils.getParentPath(sourceEntry.getPath());
        for (IFileEntry sourceSubEntry : sourceEntry.getSubEntries()) {
            String sourceSubPath = sourceSubEntry.getPath();
            if (sourceSubPath == null) continue;
            String subPath = sourceSubPath.substring(sourceParentPath.length());
            if (parentPath != null) {
                subPath = String.valueOf(parentPath) + subPath;
            }
            if (sourceSubEntry.isDirectory()) continue;
            this.importFileEntry(subPath, sourceSubEntry);
        }
        if (this.getFileEntry(parentPath) == null) {
            this.createFileEntry(parentPath, sourceEntry.getMediaType());
        }
    }

    @Override
    public IFileEntry cloneEntryAsAttachment(IFileEntry sourceEntry) throws IOException {
        String sourcePath = sourceEntry.getPath();
        String path = this.makeAttachmentPath(sourcePath, sourceEntry.isDirectory());
        IFileEntry cloneEntry = this.cloneEntry(sourceEntry, path);
        return cloneEntry;
    }

    @Override
    public String makeAttachmentPath(String source) {
        return this.makeAttachmentPath(source, false);
    }

    @Override
    public String makeAttachmentPath(String source, boolean directory) {
        String path = "attachments/" + Core.getIdFactory().createId() + FileUtils.getExtension(source);
        if (directory) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    @Override
    public IEncryptionData getEncryptionData(String entryPath) {
        IFileEntry entry = this.getFileEntry(entryPath);
        if (entry != null) {
            return entry.getEncryptionData();
        }
        return null;
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.ownedWorkbook.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    @Override
    public CoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport != null) {
            return this.coreEventSupport;
        }
        this.coreEventSupport = new CoreEventSupport();
        return this.coreEventSupport;
    }

    @Override
    public String getPasswordHint() {
        Element m = DOMUtils.ensureChildElement(this.implementation, "manifest");
        return m.getAttribute("password-hint");
    }

    @Override
    public void setPasswordHint(String hint) {
        Element m = DOMUtils.ensureChildElement(this.implementation, "manifest");
        m.setAttribute("password-hint", hint);
    }
}

