/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.remote;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.xmind.core.command.remote.ICommandServiceDomain;
import org.xmind.core.command.remote.ICommandServiceInfo;
import org.xmind.core.command.remote.IRemoteCommandService;
import org.xmind.core.command.remote.IRemoteCommandServiceDiscoverer;
import org.xmind.core.command.remote.IRemoteCommandServiceListener;
import org.xmind.core.internal.command.remote.RemoteCommandPlugin;

public abstract class AbstractRemoteCommandServiceDiscoverer
implements IRemoteCommandServiceDiscoverer {
    private ICommandServiceDomain domain;
    private Map<String, IRemoteCommandService> cache = new HashMap<String, IRemoteCommandService>();
    private Object cacheLock = new Object();
    private ListenerList listeners = new ListenerList();

    public void init(ICommandServiceDomain domain) {
        this.domain = domain;
    }

    public ICommandServiceDomain getDomain() {
        return this.domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteCommandService[] getRemoteCommandServices() {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.cache.values().toArray(new IRemoteCommandService[this.cache.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteCommandService findRemoteCommandService(String serviceName) {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.cache.get(serviceName);
        }
    }

    public void addRemoteCommandServiceListener(IRemoteCommandServiceListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeRemoteCommandServiceListener(IRemoteCommandServiceListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteCommandServiceDiscovered(IRemoteCommandService service) {
        IRemoteCommandService serviceRemovedById = null;
        Object object = this.cacheLock;
        synchronized (object) {
            ICommandServiceInfo info = service.getInfo();
            String serviceName = info.getId().getName();
            serviceRemovedById = this.cache.remove(serviceName);
            this.cache.put(serviceName, service);
        }
        object = this.listeners;
        synchronized (object) {
            if (serviceRemovedById != null) {
                this.fireRemoteCommandServiceDropped(serviceRemovedById);
            }
            this.fireRemoteCommandServiceDiscovered(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteCommandServiceDropped(IRemoteCommandService service) {
        IRemoteCommandService serviceRemovedById = null;
        Object object = this.cacheLock;
        synchronized (object) {
            ICommandServiceInfo info = service.getInfo();
            String serviceName = info.getId().getName();
            serviceRemovedById = this.cache.remove(serviceName);
        }
        object = this.listeners;
        synchronized (object) {
            if (serviceRemovedById != null) {
                this.fireRemoteCommandServiceDropped(serviceRemovedById);
            }
        }
    }

    protected void fireRemoteCommandServiceDiscovered(final IRemoteCommandService service) {
        Object[] theListeners = this.listeners.getListeners();
        int i = 0;
        while (i < theListeners.length) {
            final IRemoteCommandServiceListener listener = (IRemoteCommandServiceListener)theListeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.remoteCommandServiceDiscovered(service);
                }

                public void handleException(Throwable exception) {
                    RemoteCommandPlugin.log(null, exception);
                }
            });
            ++i;
        }
    }

    protected void fireRemoteCommandServiceDropped(final IRemoteCommandService service) {
        Object[] theListeners = this.listeners.getListeners();
        int i = 0;
        while (i < theListeners.length) {
            final IRemoteCommandServiceListener listener = (IRemoteCommandServiceListener)theListeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.remoteCommandServiceDropped(service);
                }

                public void handleException(Throwable exception) {
                    RemoteCommandPlugin.log(null, exception);
                }
            });
            ++i;
        }
    }
}

