/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.search.web;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.xmind.ui.browser.IBrowserViewer;
import org.xmind.ui.browser.IBrowserViewerContainer;
import org.xmind.ui.browser.IBrowserViewerContribution;
import org.xmind.ui.internal.search.web.SearchEnginePref;
import org.xmind.ui.search.ISearchEngineDescriptor;
import org.xmind.ui.search.SearchEngine;

public class SearchBoxContribution
implements IBrowserViewerContribution {
    public void fillToolBar(IBrowserViewer viewer, IContributionManager toolBar) {
        toolBar.add((IContributionItem)new SearchBox(viewer));
    }

    private static class SearchBox
    extends ContributionItem {
        private IBrowserViewer viewer;
        private Combo combo;
        private int arrowButtonWidth;
        private MenuManager enginesMenu;

        public SearchBox(IBrowserViewer viewer) {
            this.viewer = viewer;
        }

        public void fill(Composite parent) {
            this.combo = new Combo(parent, 2052);
            this.combo.setVisibleItemCount(0);
            this.combo.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    SearchBox.this.handleMouseDown(event);
                }
            });
            this.combo.addListener(14, new Listener(){

                public void handleEvent(Event event) {
                    SearchBox.this.search();
                }
            });
            GridData gridData = new GridData(4, 4, false, false);
            gridData.widthHint = 80;
            this.combo.setLayoutData((Object)gridData);
            if (Util.isWindows()) {
                this.arrowButtonWidth = 19;
            } else if (Util.isMac()) {
                this.arrowButtonWidth = 25;
            } else if (Util.isLinux()) {
                this.arrowButtonWidth = 25;
            }
        }

        private boolean isTextAreaClick(Event event) {
            Point size = this.combo.getSize();
            Rectangle rect = new Rectangle(0, 0, size.x - this.arrowButtonWidth, size.y);
            return this.isInside(event.x, event.y, rect);
        }

        private boolean isInside(int x, int y, Rectangle rect) {
            if (rect == null) {
                return false;
            }
            return x >= rect.x && y >= rect.y && x <= rect.x + rect.width && y <= rect.y + rect.height;
        }

        private void handleMouseDown(Event event) {
            if (!this.isTextAreaClick(event)) {
                event.doit = false;
                this.showSearchEngines();
            }
        }

        private void showSearchEngines() {
            if (this.enginesMenu == null) {
                this.enginesMenu = this.createEnginesMenu();
                this.enginesMenu.createContextMenu((Control)this.combo);
            }
            Menu menu = this.enginesMenu.getMenu();
            menu.setLocation(this.combo.toDisplay(0, this.combo.getSize().y));
            menu.setVisible(true);
        }

        private MenuManager createEnginesMenu() {
            MenuManager menu = new MenuManager();
            menu.setRemoveAllWhenShown(true);
            menu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    SearchBox.this.fillSearchEngines(manager);
                }
            });
            return menu;
        }

        private void fillSearchEngines(IMenuManager menu) {
            for (ISearchEngineDescriptor descriptor : SearchEngine.getDefault().getVisibleEngines()) {
                menu.add((IContributionItem)new SingleCheckActionItem((IAction)new SearchEngineAction(descriptor)));
            }
        }

        private void search() {
            String clientId = this.getBrowserClientId();
            SearchEngine.getDefault().search(SearchEnginePref.getDefaultEngineId(), clientId, this.combo.getText());
        }

        private String getBrowserClientId() {
            IBrowserViewerContainer container = this.viewer.getContainer();
            if (container != null) {
                return container.getClientId();
            }
            return null;
        }
    }

    private static class SearchEngineAction
    extends Action {
        private ISearchEngineDescriptor descriptor;

        public SearchEngineAction(ISearchEngineDescriptor descriptor) {
            super(descriptor.getShortName(), 2);
            this.descriptor = descriptor;
            this.setId("#" + descriptor.getId());
            this.setImageDescriptor(descriptor.getIcon());
            this.setChecked(descriptor.getId().equals(SearchEnginePref.getDefaultEngineId()));
        }

        public void run() {
            SearchEnginePref.getPrefStore().setValue("defaultEngine", this.descriptor.getId());
        }
    }

    private static class SingleCheckActionItem
    extends ActionContributionItem {
        private IAction action;

        public SingleCheckActionItem(IAction action) {
            super(action);
            this.action = action;
        }

        public void fill(Menu parent, int index) {
            super.fill(parent, index);
            if (this.action.isChecked() && this.getWidget() instanceof MenuItem) {
                parent.setDefaultItem((MenuItem)this.getWidget());
            }
        }
    }
}

