/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.service.AbstractFeedback;
import org.xmind.gef.service.IBendPointsFeedback;
import org.xmind.gef.service.IRectangleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBendPointsFeedback
extends AbstractFeedback
implements IBendPointsFeedback {
    public static final int[] ALL_ORIENTATIONS = new int[]{20, 12, 9, 17, 16, 8, 4, 1};
    private Map<Integer, IReferencedFigure> figures = null;
    private Rectangle bounds = null;
    private IRectangleProvider boundsProvider = null;
    private int hidePointLength = 0;
    private int[] orientations = null;

    @Override
    public void addToLayer(IFigure layer) {
        if (this.figures == null) {
            this.figures = this.createFigures();
        }
        for (IFigure iFigure : this.figures.values()) {
            layer.add(iFigure);
        }
    }

    private Map<Integer, IReferencedFigure> createFigures() {
        HashMap<Integer, IReferencedFigure> map = new HashMap<Integer, IReferencedFigure>(ALL_ORIENTATIONS.length);
        int[] nArray = ALL_ORIENTATIONS;
        int n = ALL_ORIENTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            int orientation = nArray[n2];
            map.put(orientation, this.createPointFigure(orientation));
            ++n2;
        }
        return map;
    }

    protected abstract IReferencedFigure createPointFigure(int var1);

    @Override
    public boolean containsPoint(Point point) {
        if (this.figures != null && this.bounds != null) {
            if (this.getZoomManager() != null) {
                point = this.getZoomManager().getScaled(point);
            }
            for (IFigure iFigure : this.figures.values()) {
                if (!iFigure.containsPoint(point) || !iFigure.isVisible() || iFigure.getParent() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeFromLayer(IFigure layer) {
        if (this.figures != null) {
            for (IFigure iFigure : this.figures.values()) {
                layer.remove(iFigure);
            }
        }
    }

    @Override
    public void update() {
        int n;
        Rectangle r;
        if (this.figures == null) {
            return;
        }
        if (this.boundsProvider != null && (r = this.boundsProvider.getRectangle()) != null) {
            this.setBounds(r);
        }
        if (this.bounds != null) {
            Rectangle scaledBounds = this.bounds;
            if (this.getZoomManager() != null) {
                scaledBounds = this.getZoomManager().getScaled(scaledBounds);
            }
            int[] nArray = ALL_ORIENTATIONS;
            int n2 = ALL_ORIENTATIONS.length;
            n = 0;
            while (n < n2) {
                int orientation = nArray[n];
                IReferencedFigure fig = this.figures.get(orientation);
                if (fig != null) {
                    Point p = this.calcPointPosition(fig, orientation, scaledBounds);
                    this.preUpdatePointFigure(fig, orientation, scaledBounds, p);
                    fig.setReference(p);
                    fig.setVisible(this.isPointVisible(fig, orientation, scaledBounds));
                }
                ++n;
            }
            this.updateWithBounds(scaledBounds);
        }
        int[] nArray = ALL_ORIENTATIONS;
        n = ALL_ORIENTATIONS.length;
        int n3 = 0;
        while (n3 < n) {
            int orientation = nArray[n3];
            IReferencedFigure fig = this.figures.get(orientation);
            if (fig != null) {
                this.updatePointFigure(fig, orientation);
            }
            ++n3;
        }
    }

    protected void updateWithBounds(Rectangle clientBounds) {
    }

    protected void preUpdatePointFigure(IReferencedFigure figure, int orientation, Rectangle bounds, Point preferredPosition) {
    }

    protected abstract void updatePointFigure(IReferencedFigure var1, int var2);

    protected boolean isPointVisible(IReferencedFigure figure, int orientation, Rectangle box) {
        int[] nArray = this.getOrientations();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int o = nArray[n2];
            if (o == orientation) {
                int length = this.getLength(orientation, box);
                return length < 0 || length >= this.hidePointLength;
            }
            ++n2;
        }
        return false;
    }

    protected int getLength(int orientation, Rectangle box) {
        if (orientation == 16 || orientation == 8) {
            return box.height;
        }
        if (orientation == 1 || orientation == 4) {
            return box.width;
        }
        return -1;
    }

    protected Point calcPointPosition(IReferencedFigure figure, int orientation, Rectangle box) {
        return Geometry.getLocation(orientation, box, true, 1, 0);
    }

    @Override
    public int getOrientation(Point point) {
        if (this.figures != null && this.bounds != null) {
            if (this.getZoomManager() != null) {
                point = this.getZoomManager().getScaled(point);
            }
            int[] nArray = ALL_ORIENTATIONS;
            int n = ALL_ORIENTATIONS.length;
            int n2 = 0;
            while (n2 < n) {
                int orientation = nArray[n2];
                IFigure f = this.figures.get(orientation);
                if (f.containsPoint(point) && f.isVisible() && f.getParent() != null) {
                    return orientation;
                }
                ++n2;
            }
        }
        return 0;
    }

    public int[] getOrientations() {
        if (this.orientations == null) {
            return ALL_ORIENTATIONS;
        }
        return this.orientations;
    }

    public void setOrientations(int[] orientations) {
        this.orientations = orientations;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public int getHidePointLength() {
        return this.hidePointLength;
    }

    public void setHidePointLength(int hidePointLength) {
        this.hidePointLength = hidePointLength;
    }

    @Override
    public IRectangleProvider getBoundsProvider() {
        return this.boundsProvider;
    }

    @Override
    public void setBoundsProvider(IRectangleProvider boundsProvider) {
        this.boundsProvider = boundsProvider;
    }
}

