/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.ui.internal.xmindresource.Messages;
import org.xmind.ui.internal.xmindresource.XMindProResourcePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipArtResourcePage
extends XMindProResourcePage {
    private ClipArtPageViewer viewer;

    @Override
    protected void createViewer(Composite parent) {
        ArrayList items = new ArrayList();
        List userGroups = GalleryCore.getInstance().getUserGalleryGroups();
        if (userGroups != null && !userGroups.isEmpty()) {
            for (IGalleryGroup group : userGroups) {
                List itemInOneGroup = group.getItems();
                if (itemInOneGroup == null) continue;
                items.addAll(itemInOneGroup);
            }
        }
        if (!items.isEmpty()) {
            Composite container = this.createViewerContainer(parent);
            container.setLayout((Layout)new FillLayout());
            final ScrolledComposite sc = new ScrolledComposite(container, 768);
            sc.setLayout((Layout)new FillLayout());
            final Composite c = new Composite((Composite)sc, 0);
            c.setLayoutData((Object)new GridData(1808));
            c.setLayout((Layout)new GridLayout());
            this.viewer = new ClipArtPageViewer(c);
            this.viewer.setInput(userGroups);
            ArrayList<Object> allItems = new ArrayList<Object>();
            allItems.addAll(userGroups);
            this.setAllItems(allItems);
            sc.setContent((Control)c);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            sc.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = sc.getClientArea();
                    sc.setMinSize(c.computeSize(r.width, -1));
                }
            });
        } else {
            this.createEmptyViewer(parent, Messages.ResourceExportWizardSelectionPage_NoClipart_title, Messages.ResourceExportWizardSelectionPage__NoClipart_Message);
        }
    }

    @Override
    public List<Object> getSelectedResources() {
        return this.viewer != null ? this.viewer.getSelectedItems() : Collections.emptyList();
    }

    @Override
    protected void selectAllItems(boolean selected) {
        this.viewer.selectAllItems(selected);
    }

    @Override
    public Map<Object, Image> getSelectedMap() {
        HashMap<Object, Image> map = new HashMap<Object, Image>();
        for (Object item : this.getSelectedResources()) {
            map.put(item, null);
        }
        return map;
    }

    @Override
    protected String getFeatureKey() {
        return "Clip Art Export";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClipArtPageViewer {
        private Composite control;
        private Map<Button, IGalleryGroup> checkToGalleryGroup = new HashMap<Button, IGalleryGroup>();
        private LocalResourceManager resources;

        public ClipArtPageViewer(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            this.control = composite;
            this.resources = new LocalResourceManager(JFaceResources.getResources());
        }

        public void setInput(List<IGalleryGroup> groups) {
            if (groups != null) {
                for (IGalleryGroup group : groups) {
                    this.createGroup(this.control, group);
                }
            }
        }

        private void createGroup(Composite parent, IGalleryGroup group) {
            final Composite composite = new Composite(parent, 2048);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setBackground(Display.getCurrent().getSystemColor(1));
            Button groupControl = new Button(composite, 32);
            this.checkToGalleryGroup.put(groupControl, group);
            groupControl.setText(group.getName());
            groupControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipArtResourcePage.this.checkAllSelectCheck();
                }
            });
            List items = group.getItems();
            final Composite markersContainer = new Composite(composite, 0);
            GridLayout layout = new GridLayout(6, false);
            markersContainer.setLayout((Layout)layout);
            markersContainer.setBackground(composite.getBackground());
            for (IGalleryItem item : items) {
                Label galleryLable = new Label(markersContainer, 0);
                Image image = this.getImage(item);
                galleryLable.setImage(image);
            }
            composite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = composite.getClientArea();
                    markersContainer.setLayout((Layout)new GridLayout(r.width / 85, false));
                    composite.layout();
                }
            });
        }

        private Image getImage(IGalleryItem item) {
            Image image = this.createImage(item);
            ImageData imageData = image.getImageData();
            if (imageData.width > 80) {
                return new Image(null, imageData.scaledTo(80, imageData.height * 80 / imageData.width));
            }
            return image;
        }

        private Image createImage(IGalleryItem item) {
            URL url = item.getURL();
            if (url != null) {
                return (Image)this.resources.get((DeviceResourceDescriptor)ImageDescriptor.createFromURL((URL)url));
            }
            return null;
        }

        public List<Object> getSelectedItems() {
            ArrayList<Object> selectedGroups = new ArrayList<Object>();
            Set<Button> keys = this.checkToGalleryGroup.keySet();
            for (Button checkedItem : keys) {
                if (!checkedItem.getSelection()) continue;
                selectedGroups.add(this.checkToGalleryGroup.get(checkedItem));
            }
            return selectedGroups;
        }

        public void selectAllItems(boolean select) {
            if (!this.checkToGalleryGroup.isEmpty()) {
                Set<Button> keys = this.checkToGalleryGroup.keySet();
                for (Button key : keys) {
                    key.setSelection(select);
                }
            }
        }
    }
}

