/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.xmind.core.Core;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.CloneHandler;
import org.xmind.ui.wizards.MindMapImporter;

public class WorkbookImporter
extends MindMapImporter {
    public WorkbookImporter(String sourcePath, IWorkbook targetWorkbook) {
        super(sourcePath, targetWorkbook);
    }

    @Override
    public void build() throws InvocationTargetException, InterruptedException {
        IWorkbook targetWorkbook = this.getTargetWorkbook();
        try {
            IWorkbook sourceWorkbook = Core.getWorkbookBuilder().loadFromPath(this.getSourcePath());
            CloneHandler cloneHandler = new CloneHandler().withWorkbooks(sourceWorkbook, targetWorkbook);
            for (ISheet sourceSheet : sourceWorkbook.getSheets()) {
                ISheet targetSheet = (ISheet)cloneHandler.cloneObject((Object)sourceSheet);
                if (targetSheet == null) continue;
                targetWorkbook.addSheet(targetSheet);
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        this.postBuilded();
    }
}

