/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.ImageData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IWorkbook;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;

public class AttachmentImageDescriptor
extends ImageDescriptor {
    private static ImageData MISSING_DATA = null;
    private IWorkbook workbook;
    private String path;

    protected AttachmentImageDescriptor(IWorkbook workbook, String path) {
        if (workbook == null) {
            throw new IllegalArgumentException("Workbook is null!");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path is null!");
        }
        this.workbook = workbook;
        this.path = path;
    }

    /*
     * Loose catch block
     */
    public ImageData getImageData() {
        ImageData imageData;
        block20: {
            imageData = null;
            InputStream in = this.getStream();
            if (in != null) {
                try {
                    imageData = new ImageData(in);
                }
                catch (Exception e) {
                    Logger.log(e, "Failed to get image data from attachment: " + this.path + " (" + this.workbook.toString() + ")");
                    imageData = AttachmentImageDescriptor.getMissingData();
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    break block20;
                }
                catch (SWTError e) {
                    Logger.log(e, "Failed to get image data from attachment: " + this.path + " (" + this.workbook.toString() + ")");
                    imageData = AttachmentImageDescriptor.getMissingData();
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    break block20;
                }
                catch (OutOfMemoryError e) {
                    Logger.log(e, "Image too large");
                    imageData = AttachmentImageDescriptor.getMissingData();
                    {
                        catch (Throwable throwable) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                    }
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    break block20;
                }
                try {
                    in.close();
                }
                catch (Exception exception) {}
            } else {
                imageData = AttachmentImageDescriptor.getMissingData();
            }
        }
        return imageData;
    }

    private InputStream getStream() {
        IFileEntry entry = this.workbook.getManifest().getFileEntry(this.path);
        if (entry == null) {
            Logger.log("Failed to get file entry by entry path: " + this.path);
            return null;
        }
        try {
            return new BufferedInputStream(entry.openInputStream());
        }
        catch (IOException iOException) {
            Logger.log("Failed to get input stream from workbook entry: " + this.path);
            return null;
        }
    }

    public String toString() {
        return "AttachmentImageDescriptor(workbook=" + this.workbook.toString() + ",path=" + this.path + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AttachmentImageDescriptor)) {
            return false;
        }
        AttachmentImageDescriptor that = (AttachmentImageDescriptor)((Object)obj);
        return this.workbook.equals(that.workbook) && this.path.equals(that.path);
    }

    public int hashCode() {
        return this.workbook.hashCode() + this.path.hashCode();
    }

    public static ImageDescriptor createFromEntryPath(IWorkbook workbook, String path) {
        return new AttachmentImageDescriptor(workbook, path);
    }

    public static ImageDescriptor createFromEntry(IWorkbook workbook, IFileEntry entry) {
        return new AttachmentImageDescriptor(workbook, entry.getPath());
    }

    private static ImageData getMissingData() {
        if (MISSING_DATA == null) {
            MISSING_DATA = MindMapUI.getImages().get("icons/misc/missing_image.png").getImageData();
        }
        return MISSING_DATA;
    }
}

