/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;

public class JSON {
    public static boolean DEBUG = false;

    private JSON() {
        throw new AssertionError((Object)"Should not instantiate this class");
    }

    public static JSONObject readObject(IInputSource source, String entryPath) throws IOException {
        InputStream stream = source.openEntryStream(entryPath);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(stream, "UTF-8");
            JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)reader));
            return jSONObject;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            stream.close();
        }
    }

    public static JSONObject readObjectWithDamageCheck(IStorage storage, String entryPath) throws IOException {
        InputStream stream = storage.getInputSource().openEntryStream(entryPath);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(stream, "UTF-8");
            JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)reader));
            return jSONObject;
        }
        catch (JSONException e) {
            storage.deleteEntry(entryPath);
            throw new IOException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            stream.close();
        }
    }

    public static JSONObject readOrCreateObject(IInputSource source, String entryPath) throws IOException {
        if (source.hasEntry(entryPath)) {
            return JSON.readObject(source, entryPath);
        }
        return new JSONObject();
    }

    public static JSONObject readOrCreateObjectWithDamageCheck(IStorage storage, String entryPath) throws IOException {
        IInputSource source = storage.getInputSource();
        if (source.hasEntry(entryPath)) {
            return JSON.readObjectWithDamageCheck(storage, entryPath);
        }
        return new JSONObject();
    }

    public static void writeObject(JSONObject object, IOutputTarget target, String entryPath) throws IOException {
        try (OutputStream stream = target.openEntryStream(entryPath);
             OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");){
            if (DEBUG) {
                writer.write(object.toString(4));
            } else {
                object.write((Writer)writer);
            }
        }
    }

    public static boolean removeFirst(JSONArray array, Object element) {
        int i = 0;
        while (i < array.length()) {
            Object o = array.get(i);
            if (o == element || o != null && o.equals(element)) {
                array.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean removeAll(JSONArray array, Object element) {
        boolean removed = false;
        int i = 0;
        while (i < array.length()) {
            Object o = array.get(i);
            if (o == element || o != null && o.equals(element)) {
                array.remove(i);
                removed = true;
                continue;
            }
            ++i;
        }
        return removed;
    }

    public static int indexOf(JSONArray array, Object element) {
        int i = 0;
        while (i < array.length()) {
            Object o = array.get(i);
            if (o == element || o != null && o.equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(JSONArray array, Object element) {
        int i = 0;
        while (i < array.length()) {
            Object o = array.get(i);
            if (o == element || o != null && o.equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static JSONObject extend(JSONObject obj, JSONObject ... extensions) {
        JSONObject[] jSONObjectArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            JSONObject ext = jSONObjectArray[n2];
            Iterator keyIt = ext.keys();
            while (keyIt.hasNext()) {
                String key = (String)keyIt.next();
                obj.put(key, ext.get(key));
            }
            ++n2;
        }
        return obj;
    }
}

