/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.HashMap;
import java.util.Map;
import org.xmind.core.IControlPoint;
import org.xmind.core.IIdentifiable;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.plain.ControlPoint;
import org.xmind.core.plain.Sheet;
import org.xmind.core.plain.Workbook;

public class Relationship
implements IRelationship,
ICoreEventSource {
    private final Workbook ownerWorkbook;
    private final String id;
    private Sheet parentSheet;
    private boolean orphan;
    private String titleText;
    private String styleId;
    private long modificationTime;
    private String modifiedBy;
    private String end1Id;
    private String end2Id;
    private Map<Integer, ControlPoint> controlPoints;

    public Relationship(Workbook ownerWorkbook, String id) {
        this.ownerWorkbook = ownerWorkbook;
        this.id = id;
        this.parentSheet = null;
        this.orphan = true;
        this.titleText = null;
        this.styleId = null;
        this.modificationTime = 0L;
        this.modifiedBy = null;
        this.end1Id = null;
        this.end2Id = null;
        this.controlPoints = new HashMap<Integer, ControlPoint>();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.ownerWorkbook);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setTitleText(String titleText) {
        String oldTitleText = this.titleText;
        if (oldTitleText == titleText || oldTitleText != null && oldTitleText.equals(titleText)) {
            return;
        }
        this.titleText = titleText;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "titleText", (Object)oldTitleText, (Object)titleText);
    }

    public String getTitleText() {
        return this.titleText == null ? "" : this.titleText;
    }

    public boolean hasTitle() {
        return this.titleText != null;
    }

    protected void setParent(Sheet parentSheet) {
        this.parentSheet = parentSheet;
    }

    protected void onParented() {
        this.orphan = false;
        this.ownerWorkbook.getObjectRegistry().register(this);
    }

    protected void onOrphan() {
        this.ownerWorkbook.getObjectRegistry().unregister((IIdentifiable)this);
        this.orphan = true;
    }

    public ISheet getOwnedSheet() {
        return this.parentSheet;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        String oldStyleId = this.styleId;
        if (styleId == oldStyleId || styleId != null && styleId.equals(oldStyleId)) {
            return;
        }
        this.styleId = styleId;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "style", (Object)oldStyleId, (Object)styleId);
    }

    public String getStyleType() {
        return "relationship";
    }

    public long getModifiedTime() {
        return this.modificationTime;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerWorkbook.getCoreEventSupport();
    }

    private IRelationshipEnd getEnd(String endId) {
        if (endId == null) {
            return null;
        }
        IIdentifiable end = this.ownerWorkbook.getObjectRegistry().get(endId);
        if (end instanceof IRelationshipEnd) {
            return (IRelationshipEnd)end;
        }
        return null;
    }

    public IRelationshipEnd getEnd1() {
        return this.getEnd(this.end1Id);
    }

    public String getEnd1Id() {
        return this.end1Id;
    }

    public IRelationshipEnd getEnd2() {
        return this.getEnd(this.end2Id);
    }

    public String getEnd2Id() {
        return this.end2Id;
    }

    public ISheet getParent() {
        return this.parentSheet;
    }

    public void setEnd1Id(String id) {
        String oldId = this.end1Id;
        if (id == oldId || id != null && id.equals(oldId)) {
            return;
        }
        this.end1Id = id;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "relationshipEnd1", (Object)oldId, (Object)id);
    }

    public void setEnd2Id(String id) {
        String oldId = this.end2Id;
        if (id == oldId || id != null && id.equals(oldId)) {
            return;
        }
        this.end2Id = id;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "relationshipEnd2", (Object)oldId, (Object)id);
    }

    public boolean checkAvailable() {
        ISheet sheet1;
        IRelationshipEnd end1 = this.getEnd1();
        IRelationshipEnd end2 = this.getEnd2();
        return end1 != null && end2 != null && (sheet1 = end1.getOwnedSheet()) != null && sheet1.equals(end2.getOwnedSheet());
    }

    public IControlPoint getControlPoint(int index) {
        Integer key = index;
        ControlPoint cp = this.controlPoints.get(key);
        if (cp == null) {
            cp = new ControlPoint(this, index);
            this.controlPoints.put(key, cp);
        }
        return cp;
    }
}

