/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.core.INamed;
import org.xmind.ui.internal.taskinfo.AssigneeItem;
import org.xmind.ui.internal.taskinfo.AssigneeSheet;
import org.xmind.ui.internal.taskinfo.AssigneeSheetManager;
import org.xmind.ui.internal.taskinfo.TaskMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeopleManagerPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    public static final String ID = "org.xmind.ui.internal.prefs.PeopleManagerPrefPage";
    private TableViewer assigneeViewer;
    private Button addAssignee;
    private Button removeAssignee;
    private Button renameAssignee;
    private List<AssigneeItemReference> addAssigneeReferences = new ArrayList<AssigneeItemReference>();
    private List<AssigneeItem> removeAssigneeReferences = new ArrayList<AssigneeItem>();

    public PeopleManagerPrefPage() {
        super(TaskMessages.PeoPlePage_title);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label descriptionLabel = new Label(composite, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        ((GridData)descriptionLabel.getLayoutData()).widthHint = 240;
        descriptionLabel.setText(TaskMessages.PeoplePage_message);
        this.createAssignees(composite);
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                List references = PeopleManagerPrefPage.this.getInput();
                PeopleManagerPrefPage.this.assigneeViewer.setInput((Object)references);
                if (!references.isEmpty()) {
                    PeopleManagerPrefPage.this.assigneeViewer.setSelection((ISelection)new StructuredSelection(references.get(0)));
                }
                PeopleManagerPrefPage.this.refreshButtons();
            }
        });
        return composite;
    }

    private Composite createAssignees(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(TaskMessages.PeoplePage_Assignees_label);
        Composite groupContainer = new Composite(composite, 0);
        groupContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        containerLayout.verticalSpacing = 5;
        containerLayout.horizontalSpacing = 5;
        groupContainer.setLayout((Layout)containerLayout);
        this.createGroupViewer(groupContainer);
        this.createGroupControls(groupContainer);
        return composite;
    }

    private List<AssigneeItemReference> getInput() {
        ArrayList<AssigneeItemReference> references = new ArrayList<AssigneeItemReference>();
        AssigneeSheet sheet = this.getSheet();
        for (AssigneeItem item : sheet.getAssignees()) {
            references.add(new AssigneeItemReference(item.getName(), item));
        }
        return references;
    }

    private void createGroupViewer(Composite parent) {
        this.assigneeViewer = new TableViewer(parent, 2052);
        this.assigneeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.assigneeViewer.getTable().setLinesVisible(true);
        this.assigneeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        final AssigneeLabelProvider labelProvider = new AssigneeLabelProvider();
        this.assigneeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.assigneeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PeopleManagerPrefPage.this.refreshButtons();
            }
        });
        this.assigneeViewer.setColumnProperties(new String[]{"NAME"});
        this.assigneeViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.assigneeViewer.getTable(), 4)});
        this.assigneeViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (element instanceof Widget) {
                    element = ((Widget)element).getData();
                }
                if (element instanceof AssigneeItemReference) {
                    PeopleManagerPrefPage.this.changeAssigneeNameReference((AssigneeItemReference)element, value.toString());
                }
            }

            public Object getValue(Object element, String property) {
                return labelProvider.getText(element);
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        this.assigneeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PeopleManagerPrefPage.this.renameSelectedAssigneeReference();
            }
        });
    }

    private void createGroupControls(Composite parent) {
        Composite outer = new Composite(parent, 0);
        outer.setLayoutData((Object)new GridData(4, 128, false, true));
        GridLayout outerLayout = new GridLayout(1, false);
        outerLayout.marginWidth = 0;
        outerLayout.marginHeight = 0;
        outerLayout.verticalSpacing = 0;
        outerLayout.horizontalSpacing = 0;
        outer.setLayout((Layout)outerLayout);
        Composite inner = new Composite(outer, 0);
        inner.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        GridLayout innerLayout = new GridLayout(1, false);
        innerLayout.marginWidth = 0;
        innerLayout.marginHeight = 0;
        innerLayout.verticalSpacing = 5;
        innerLayout.horizontalSpacing = 0;
        inner.setLayout((Layout)innerLayout);
        this.addAssignee = new Button(inner, 8);
        this.addAssignee.setText(TaskMessages.PeoplePage_AddAssignee_text);
        this.addAssignee.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.addAssignee, 13);
        this.removeAssignee = new Button(inner, 8);
        this.removeAssignee.setText(TaskMessages.PeoplePage_RemoveAssignee_text);
        this.removeAssignee.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.removeAssignee, 13);
        this.renameAssignee = new Button(inner, 8);
        this.renameAssignee.setText(TaskMessages.PeoplePage_RenameAssignee_text);
        this.renameAssignee.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hookWidget((Widget)this.renameAssignee, 13);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addAssignee) {
            this.addAssigneeReference();
        } else if (event.widget == this.removeAssignee) {
            this.removeSelectedAssigneeReferences();
        } else if (event.widget == this.renameAssignee) {
            this.renameSelectedAssigneeReference();
        }
    }

    private void addAssigneeReference() {
        String name = this.createAssigneeName();
        AssigneeItemReference item = new AssigneeItemReference(name, null);
        ((List)this.assigneeViewer.getInput()).add(item);
        this.addAssigneeReferences.add(item);
        this.assigneeViewer.refresh();
        this.assigneeViewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
        this.assigneeViewer.editElement((Object)item, 0);
    }

    private String createAssigneeName() {
        List references = (List)this.assigneeViewer.getInput();
        ArrayList<String> nameExclusions = new ArrayList<String>();
        for (AssigneeItemReference item : references) {
            nameExclusions.add(item.getName());
        }
        int index = references.size() + 1;
        String name = NLS.bind((String)TaskMessages.PeoplePage_DefaultAssigneeName, (Object)index);
        while (this.isNameExisting(name, nameExclusions)) {
            name = NLS.bind((String)TaskMessages.PeoplePage_DefaultAssigneeName, (Object)(++index));
        }
        return name;
    }

    private boolean isNameExisting(String name, List<String> nameExclusions) {
        return nameExclusions.contains(name);
    }

    private void removeSelectedAssigneeReferences() {
        IStructuredSelection selection = (IStructuredSelection)this.assigneeViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        List references = (List)this.assigneeViewer.getInput();
        int index = references.indexOf(selection.getFirstElement());
        for (Object item : selection.toList()) {
            if (!(item instanceof AssigneeItemReference)) continue;
            this.removeAssigneeReference((AssigneeItemReference)item);
        }
        this.assigneeViewer.refresh();
        if (index >= references.size()) {
            index = references.size() - 1;
        }
        if (index >= 0 && !references.isEmpty()) {
            this.assigneeViewer.setSelection((ISelection)new StructuredSelection(references.get(index)));
        }
    }

    private void removeAssigneeReference(AssigneeItemReference reference) {
        ((List)this.assigneeViewer.getInput()).remove(reference);
        if (reference.getItem() != null) {
            this.removeAssigneeReferences.add(reference.getItem());
        } else {
            this.addAssigneeReferences.remove(reference);
        }
    }

    private void renameSelectedAssigneeReference() {
        IStructuredSelection selection = (IStructuredSelection)this.assigneeViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.assigneeViewer.editElement(selection.getFirstElement(), 0);
    }

    private void changeAssigneeNameReference(AssigneeItemReference reference, String name) {
        if (name == null || "".equals(name) || this.containAsignee(name)) {
            return;
        }
        reference.setName(name);
        this.assigneeViewer.update((Object)reference, null);
    }

    private boolean containAsignee(String newName) {
        if (newName == null || "".equals(newName)) {
            return false;
        }
        List references = (List)this.assigneeViewer.getInput();
        ArrayList<String> nameExclusions = new ArrayList<String>();
        for (AssigneeItemReference item : references) {
            nameExclusions.add(item.getName());
        }
        return nameExclusions.contains(newName);
    }

    private void hookWidget(Widget widget, int eventType) {
        widget.addListener(eventType, (Listener)this);
    }

    public void init(IWorkbench workbench) {
    }

    private void refreshButtons() {
        IStructuredSelection groupSelection = (IStructuredSelection)this.assigneeViewer.getSelection();
        this.removeAssignee.setEnabled(!groupSelection.isEmpty());
        this.renameAssignee.setEnabled(!groupSelection.isEmpty());
    }

    public AssigneeSheet getSheet() {
        return AssigneeSheetManager.getInstance().getAssigneeSheet();
    }

    public void saveSheet() {
        AssigneeSheetManager.getInstance().saveAssigneeSheet();
    }

    public boolean performOk() {
        this.removeReferenceAssignees();
        this.addReferenceAssignees();
        this.renameNeededAssignees();
        this.saveSheet();
        return super.performOk();
    }

    private void removeReferenceAssignees() {
        for (AssigneeItem item : this.removeAssigneeReferences) {
            this.removeAssignee(item);
        }
        this.removeAssigneeReferences.clear();
    }

    private void addReferenceAssignees() {
        for (AssigneeItemReference item : this.addAssigneeReferences) {
            this.addAssignee(item);
        }
        this.addAssigneeReferences.clear();
    }

    private void removeAssignee(AssigneeItem item) {
        AssigneeSheet sheet = this.getSheet();
        sheet.removeAssigneeItem(item);
    }

    private void addAssignee(AssigneeItemReference reference) {
        String name = reference.getName();
        AssigneeItem item = this.getSheet().createAssignee();
        item.setName(name);
        this.getSheet().addAssigneeItem(item);
        reference.setItem(item);
    }

    private void renameNeededAssignees() {
        List references = (List)this.assigneeViewer.getInput();
        for (AssigneeItemReference item : references) {
            String oldName;
            String newName = item.getName();
            if (newName.equals(oldName = item.getItem().getName())) continue;
            this.changeAssigneeName(item.getItem(), newName);
        }
    }

    private void changeAssigneeName(AssigneeItem assignee, String name) {
        if (name == null || "".equals(name)) {
            return;
        }
        assignee.setName(name);
    }

    protected void performDefaults() {
        int size = ((List)this.assigneeViewer.getInput()).size();
        int i = 0;
        while (i < size) {
            Object element = this.assigneeViewer.getElementAt(i);
            if (element instanceof AssigneeItemReference) {
                this.removeAssigneeReference((AssigneeItemReference)element);
            }
            ++i;
        }
        super.performDefaults();
        this.assigneeViewer.refresh();
    }

    public void dispose() {
        if (this.addAssigneeReferences != null) {
            this.addAssigneeReferences.clear();
            this.addAssignee = null;
        }
        if (this.removeAssigneeReferences != null) {
            this.removeAssigneeReferences.clear();
            this.removeAssigneeReferences = null;
        }
        super.dispose();
    }

    private static class AssigneeItemReference
    implements INamed {
        private String name;
        private AssigneeItem item;

        public AssigneeItemReference(String name, AssigneeItem item) {
            this.name = name;
            this.item = item;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public AssigneeItem getItem() {
            return this.item;
        }

        public void setItem(AssigneeItem item) {
            this.item = item;
        }
    }

    private class AssigneeLabelProvider
    extends LabelProvider {
        private AssigneeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof INamed) {
                return ((INamed)element).getName();
            }
            return super.getText(element);
        }
    }
}

