/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.version;

import com.sun.javafx.runtime.VersionInfo;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class VersionChecker {
    private static final String javaFXVersion;
    private static final String controlsFXSpecTitle;
    private static final String controlsFXSpecVersion;
    private static final String controlsFXImpVersion;
    private static final Package controlsFX;
    private static Properties props;

    private VersionChecker() {
    }

    public static void doVersionCheck() {
        if (controlsFXSpecVersion == null) {
            return;
        }
        Comparable<Comparable>[] splitSpecVersion = VersionChecker.toComparable(controlsFXSpecVersion.split("\\."));
        Comparable<Comparable>[] splitJavaVersion = VersionChecker.toComparable(javaFXVersion.replace('-', '.').split("\\."));
        boolean notSupportedVersion = false;
        if (splitSpecVersion[0].compareTo(splitJavaVersion[0]) > 0) {
            notSupportedVersion = true;
        } else if (splitSpecVersion[0].compareTo(splitJavaVersion[0]) == 0 && splitSpecVersion[1].compareTo(splitJavaVersion[2]) > 0) {
            notSupportedVersion = true;
        }
        if (notSupportedVersion) {
            throw new RuntimeException("ControlsFX Error: ControlsFX " + controlsFXImpVersion + " requires at least " + controlsFXSpecTitle);
        }
    }

    private static Comparable<Comparable>[] toComparable(String[] tokens) {
        Comparable[] ret = new Comparable[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            try {
                ret[i] = new Integer(token);
                continue;
            }
            catch (NumberFormatException e) {
                ret[i] = token;
            }
        }
        return ret;
    }

    private static String getControlsFXSpecificationTitle() {
        try {
            return controlsFX.getSpecificationTitle();
        }
        catch (NullPointerException nullPointerException) {
            return VersionChecker.getPropertyValue("controlsfx_specification_title");
        }
    }

    private static String getControlsFXSpecificationVersion() {
        try {
            return controlsFX.getSpecificationVersion();
        }
        catch (NullPointerException nullPointerException) {
            return VersionChecker.getPropertyValue("controlsfx_specification_title");
        }
    }

    private static String getControlsFXImplementationVersion() {
        try {
            return controlsFX.getImplementationVersion();
        }
        catch (NullPointerException nullPointerException) {
            return VersionChecker.getPropertyValue("controlsfx_specification_title") + VersionChecker.getPropertyValue("artifact_suffix");
        }
    }

    private static synchronized String getPropertyValue(String key) {
        if (props == null) {
            try {
                File file = new File("../controlsfx-build.properties");
                if (file.exists()) {
                    props.load(new FileReader(file));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return props.getProperty(key);
    }

    static {
        controlsFX = VersionChecker.class.getPackage();
        javaFXVersion = VersionInfo.getVersion();
        controlsFXSpecTitle = VersionChecker.getControlsFXSpecificationTitle();
        controlsFXSpecVersion = VersionChecker.getControlsFXSpecificationVersion();
        controlsFXImpVersion = VersionChecker.getControlsFXImplementationVersion();
    }
}

