/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import ch.randelshofer.quaqua.QuaquaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.NumberFormatter;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.gui.DrawingAttributeEditorHandler;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class EditCanvasPanel
extends JPanel {
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
    private Drawing drawing;
    private JAttributeSlider opacitySlider;
    private JColorChooser colorChooser;
    private DrawingAttributeEditorHandler<Double> opacityFieldHandler;
    private DrawingAttributeEditorHandler<Double> opacitySliderHandler;
    private ButtonGroup bgColorButtonGroup;
    private JButton colorButton;
    private JLabel colorLabel;
    private JAttributeTextField opacityField;
    private JLabel opacityLabel;
    private JPopupButton opacityPopupButton;

    public EditCanvasPanel() {
        this.initComponents();
        this.colorButton.putClientProperty("Quaqua.Button.style", "colorWell");
        this.opacitySlider = new JAttributeSlider(1, 0, 100, 100);
        this.opacityPopupButton.add(this.opacitySlider);
        this.opacityPopupButton.putClientProperty("JButton.buttonType", "toolbar");
        this.add(this.opacityPopupButton);
        NumberFormatter nf = new NumberFormatter();
        nf.setMaximum(Double.valueOf(1.0));
        nf.setMinimum(Double.valueOf(0.0));
        this.opacityField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1.0, 100.0));
        this.opacityFieldHandler = new DrawingAttributeEditorHandler<Double>(AttributeKeys.CANVAS_FILL_OPACITY, this.opacityField, null);
        this.opacitySliderHandler = new DrawingAttributeEditorHandler<Double>(AttributeKeys.CANVAS_FILL_OPACITY, this.opacitySlider, null);
    }

    private JColorChooser getColorChooser() {
        if (this.colorChooser == null) {
            this.colorChooser = new JColorChooser();
        }
        return this.colorChooser;
    }

    public void setDrawing(Drawing newValue) {
        this.drawing = newValue;
        this.opacitySliderHandler.setDrawing(this.drawing);
        this.opacityFieldHandler.setDrawing(this.drawing);
        this.updatePanel();
    }

    private void updateDrawing() {
        if (this.drawing != null) {
            this.drawing.fireUndoableEditHappened(AttributeKeys.CANVAS_FILL_COLOR.setUndoable(this.drawing, this.colorButton.getBackground()));
        }
    }

    private void updatePanel() {
        if (this.drawing != null) {
            this.colorButton.setBackground(AttributeKeys.CANVAS_FILL_COLOR.get(this.drawing));
        }
    }

    public Drawing getDrawing() {
        return this.drawing;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new QuaquaLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        JFrame f = new JFrame("Drawing Settings2");
        f.setDefaultCloseOperation(3);
        f.add(new EditCanvasPanel());
        f.pack();
        f.setVisible(true);
    }

    private void initComponents() {
        this.bgColorButtonGroup = new ButtonGroup();
        this.colorLabel = new JLabel();
        this.colorButton = new JButton();
        this.opacityLabel = new JLabel();
        this.opacityField = new JAttributeTextField();
        this.opacityPopupButton = new JPopupButton();
        this.setLayout(new GridBagLayout());
        this.colorLabel.setText(this.labels.getString("attribute.canvasFillColor.text"));
        this.colorLabel.setToolTipText(this.labels.getString("attribute.backgroundColor.toolTipText"));
        this.add((Component)this.colorLabel, new GridBagConstraints());
        this.colorButton.setText(" ");
        this.colorButton.setToolTipText(this.labels.getString("attribute.backgroundColor.toolTipText"));
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditCanvasPanel.this.colorButtonPerformed(evt);
            }
        });
        this.add((Component)this.colorButton, new GridBagConstraints());
        this.opacityLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/attributeOpacity.png")));
        this.opacityLabel.setToolTipText(this.labels.getString("attribute.opacity.toolTipText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.opacityLabel, gridBagConstraints);
        this.opacityField.setColumns(3);
        this.add((Component)this.opacityField, new GridBagConstraints());
        this.opacityPopupButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/popupIcon.png")));
        this.opacityPopupButton.setToolTipText(this.labels.getString("attribute.opacity.toolTipText"));
        this.add((Component)this.opacityPopupButton, new GridBagConstraints());
    }

    private void colorButtonPerformed(ActionEvent evt) {
        if (this.drawing != null) {
            this.getColorChooser();
            Color color = JColorChooser.showDialog(this, this.labels.getString("attribute.backgroundColor"), AttributeKeys.CANVAS_FILL_COLOR.get(this.drawing));
            this.colorButton.setBackground(color);
            this.updateDrawing();
        }
    }
}

