/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class RedoAction
extends AbstractViewAction {
    public static final String ID = "edit.redo";
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
    private PropertyChangeListener redoActionPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "Name") {
                RedoAction.this.putValue("Name", evt.getNewValue());
            } else if (name == "enabled") {
                RedoAction.this.updateEnabledState();
            }
        }
    };

    public RedoAction(Application app) {
        super(app);
        this.labels.configureAction(this, ID);
    }

    protected void updateEnabledState() {
        boolean isEnabled = false;
        Action realRedoAction = this.getRealRedoAction();
        if (realRedoAction != null) {
            isEnabled = realRedoAction.isEnabled();
        }
        this.setEnabled(isEnabled);
    }

    @Override
    protected void updateView(View oldValue, View newValue) {
        super.updateView(oldValue, newValue);
        if (newValue != null && newValue.getAction(ID) != null) {
            this.putValue("Name", newValue.getAction(ID).getValue("Name"));
            this.updateEnabledState();
        }
    }

    @Override
    protected void installViewListeners(View p) {
        super.installViewListeners(p);
        if (p.getAction(ID) != null) {
            p.getAction(ID).addPropertyChangeListener(this.redoActionPropertyListener);
        }
    }

    @Override
    protected void uninstallViewListeners(View p) {
        super.uninstallViewListeners(p);
        if (p.getAction(ID) != null) {
            p.getAction(ID).removePropertyChangeListener(this.redoActionPropertyListener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Action realRedoAction = this.getRealRedoAction();
        if (realRedoAction != null) {
            realRedoAction.actionPerformed(e);
        }
    }

    private Action getRealRedoAction() {
        return this.getActiveView() == null ? null : this.getActiveView().getAction(ID);
    }
}

