/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.security.cert.X509Extension;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import net.sf.portecle.FPortecle;
import net.sf.portecle.crypto.X509Ext;

class ExtensionsTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{FPortecle.RB.getString("ExtensionsTableModel.CriticalColumn"), FPortecle.RB.getString("ExtensionsTableModel.NameColumn"), FPortecle.RB.getString("ExtensionsTableModel.OidColumn")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, String.class, String.class};
    private Object[][] m_data = new Object[0][this.getColumnCount()];

    public void load(X509Extension x509Extension) {
        X509Ext x509Ext;
        byte[] byArray;
        Set<String> set = x509Extension.getCriticalExtensionOIDs();
        Set<String> set2 = x509Extension.getNonCriticalExtensionOIDs();
        this.m_data = new Object[set.size() + set2.size()][this.getColumnCount()];
        int n = 0;
        for (String string : set) {
            byArray = x509Extension.getExtensionValue(string);
            x509Ext = new X509Ext(string, byArray, true);
            this.loadRow(x509Ext, n++);
        }
        for (String string : set2) {
            byArray = x509Extension.getExtensionValue(string);
            x509Ext = new X509Ext(string, byArray, false);
            this.loadRow(x509Ext, n++);
        }
        this.fireTableDataChanged();
    }

    private void loadRow(X509Ext x509Ext, int n) {
        int n2 = 0;
        this.m_data[n][n2++] = x509Ext.isCriticalExtension();
        this.m_data[n][n2++] = x509Ext.getName();
        this.m_data[n][n2++] = x509Ext.getOid();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_CLASSES.length;
    }

    @Override
    public int getRowCount() {
        return this.m_data.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.m_data[n][n2];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return COLUMN_CLASSES[n];
    }
}

