/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFWriter;

class PDFDelayUtils {
    static final double[] DEFAULT_DOMAIN = new double[]{0.0, 1.0};
    static final double[] DEFAULT_RANGE = new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0};

    private PDFDelayUtils() {
    }

    static void writeCyclicShading(String string, WriteContext writeContext, FunctionData functionData, PDFRef pDFRef, PDFDictionary pDFDictionary) throws IOException {
        int n;
        PDFDictionary pDFDictionary2 = pDFDictionary.openDictionary(string);
        pDFDictionary2.entry("ShadingType", 2);
        pDFDictionary2.entry("ColorSpace", writeContext.pdf.name(writeContext.getColorSpace()));
        pDFDictionary2.entry("Coords", writeContext.getCoords(functionData));
        pDFDictionary2.entry("Domain", DEFAULT_DOMAIN);
        PDFDictionary pDFDictionary3 = pDFDictionary2.openDictionary("Function");
        pDFDictionary3.entry("FunctionType", 3);
        pDFDictionary3.entry("Domain", DEFAULT_DOMAIN);
        pDFDictionary3.entry("Range", writeContext.getRange());
        double d = 1.0 / (double)functionData.count;
        double[] dArray = new double[functionData.count - 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d * (double)(i + 1);
        }
        pDFDictionary3.entry("Bounds", dArray);
        double[] dArray2 = new double[2 * functionData.count];
        boolean bl = functionData.startInDirection;
        for (int i = 0; i < dArray2.length; ++i) {
            n = i % 2;
            double d2 = dArray2[i] = bl ? (double)n : (double)((n + 1) % 2);
            if (n != 1) continue;
            bl = !bl;
        }
        pDFDictionary3.entry("Encode", dArray2);
        Object[] objectArray = new PDFRef[functionData.count];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = pDFRef;
        }
        pDFDictionary3.entry("Functions", objectArray);
        pDFDictionary2.close(pDFDictionary3);
        pDFDictionary.close(pDFDictionary2);
    }

    private static final class Transform {
        private final double cos;
        private final double sin;
        private final double ds_tx;
        private final double ds_ty;

        Transform(double d, double d2, double d3, double d4) {
            this.cos = d;
            this.sin = d2;
            this.ds_tx = d3;
            this.ds_ty = d4;
        }

        double toGsX(double d, double d2) {
            return this.cos * (d - this.ds_tx) + this.sin * (d2 - this.ds_ty);
        }

        double toGsY(double d, double d2) {
            return -this.sin * (d - this.ds_tx) + this.cos * (d2 - this.ds_ty);
        }

        double toDsX(double d, double d2) {
            return this.cos * d - this.sin * d2 + this.ds_tx;
        }

        double toDsY(double d, double d2) {
            return this.sin * d + this.cos * d2 + this.ds_ty;
        }
    }

    static final class FunctionData {
        final double ds_srcX;
        final double ds_srcY;
        final double ds_tgtX;
        final double ds_tgtY;
        final int[] ds_bnds;
        final int count;
        final boolean startInDirection;

        private FunctionData(double d, double d2, double d3, double d4) {
            this(d, d2, d3, d4, 1, true, null);
        }

        private FunctionData(double d, double d2, double d3, double d4, int n, boolean bl, double[] dArray) {
            this.ds_srcX = d;
            this.ds_srcY = d2;
            this.ds_tgtX = d3;
            this.ds_tgtY = d4;
            if (dArray == null) {
                this.ds_bnds = null;
            } else {
                this.ds_bnds = new int[4];
                this.ds_bnds[0] = (int)Math.floor(dArray[0]);
                this.ds_bnds[1] = (int)Math.floor(dArray[1]);
                this.ds_bnds[2] = (int)Math.ceil(dArray[2]);
                this.ds_bnds[3] = (int)Math.ceil(dArray[3]);
            }
            this.count = n;
            this.startInDirection = bl;
        }

        static FunctionData newInstance(GradientPaint gradientPaint, Rectangle rectangle) {
            boolean bl;
            double d;
            int n;
            double d2;
            double d3;
            double d4;
            double d5;
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            double d6 = point2D.getX();
            double d7 = point2D.getY();
            double d8 = point2D2.getX();
            double d9 = d8 - d6;
            double d10 = d9 * d9 + (d5 = (d4 = point2D2.getY()) - d7) * d5;
            if (d10 == 0.0) {
                return new FunctionData(d6, d7, d8, d4);
            }
            double d11 = Math.sqrt(d10);
            double d12 = rectangle.getX();
            double d13 = rectangle.getY();
            double d14 = rectangle.getWidth();
            double d15 = rectangle.getHeight();
            Transform transform = new Transform(d9 / d11, d5 / d11, d12 + d14 * 0.5, d13 + d15 * 0.5);
            double[][] dArray = new double[4][2];
            dArray[0][0] = transform.toGsX(d12, d13);
            dArray[0][1] = transform.toGsY(d12, d13);
            dArray[1][0] = transform.toGsX(d12 + d14, d13);
            dArray[1][1] = transform.toGsY(d12 + d14, d13);
            dArray[2][0] = transform.toGsX(d12 + d14, d13 + d15);
            dArray[2][1] = transform.toGsY(d12 + d14, d13 + d15);
            dArray[3][0] = transform.toGsX(d12, d13 + d15);
            dArray[3][1] = transform.toGsY(d12, d13 + d15);
            double[] dArray2 = new double[4];
            FunctionData.calcBounds(dArray, dArray2);
            double d16 = dArray2[0];
            double d17 = dArray2[1];
            double d18 = dArray2[2];
            double d19 = dArray2[3];
            double d20 = transform.toDsX(d16, d17);
            double d21 = transform.toDsY(d16, d17);
            double d22 = transform.toDsX(d18, d17);
            double d23 = transform.toDsY(d18, d17);
            double d24 = d22 - d20;
            double d25 = d23 - d21;
            double d26 = d24 * d24 + d25 * d25;
            if (d26 == 0.0) {
                return new FunctionData(d6, d7, d8, d4);
            }
            double d27 = ((d6 - d20) * d24 + (d7 - d21) * d25) / d26;
            double d28 = d20 + d27 * d24;
            double d29 = d21 + d27 * d25;
            double d30 = transform.toGsX(d28, d29);
            if (d30 < d16) {
                d3 = Math.floor((d16 - d30) / d11);
                d2 = d3 * d11 + d30;
                n = (int)Math.ceil((d18 - d2) / d11);
                d = (double)n * d11 + d2;
                bl = (int)d3 % 2 == 0;
            } else if (d30 > d18) {
                d3 = Math.floor((d30 - d18) / d11);
                d = d30 - d3 * d11;
                n = (int)Math.ceil((d - d16) / d11);
                d2 = d - (double)n * d11;
                bl = ((int)d3 + n) % 2 == 0;
            } else {
                d3 = Math.ceil((d30 - d16) / d11);
                d2 = d30 - d3 * d11;
                d = Math.ceil((d18 - d30) / d11) * d11 + d30;
                n = (int)Math.round((d - d2) / d11);
                bl = (int)d3 % 2 == 0;
            }
            d3 = transform.toDsX(d2, d17);
            double d31 = transform.toDsY(d2, d17);
            double d32 = transform.toDsX(d, d17);
            double d33 = transform.toDsY(d, d17);
            dArray[0][0] = d3;
            dArray[0][1] = d31;
            dArray[1][0] = d32;
            dArray[1][1] = d33;
            dArray[2][0] = transform.toDsX(d, d19);
            dArray[2][1] = transform.toDsY(d, d19);
            dArray[3][0] = transform.toDsX(d2, d19);
            dArray[3][1] = transform.toDsY(d2, d19);
            FunctionData.calcBounds(dArray, dArray2);
            return new FunctionData(d3, d31, d32, d33, n, bl, dArray2);
        }

        private static void calcBounds(double[][] dArray, double[] dArray2) {
            dArray2[0] = dArray[0][0];
            dArray2[2] = dArray[0][0];
            dArray2[1] = dArray[0][1];
            dArray2[3] = dArray[0][1];
            for (int i = 1; i < dArray.length; ++i) {
                double d;
                double d2 = dArray[i][0];
                if (dArray2[2] < d2) {
                    dArray2[2] = d2;
                }
                if (dArray2[0] > d2) {
                    dArray2[0] = d2;
                }
                if (dArray2[3] < (d = dArray[i][1])) {
                    dArray2[3] = d;
                }
                if (!(dArray2[1] > d)) continue;
                dArray2[1] = d;
            }
        }
    }

    private static final class ColorKey {
        private final int r0;
        private final int g0;
        private final int b0;
        private final int r1;
        private final int g1;
        private final int b1;
        private final int hashCode;

        ColorKey(Color color, Color color2) {
            this.r0 = color.getRed();
            this.g0 = color.getGreen();
            this.b0 = color.getBlue();
            this.r1 = color2.getRed();
            this.g1 = color2.getGreen();
            this.b1 = color2.getBlue();
            this.hashCode = this.hashCodeImpl();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ColorKey colorKey = (ColorKey)object;
            if (this.b0 != colorKey.b0) {
                return false;
            }
            if (this.b1 != colorKey.b1) {
                return false;
            }
            if (this.g0 != colorKey.g0) {
                return false;
            }
            if (this.g1 != colorKey.g1) {
                return false;
            }
            if (this.r0 != colorKey.r0) {
                return false;
            }
            return this.r1 == colorKey.r1;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int hashCodeImpl() {
            int n = this.r0;
            n = 31 * n + this.g0;
            n = 31 * n + this.b0;
            n = 31 * n + this.r1;
            n = 31 * n + this.g1;
            n = 31 * n + this.b1;
            return n;
        }
    }

    static abstract class WriteContext {
        final PDFWriter pdf;
        final Map functions;
        final double[] shared3;
        final double[] shared4;
        final double[] shared6;

        WriteContext(PDFWriter pDFWriter) {
            this.pdf = pDFWriter;
            this.functions = new HashMap();
            this.shared3 = new double[3];
            this.shared4 = new double[4];
            this.shared6 = new double[6];
        }

        double[] getCoords(Entry entry) {
            Point2D point2D = entry.paint.getPoint1();
            Point2D point2D2 = entry.paint.getPoint2();
            this.shared4[0] = point2D.getX();
            this.shared4[1] = point2D.getY();
            this.shared4[2] = point2D2.getX();
            this.shared4[3] = point2D2.getY();
            return this.shared4;
        }

        double[] getCoords(FunctionData functionData) {
            this.shared4[0] = functionData.ds_srcX;
            this.shared4[1] = functionData.ds_srcY;
            this.shared4[2] = functionData.ds_tgtX;
            this.shared4[3] = functionData.ds_tgtY;
            return this.shared4;
        }

        PDFRef addFunction(Entry entry, boolean bl) throws IOException {
            if (bl) {
                return this.addFunction(entry.paint.getColor1(), entry.paint.getColor2(), entry.name + "Function0");
            }
            return this.addFunction(entry.paint.getColor2(), entry.paint.getColor1(), entry.name + "Function1");
        }

        private PDFRef addFunction(Color color, Color color2, String string) throws IOException {
            ColorKey colorKey = new ColorKey(color, color2);
            PDFRef pDFRef = (PDFRef)this.functions.get(colorKey);
            if (pDFRef == null) {
                PDFDictionary pDFDictionary = this.pdf.openDictionary(string);
                pDFDictionary.entry("FunctionType", 2);
                pDFDictionary.entry("Domain", DEFAULT_DOMAIN);
                pDFDictionary.entry("Range", this.getRange());
                pDFDictionary.entry("C0", this.asArray(color));
                pDFDictionary.entry("C1", this.asArray(color2));
                pDFDictionary.entry("N", 1);
                this.pdf.close(pDFDictionary);
                pDFRef = this.pdf.ref(string);
                this.functions.put(colorKey, pDFRef);
            }
            return pDFRef;
        }

        abstract double[] getRange();

        abstract double[] asArray(Color var1);

        abstract String getColorSpace();
    }

    static final class Entry {
        final GradientPaint paint;
        final Rectangle bnds;
        final AffineTransform transform;
        final String name;
        byte state;

        Entry(String string, GradientPaint gradientPaint, Rectangle rectangle, AffineTransform affineTransform) {
            this.paint = gradientPaint;
            this.bnds = rectangle;
            this.transform = affineTransform;
            this.name = string;
        }
    }
}

